/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.WSDLInterceptor;
import com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor;
import com.predic8.membrane.core.interceptor.server.WSDLPublisherInterceptor;
import com.predic8.membrane.core.interceptor.soap.WebServiceExplorerInterceptor;
import com.predic8.membrane.core.resolver.HTTPSchemaResolver;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.ServiceProxyKey;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.URLUtil;
import com.predic8.membrane.core.ws.relocator.Relocator;
import com.predic8.wsdl.AbstractBinding;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Port;
import com.predic8.wsdl.Service;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="soapProxy")
public class SOAPProxy
extends AbstractServiceProxy {
    private static final Logger log = LoggerFactory.getLogger((String)SOAPProxy.class.getName());
    private static final Pattern relativePathPattern = Pattern.compile("^./[^/?]*\\?");
    protected String wsdl;
    protected String portName;
    protected String targetPath;
    protected HttpClientConfiguration httpClientConfig;
    protected ResolverMap resolverMap;
    private int automaticallyAddedInterceptorCount;

    public SOAPProxy() {
        this.key = new ServiceProxyKey(80);
    }

    @Override
    protected AbstractProxy getNewInstance() {
        return new SOAPProxy();
    }

    private void parseWSDL() throws Exception {
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setInput((Object)ResolverMap.combine(this.router.getBaseLocation(), this.wsdl));
        try {
            List ports;
            Port port;
            String location;
            WSDLParser wsdlParser = new WSDLParser();
            wsdlParser.setResourceResolver((Object)this.resolverMap.toExternalResolver().toExternalResolver());
            Definitions definitions = wsdlParser.parse(ctx);
            List services = definitions.getServices();
            if (services.size() != 1) {
                throw new IllegalArgumentException("There are " + services.size() + " services defined in the WSDL, but exactly 1 is required for soapProxy.");
            }
            Service service = (Service)services.get(0);
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                String string = this.name = StringUtils.isEmpty((CharSequence)service.getName()) ? definitions.getName() : service.getName();
            }
            if ((location = (port = SOAPProxy.selectPort(ports = service.getPorts(), this.portName)).getAddress().getLocation()) == null) {
                throw new IllegalArgumentException("In the WSDL, there is no @location defined on the port.");
            }
            try {
                URL url = new URL(location);
                if (this.wsdl.startsWith("service:")) {
                    this.target.setUrl(this.wsdl.substring(0, this.wsdl.indexOf(47)));
                } else {
                    this.target.setHost(url.getHost());
                    if (url.getPort() != -1) {
                        this.target.setPort(url.getPort());
                    } else {
                        this.target.setPort(url.getDefaultPort());
                    }
                }
                if (this.key.getPath() == null) {
                    this.key.setUsePathPattern(true);
                    this.key.setPathRegExp(false);
                    this.key.setPath(url.getPath());
                } else {
                    Object query = "";
                    if (url.getQuery() != null) {
                        query = "?" + url.getQuery();
                    }
                    this.targetPath = url.getPath() + (String)query;
                }
                if (location.startsWith("https")) {
                    SSLParser sslOutboundParser = new SSLParser();
                    this.target.setSslParser(sslOutboundParser);
                }
                ((ServiceProxyKey)this.key).setMethod("*");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("WSDL endpoint location '" + location + "' is not an URL.", e);
            }
            return;
        }
        catch (Exception e) {
            Throwable f = e;
            while (f.getCause() != null && !(f instanceof ResourceRetrievalException)) {
                f = f.getCause();
            }
            if (f instanceof ResourceRetrievalException) {
                ResourceRetrievalException rre = (ResourceRetrievalException)f;
                if (rre.getStatus() >= 400) {
                    throw rre;
                }
                Throwable cause = rre.getCause();
                if (cause != null) {
                    if (cause instanceof UnknownHostException) {
                        throw (UnknownHostException)cause;
                    }
                    if (cause instanceof ConnectException) {
                        throw (ConnectException)cause;
                    }
                }
            }
            throw new IllegalArgumentException("Could not download the WSDL '" + this.wsdl + "'.", e);
        }
    }

    public static Port selectPort(List<Port> ports, String portName) {
        if (portName != null) {
            for (Port port : ports) {
                if (!portName.equals(port.getName())) continue;
                return port;
            }
            throw new IllegalArgumentException("No port with name '" + portName + "' found.");
        }
        Port port = SOAPProxy.getPortByNamespace(ports, "http://schemas.xmlsoap.org/wsdl/soap/");
        if (port == null) {
            port = SOAPProxy.getPortByNamespace(ports, "http://schemas.xmlsoap.org/wsdl/soap12/");
        }
        if (port == null) {
            throw new IllegalArgumentException("No SOAP/1.1 or SOAP/1.2 ports found in WSDL.");
        }
        return port;
    }

    private static Port getPortByNamespace(List<Port> ports, String namespace) {
        for (Port port : ports) {
            try {
                AbstractBinding binding;
                if (port.getBinding() == null || port.getBinding().getBinding() == null || !"http://schemas.xmlsoap.org/soap/http".equals((binding = port.getBinding().getBinding()).getProperty("transport")) || !namespace.equals(((QName)binding.getElementName()).getNamespaceURI())) continue;
                return port;
            }
            catch (Exception e) {
                log.warn("Error inspecting WSDL port binding.", (Throwable)e);
            }
        }
        return null;
    }

    public void configure() throws Exception {
        WSDLInterceptor wsdlInterceptor;
        boolean hasRewriter;
        boolean hasPublisher;
        this.parseWSDL();
        while (this.automaticallyAddedInterceptorCount > 0) {
            this.interceptors.remove(0);
            --this.automaticallyAddedInterceptorCount;
        }
        WebServiceExplorerInterceptor sui = new WebServiceExplorerInterceptor();
        sui.setWsdl(this.wsdl);
        sui.setPortName(this.portName);
        this.interceptors.add(0, sui);
        ++this.automaticallyAddedInterceptorCount;
        boolean bl = hasPublisher = this.getInterceptorOfType(WSDLPublisherInterceptor.class) != null;
        if (!hasPublisher) {
            WSDLPublisherInterceptor wp = new WSDLPublisherInterceptor();
            wp.setWsdl(this.wsdl);
            this.interceptors.add(0, wp);
            ++this.automaticallyAddedInterceptorCount;
        }
        boolean bl2 = hasRewriter = (wsdlInterceptor = this.getInterceptorOfType(WSDLInterceptor.class)) != null;
        if (!hasRewriter) {
            wsdlInterceptor = new WSDLInterceptor();
            this.interceptors.add(0, wsdlInterceptor);
            ++this.automaticallyAddedInterceptorCount;
        }
        if (this.key.getPath() != null) {
            final String keyPath = this.key.getPath();
            final String name = URLUtil.getName(this.router.getUriFactory(), keyPath);
            wsdlInterceptor.setPathRewriter(new Relocator.PathRewriter(){

                @Override
                public String rewrite(String path2) {
                    try {
                        if (path2.contains("://")) {
                            path2 = new URL(new URL(path2), keyPath).toString();
                        } else {
                            Matcher m = relativePathPattern.matcher(path2);
                            path2 = m.replaceAll("./" + name + "?");
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    return path2;
                }
            });
        }
        if (hasRewriter && !hasPublisher) {
            log.warn("A <soapProxy> contains a <wsdlRewriter>, but no <wsdlPublisher>. Probably you want to insert a <wsdlPublisher> just after the <wsdlRewriter>. (Or, if this is a valid use case, please notify us at info@predic8.de.)");
        }
        if (this.targetPath != null) {
            RewriteInterceptor ri = new RewriteInterceptor();
            ri.setMappings(Lists.newArrayList((Object[])new RewriteInterceptor.Mapping[]{new RewriteInterceptor.Mapping("^" + Pattern.quote(this.key.getPath()), Matcher.quoteReplacement(this.targetPath), "rewrite")}));
            this.interceptors.add(0, ri);
            ++this.automaticallyAddedInterceptorCount;
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.wsdl == null) {
            return;
        }
        this.resolverMap = this.router.getResolverMap();
        if (this.httpClientConfig != null) {
            HTTPSchemaResolver httpSR = new HTTPSchemaResolver(this.router.getHttpClientFactory());
            httpSR.setHttpClientConfig(this.httpClientConfig);
            this.resolverMap = this.resolverMap.clone();
            this.resolverMap.addSchemaResolver(httpSR);
        }
        this.configure();
    }

    private <T extends Interceptor> T getInterceptorOfType(Class<T> class1) {
        for (Interceptor i : this.interceptors) {
            if (!class1.isInstance(i)) continue;
            return (T)i;
        }
        return null;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    @MCAttribute
    @Required
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getPortName() {
        return this.portName;
    }

    @MCAttribute
    public void setPortName(String portName) {
        this.portName = portName;
    }

    public HttpClientConfiguration getWsdlHttpClientConfig() {
        return this.httpClientConfig;
    }

    @MCAttribute
    public void setWsdlHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }
}

