/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.sslinterceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.sslinterceptor.SSLInterceptor;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLExchange;
import com.predic8.membrane.core.transport.ssl.TLSError;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@MCElement(id="sslProxy-gatekeeper", name="gatekeeper", topLevel=false)
public class GateKeeperClientInterceptor
implements SSLInterceptor {
    protected String name = "gatekeeper";
    private String url;
    private HttpClientConfiguration httpClientConfiguration;
    private HttpClient httpClient;
    private ObjectMapper om = new ObjectMapper();
    Cache<String, Map> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public void init(Router router) throws Exception {
        this.httpClient = router.getHttpClientFactory().createClient(this.httpClientConfiguration);
    }

    @Override
    public Outcome handleRequest(SSLExchange exc) throws Exception {
        String ruleName = exc.getRule().getName();
        String clientIP = exc.getRemoteAddrIp();
        String body = this.om.writeValueAsString((Object)ImmutableMap.builder().put((Object)"rule", (Object)ruleName).put((Object)"clientIP", (Object)clientIP).build());
        Map result = (Map)this.cache.getIfPresent((Object)body);
        if (result == null) {
            result = this.getResult(body);
        }
        if (result.get("error") != null) {
            return this.createResponse(exc);
        }
        boolean gate = (Boolean)result.get("gate");
        if (gate) {
            this.cache.put((Object)body, (Object)result);
            return Outcome.CONTINUE;
        }
        return this.createResponse(exc);
    }

    private Map getResult(String body) throws Exception {
        Exchange exc2 = this.httpClient.call(new Request.Builder().post(this.url).header("Content-Type", "application/json").body(body).buildExchange());
        if (exc2.getResponse().getStatusCode() != 200) {
            return ImmutableMap.of((Object)"error", (Object)("status " + exc2.getResponse().getStatusCode()));
        }
        return ImmutableMap.copyOf((Map)((Map)this.om.readValue(exc2.getResponse().getBodyAsStreamDecoded(), Map.class)));
    }

    private Outcome createResponse(SSLExchange exc) {
        exc.setError(TLSError.access_denied);
        return Outcome.RETURN;
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCChildElement(order=10)
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }
}

