/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.DispatchingInterceptor;
import com.predic8.membrane.core.interceptor.ExchangeStoreInterceptor;
import com.predic8.membrane.core.interceptor.HTTPClientInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.LoggingContextInterceptor;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.interceptor.UserFeatureInterceptor;
import com.predic8.membrane.core.interceptor.rewrite.ReverseProxyingInterceptor;
import com.predic8.membrane.core.model.IPortChangeListener;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.TimerManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class Transport {
    protected Set<IPortChangeListener> menuListeners = new HashSet<IPortChangeListener>();
    private List<Interceptor> interceptors = new Vector<Interceptor>();
    private Router router;
    private boolean printStackTrace = false;
    private boolean reverseDNS = true;
    int concurrentConnectionLimitPerIp = 60;

    public String getOpenBackendConnections(int port) {
        return "N/A";
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement(allowForeign=true)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void init(Router router) throws Exception {
        this.router = router;
        if (this.interceptors.isEmpty()) {
            this.interceptors.add(new RuleMatchingInterceptor());
            this.interceptors.add(new LoggingContextInterceptor());
            this.interceptors.add(new ExchangeStoreInterceptor(router.getExchangeStore()));
            this.interceptors.add(new DispatchingInterceptor());
            this.interceptors.add(new ReverseProxyingInterceptor());
            this.interceptors.add(new UserFeatureInterceptor());
            this.interceptors.add(new HTTPClientInterceptor());
        }
        for (Interceptor interceptor : this.interceptors) {
            interceptor.init(router);
        }
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isPrintStackTrace() {
        return this.printStackTrace;
    }

    @MCAttribute
    public void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    public void closeAll() throws IOException {
        this.closeAll(true);
    }

    public void closeAll(boolean waitForCompletion) throws IOException {
    }

    public void openPort(String ip, int port, SSLProvider sslProvider, TimerManager timerManager) throws IOException {
    }

    public abstract boolean isOpeningPorts();

    public boolean isReverseDNS() {
        return this.reverseDNS;
    }

    @MCAttribute
    public void setReverseDNS(boolean reverseDNS) {
        this.reverseDNS = reverseDNS;
    }

    public int getConcurrentConnectionLimitPerIp() {
        return this.concurrentConnectionLimitPerIp;
    }

    @MCAttribute
    public void setConcurrentConnectionLimitPerIp(int concurrentConnectionLimitPerIp) {
        this.concurrentConnectionLimitPerIp = concurrentConnectionLimitPerIp;
    }
}

