/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.NonRelevantBodyObserver;
import com.predic8.membrane.core.transport.http.ConnectionManager;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.TextUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements Closeable,
MessageObserver,
NonRelevantBodyObserver {
    private static Logger log = LoggerFactory.getLogger((String)Connection.class.getName());
    public final ConnectionManager mgr;
    public final String host;
    private final SSLProvider sslProvider;
    private final String sniServerName;
    private final ProxyConfiguration proxyConfiguration;
    private final SSLProvider proxySSLProvider;
    private final String[] applicationProtocols;
    public Socket socket;
    public InputStream in;
    public OutputStream out;
    private long lastUse;
    private long timeout;
    private int maxExchanges = Integer.MAX_VALUE;
    private int completedExchanges;
    private Exchange exchange;
    private boolean keepAttachedToExchange;

    public static Connection open(String host, int port, String localHost, SSLProvider sslProvider, int connectTimeout) throws UnknownHostException, IOException {
        return Connection.open(host, port, localHost, sslProvider, null, connectTimeout);
    }

    public static Connection open(String host, int port, String localHost, SSLProvider sslProvider, ConnectionManager mgr, int connectTimeout, @Nullable String sniServername, @Nullable ProxyConfiguration proxy, @Nullable SSLProvider proxySSLProvider, @Nullable String[] applicationProtocols) throws UnknownHostException, IOException {
        Connection con = new Connection(mgr, host, sslProvider, sniServername, proxy, proxySSLProvider, applicationProtocols);
        String origHost = host;
        int origPort = port;
        SSLProvider origSSLProvider = sslProvider;
        String origSniServername = sniServername;
        if (proxy != null) {
            sslProvider = proxySSLProvider;
            host = proxy.getHost();
            port = proxy.getPort();
            sniServername = null;
        }
        if (sslProvider != null) {
            con.socket = TextUtil.isNullOrEmpty(localHost) ? sslProvider.createSocket(host, port, connectTimeout, sniServername, applicationProtocols) : sslProvider.createSocket(host, port, InetAddress.getByName(localHost), 0, connectTimeout, sniServername, applicationProtocols);
        } else {
            if (TextUtil.isNullOrEmpty(localHost)) {
                con.socket = new Socket();
            } else {
                con.socket = new Socket();
                con.socket.bind(new InetSocketAddress(InetAddress.getByName(localHost), 0));
            }
            con.socket.connect(new InetSocketAddress(host, port), connectTimeout);
        }
        if (proxy != null && origSSLProvider != null) {
            con.doTunnelHandshake(proxy, con.socket, origHost, origPort);
            con.socket = origSSLProvider.createSocket(con.socket, origHost, origPort, connectTimeout, origSniServername, applicationProtocols);
        }
        log.debug("Opened connection on localPort: " + con.socket.getLocalPort());
        con.out = new BufferedOutputStream(con.socket.getOutputStream(), 2048);
        con.in = new BufferedInputStream(con.socket.getInputStream(), 2048);
        return con;
    }

    public static Connection open(String host, int port, String localHost, SSLProvider sslProvider, ConnectionManager mgr, int connectTimeout) throws UnknownHostException, IOException {
        return Connection.open(host, port, localHost, sslProvider, mgr, connectTimeout, null, null, null, null);
    }

    private Connection(ConnectionManager mgr, String host, @Nullable SSLProvider sslProvider, @Nullable String sniServerName, @Nullable ProxyConfiguration proxy, SSLProvider proxySSLProvider, String[] applicationProtocols) {
        this.mgr = mgr;
        this.host = host;
        this.sslProvider = sslProvider;
        this.sniServerName = sniServerName;
        this.proxyConfiguration = proxy;
        this.proxySSLProvider = proxySSLProvider;
        this.applicationProtocols = applicationProtocols;
    }

    public boolean isSame(String host, int port) {
        return this.socket != null && host.equals(this.host) && port == this.socket.getPort();
    }

    @Override
    public void close() throws IOException {
        if (this.socket == null) {
            return;
        }
        log.debug("Closing HTTP connection LocalPort: " + this.socket.getLocalPort());
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                this.socket.shutdownInput();
            }
            this.socket.close();
            this.socket = null;
        }
        finally {
            if (this.mgr != null) {
                this.mgr.releaseConnection(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void release() throws IOException {
        if (this.mgr != null) {
            this.mgr.releaseConnection(this);
        } else {
            this.close();
        }
    }

    @Override
    public void bodyChunk(Chunk chunk) {
    }

    @Override
    public void bodyChunk(byte[] buffer, int offset, int length) {
    }

    @Override
    public void bodyRequested(AbstractBody body) {
    }

    @Override
    public void bodyComplete(AbstractBody body) {
        this.lastUse = System.currentTimeMillis();
        ++this.completedExchanges;
        try {
            if (this.exchange != null) {
                if (this.exchange.canKeepConnectionAlive()) {
                    if (this.keepAttachedToExchange) {
                        return;
                    }
                    this.release();
                } else {
                    this.close();
                }
                this.exchange.setTargetConnection(null);
                this.exchange = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final int getMaxExchanges() {
        return this.maxExchanges;
    }

    public final void setMaxExchanges(int maxExchanges) {
        this.maxExchanges = maxExchanges;
    }

    public final int getCompletedExchanges() {
        return this.completedExchanges;
    }

    public final long getLastUse() {
        return this.lastUse;
    }

    public String getHost() {
        return this.host;
    }

    void setKeepAttachedToExchange(boolean keepAttachedToExchange) {
        this.keepAttachedToExchange = keepAttachedToExchange;
    }

    void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public String toString() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    public String getSniServerName() {
        return this.sniServerName;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public SSLProvider getProxySSLProvider() {
        return this.proxySSLProvider;
    }

    private void doTunnelHandshake(ProxyConfiguration proxy, Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        if (log.isDebugEnabled()) {
            log.debug("send 'CONNECT " + host + ":" + port + "' to " + proxy.getHost() + (proxy.isAuthentication() ? " authenticated" : ""));
        }
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\r\nUser-Agent: " + Constants.USERAGENT + "\r\n" + (String)(proxy.isAuthentication() ? "Proxy-Authorization: " + proxy.getCredentials() + "\r\n" : "") + "\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[1024];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
            throw new IOException("Unable to tunnel through " + proxy.getHost() + ":" + proxy.getPort() + ".  Proxy returns \"" + replyStr + "\"");
        }
    }

    public SSLProvider getSslProvider() {
        return this.sslProvider;
    }

    public String[] getApplicationProtocols() {
        return this.sslProvider == null ? null : this.sslProvider.getApplicationProtocols(this.socket);
    }
}

