/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.google.common.base.Objects;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import javax.annotation.Nullable;

public class ConnectionKey {
    public final String host;
    public final int port;
    @Nullable
    private final SSLProvider sslProvider;
    @Nullable
    public final String serverName;
    @Nullable
    public final ProxyConfiguration proxy;
    @Nullable
    private final SSLProvider proxySSLProvider;
    @Nullable
    private final String[] applicationProtocols;

    public ConnectionKey(String host, int port, SSLProvider sslProvider, String serverName, ProxyConfiguration proxy, @Nullable SSLProvider proxySSLProvider, @Nullable String[] applicationProtocols) {
        this.host = host;
        this.port = port;
        this.sslProvider = sslProvider;
        this.serverName = serverName;
        this.proxy = proxy;
        this.proxySSLProvider = proxySSLProvider;
        this.applicationProtocols = applicationProtocols;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port, this.sslProvider, this.serverName, this.proxy, this.proxySSLProvider, this.applicationProtocols});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectionKey) || obj == null) {
            return false;
        }
        ConnectionKey other = (ConnectionKey)obj;
        return this.host.equals(other.host) && this.port == other.port && Objects.equal((Object)this.sslProvider, (Object)other.sslProvider) && Objects.equal((Object)this.serverName, (Object)other.serverName) && Objects.equal((Object)this.proxy, (Object)other.proxy) && Objects.equal((Object)this.proxySSLProvider, (Object)other.proxySSLProvider) && Objects.equal((Object)this.applicationProtocols, (Object)other.applicationProtocols);
    }

    public String toString() {
        return this.host + ":" + this.port + (this.sslProvider != null ? " with SSL" : "") + (this.proxy != null ? " via proxy" : "");
    }
}

