/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.ConnectionManager;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.HostColonPort;
import com.predic8.membrane.core.transport.http.HttpClientStatusEventBus;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.http.StreamPump;
import com.predic8.membrane.core.transport.http.WebSocketStreamPump;
import com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.http2.Http2Client;
import com.predic8.membrane.core.transport.http2.Http2ClientPool;
import com.predic8.membrane.core.transport.http2.Http2TlsSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.TimerManager;
import com.predic8.membrane.core.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    public static final String HTTP2 = "h2";
    private static Logger log = LoggerFactory.getLogger((String)HttpClient.class.getName());
    @GuardedBy(value="HttpClient.class")
    private static SSLProvider defaultSSLProvider;
    private final ProxyConfiguration proxy;
    private final SSLContext proxySSLContext;
    private final AuthenticationConfiguration authentication;
    private final int timeBetweenTriesMs = 250;
    private final int maxRetries;
    private final int connectTimeout;
    private final String localAddr;
    private final SSLContext sslContext;
    private final boolean useHttp2;
    private final ConnectionManager conMgr;
    private final Http2ClientPool http2ClientPool;
    private StreamPump.StreamPumpStats streamPumpStats;
    private static final String[] HTTP2_PROTOCOLS;

    public HttpClient() {
        this(null, null);
    }

    public HttpClient(@Nullable HttpClientConfiguration configuration) {
        this(configuration, null);
    }

    public HttpClient(@Nullable HttpClientConfiguration configuration, @Nullable TimerManager timerManager) {
        if (configuration == null) {
            configuration = new HttpClientConfiguration();
        }
        this.proxy = configuration.getProxy();
        this.proxySSLContext = this.proxy != null && this.proxy.getSslParser() != null ? new StaticSSLContext(this.proxy.getSslParser(), new ResolverMap(), null) : null;
        if (configuration.getSslParser() != null) {
            if (configuration.getBaseLocation() == null) {
                throw new RuntimeException("Cannot find keystores as base location is unknown");
            }
            this.sslContext = new StaticSSLContext(configuration.getSslParser(), new ResolverMap(), configuration.getBaseLocation());
        } else {
            this.sslContext = null;
        }
        this.authentication = configuration.getAuthentication();
        this.maxRetries = configuration.getMaxRetries();
        this.connectTimeout = configuration.getConnection().getTimeout();
        this.localAddr = configuration.getConnection().getLocalAddr();
        this.conMgr = new ConnectionManager(configuration.getConnection().getKeepAliveTimeout(), timerManager);
        this.useHttp2 = configuration.isUseExperimentalHttp2();
        this.http2ClientPool = this.useHttp2 ? new Http2ClientPool(configuration.getConnection().getKeepAliveTimeout()) : null;
    }

    public void setStreamPumpStats(StreamPump.StreamPumpStats streamPumpStats) {
        this.streamPumpStats = streamPumpStats;
    }

    protected void finalize() throws Throwable {
        this.conMgr.shutdownWhenDone();
        if (this.http2ClientPool != null) {
            this.http2ClientPool.shutdownWhenDone();
        }
    }

    private void setRequestURI(Request req, String dest) throws MalformedURLException {
        if (this.proxy != null || req.isCONNECTRequest()) {
            req.setUri(dest);
            return;
        }
        if (!dest.startsWith("http")) {
            throw new MalformedURLException("The exchange's destination URL (" + dest + ") does not start with 'http'. Please specify a <target> within your <serviceProxy>.");
        }
        String originalUri = req.getUri();
        try {
            req.setUri(HttpUtil.getPathAndQueryString(dest));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("while handling destination '" + dest + "'", e);
        }
        if ("/".equals(originalUri) && req.getUri().isEmpty()) {
            req.setUri("/");
        }
    }

    private HostColonPort getTargetHostAndPort(boolean connect, String dest) throws MalformedURLException {
        if (connect) {
            return new HostColonPort(false, dest);
        }
        return new HostColonPort(new URL(dest));
    }

    private HostColonPort init(Exchange exc, String dest, boolean adjustHostHeader) throws IOException {
        this.setRequestURI(exc.getRequest(), dest);
        HostColonPort target = this.getTargetHostAndPort(exc.getRequest().isCONNECTRequest(), dest);
        if (this.authentication != null) {
            exc.getRequest().getHeader().setAuthorization(this.authentication.getUsername(), this.authentication.getPassword());
        }
        if (adjustHostHeader && (exc.getRule() == null || exc.getRule().isTargetAdjustHostHeader())) {
            URL d = new URL(dest);
            exc.getRequest().getHeader().setHost(d.getHost() + ":" + HttpUtil.getPort(d));
        }
        return target;
    }

    private SSLProvider getOutboundSSLProvider(Exchange exc, HostColonPort hcp) {
        Object sslPropObj = exc.getProperty("SSL_CONTEXT");
        if (sslPropObj != null) {
            return (SSLProvider)sslPropObj;
        }
        if (hcp.useSSL) {
            if (this.sslContext != null) {
                return this.sslContext;
            }
            return HttpClient.getDefaultSSLProvider();
        }
        return null;
    }

    private static synchronized SSLProvider getDefaultSSLProvider() {
        if (defaultSSLProvider == null) {
            defaultSSLProvider = new StaticSSLContext(new SSLParser(), null, null);
        }
        return defaultSSLProvider;
    }

    public Exchange call(Exchange exc) throws Exception {
        return this.call(exc, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange call(Exchange exc, boolean adjustHostHeader, boolean failOverOn5XX) throws Exception {
        boolean trackNodeStatus;
        if (exc.getDestinations().isEmpty()) {
            throw new IllegalStateException("List of destinations is empty. Please specify at least one destination.");
        }
        HttpClientStatusEventBus httpClientStatusEventBus = (HttpClientStatusEventBus)exc.getProperty("HttpClientStatusEventBus");
        Exception exception = null;
        Object trackNodeStatusObj = exc.getProperty("TRACK_NODE_STATUS");
        boolean bl = trackNodeStatus = trackNodeStatusObj instanceof Boolean && (Boolean)trackNodeStatusObj != false;
        for (int counter = 0; counter < this.maxRetries; ++counter) {
            Connection con = null;
            String dest = this.getDestination(exc, counter);
            HostColonPort target = null;
            Integer responseStatusCode = null;
            try {
                Response response;
                log.debug("try # " + counter + " to " + dest);
                target = this.init(exc, dest, adjustHostHeader);
                if (counter == 0 && (con = exc.getTargetConnection()) != null) {
                    if (!con.isSame(target.host, target.port)) {
                        con.close();
                        con = null;
                    } else {
                        con.setKeepAttachedToExchange(true);
                    }
                }
                boolean usingHttp2 = false;
                Http2Client h2c = null;
                SSLProvider sslProvider = this.getOutboundSSLProvider(exc, target);
                String sniServerName = this.getSNIServerName(exc);
                if (con == null && this.useHttp2 && (h2c = this.http2ClientPool.reserveStream(target.host, target.port, sslProvider, sniServerName, this.proxy, this.proxySSLContext)) != null) {
                    con = h2c.getConnection();
                    usingHttp2 = true;
                }
                if (con == null) {
                    String[] applicationProtocols = null;
                    if (this.useHttp2) {
                        applicationProtocols = HTTP2_PROTOCOLS;
                    }
                    con = this.conMgr.getConnection(target.host, target.port, this.localAddr, sslProvider, this.connectTimeout, sniServerName, this.proxy, this.proxySSLContext, applicationProtocols);
                    if (this.useHttp2 && Http2TlsSupport.isHttp2(con.socket)) {
                        usingHttp2 = true;
                    } else {
                        exc.setTargetConnection(con);
                    }
                    con.setKeepAttachedToExchange(usingHttp2 || exc.getRequest().isBindTargetConnectionToIncoming());
                }
                if (this.proxy != null && sslProvider == null) {
                    exc.getRequest().getHeader().setProxyAutorization(this.proxy.getCredentials());
                }
                if (usingHttp2) {
                    if (h2c == null) {
                        h2c = new Http2Client(con, sslProvider.showSSLExceptions());
                        this.http2ClientPool.share(target.host, target.port, sslProvider, sniServerName, this.proxy, this.proxySSLContext, h2c);
                    }
                    response = h2c.doCall(exc, con);
                    exc.setProperty(HTTP2, true);
                } else {
                    String newProtocol = null;
                    if (exc.getRequest().isCONNECTRequest()) {
                        this.handleConnectRequest(exc, con);
                        response = Response.ok().build();
                        newProtocol = "CONNECT";
                    } else {
                        response = this.doCall(exc, con);
                        if (trackNodeStatus) {
                            exc.setNodeStatusCode(counter, response.getStatusCode());
                        }
                        newProtocol = this.upgradeProtocol(exc, response, newProtocol);
                    }
                    if (newProtocol != null) {
                        HttpClient.setupConnectionForwarding(exc, con, newProtocol, this.streamPumpStats);
                        exc.getDestinations().clear();
                        exc.getDestinations().add(dest);
                        con.setExchange(exc);
                        exc.setResponse(response);
                        Exchange exchange = exc;
                        return exchange;
                    }
                }
                responseStatusCode = response.getStatusCode();
                if (httpClientStatusEventBus != null) {
                    httpClientStatusEventBus.reportResponse(dest, responseStatusCode);
                }
                if (!failOverOn5XX || !this.is5xx(responseStatusCode) || counter == this.maxRetries - 1) {
                    this.applyKeepAliveHeader(response, con);
                    exc.getDestinations().clear();
                    exc.getDestinations().add(dest);
                    con.setExchange(exc);
                    if (!usingHttp2) {
                        response.addObserver(con);
                    }
                    exc.setResponse(response);
                    Exchange exchange = exc;
                    return exchange;
                }
            }
            catch (ConnectException e) {
                exception = e;
                log.info("Connection to " + (target == null ? dest : target) + " refused.");
            }
            catch (SocketException e) {
                exception = e;
                if (e.getMessage().contains("Software caused connection abort")) {
                    log.info("Connection to " + dest + " was aborted externally. Maybe by the server or the OS Membrane is running on.");
                } else if (e.getMessage().contains("Connection reset")) {
                    log.info("Connection to " + dest + " was reset externally. Maybe by the server or the OS Membrane is running on.");
                } else {
                    this.logException(exc, counter, e);
                }
            }
            catch (UnknownHostException e) {
                exception = e;
                log.warn("Unknown host: " + (target == null ? dest : target));
            }
            catch (EOFWhileReadingFirstLineException e) {
                exception = e;
                log.debug("Server connection to " + dest + " terminated before line was read. Line so far: " + e.getLineSoFar());
            }
            catch (NoResponseException e) {
                exception = e;
            }
            catch (Exception e) {
                exception = e;
                this.logException(exc, counter, e);
            }
            finally {
                if (trackNodeStatus && exception != null) {
                    exc.setNodeException(counter, exception);
                }
            }
            if (httpClientStatusEventBus != null) {
                if (exception != null) {
                    httpClientStatusEventBus.reportException(dest, exception);
                } else {
                    assert (responseStatusCode != null && this.is5xx(responseStatusCode));
                    httpClientStatusEventBus.reportResponse(dest, responseStatusCode);
                }
            }
            if (exception instanceof UnknownHostException ? exc.getDestinations().size() < 2 : exception instanceof NoResponseException) break;
            if (exc.getDestinations().size() != 1) continue;
            Thread.sleep(250L);
        }
        throw exception;
    }

    private String upgradeProtocol(Exchange exc, Response response, String newProtocol) {
        if (exc.getProperty("use-websocket") == Boolean.TRUE && this.isUpgradeToResponse(response, "websocket")) {
            log.debug("Upgrading to WebSocket protocol.");
            return "WebSocket";
        }
        if (exc.getProperty("use-tcp") == Boolean.TRUE && this.isUpgradeToResponse(response, "tcp")) {
            log.debug("Upgrading to TCP protocol.");
            return "TCP";
        }
        if (exc.getProperty("use-sdpy") == Boolean.TRUE && this.isUpgradeToResponse(response, "SPDY/3.1")) {
            log.debug("Upgrading to SPDY/3.1 protocol.");
            return "SPDY/3.1";
        }
        return newProtocol;
    }

    private String getSNIServerName(Exchange exc) {
        Object sniObject = exc.getProperty("SNI_SERVER_NAME");
        if (sniObject == null) {
            return null;
        }
        return (String)sniObject;
    }

    private boolean is5xx(Integer responseStatusCode) {
        return 500 <= responseStatusCode && responseStatusCode < 600;
    }

    private void applyKeepAliveHeader(Response response, Connection con) {
        long max;
        String value = response.getHeader().getFirstValue("Keep-Alive");
        if (value == null) {
            return;
        }
        long timeoutSeconds = Header.parseKeepAliveHeader(value, "timeout");
        if (timeoutSeconds != -1L) {
            con.setTimeout(timeoutSeconds * 1000L);
        }
        if ((max = Header.parseKeepAliveHeader(value, "max")) != -1L && max < (long)con.getMaxExchanges()) {
            con.setMaxExchanges((int)max);
        }
    }

    private String getDestination(Exchange exc, int counter) {
        return exc.getDestinations().get(counter % exc.getDestinations().size());
    }

    private void logException(Exchange exc, int counter, Exception e) throws IOException {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("try # ");
            msg.append(counter);
            msg.append(" failed\n");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exc.getRequest().writeStartLine(baos);
            exc.getRequest().getHeader().write(baos);
            msg.append(Constants.ISO_8859_1_CHARSET.decode(ByteBuffer.wrap(baos.toByteArray())));
            if (e != null) {
                log.debug("{}", (Object)msg, (Object)e);
            } else {
                log.debug("{}", (Object)msg);
            }
        }
    }

    private Response doCall(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        exc.getRequest().write(con.out, this.maxRetries > 1);
        exc.setTimeReqSent(System.currentTimeMillis());
        if (exc.getRequest().isHTTP10()) {
            this.shutDownRequestInputOutput(exc, con);
        }
        Response res = new Response();
        res.read(con.in, !exc.getRequest().isHEADRequest());
        if (res.getStatusCode() == 100) {
            this.do100ExpectedHandling(exc, res, con);
        }
        exc.setReceived();
        exc.setTimeResReceived(System.currentTimeMillis());
        return res;
    }

    public static void setupConnectionForwarding(Exchange exc, final Connection con, final String protocol, StreamPump.StreamPumpStats streamPumpStats) throws SocketException {
        StreamPump b;
        StreamPump a;
        HttpServerHandler hsr = (HttpServerHandler)exc.getHandler();
        String source = hsr.getSourceSocket().getRemoteSocketAddress().toString();
        String dest = con.toString();
        if ("WebSocket".equals(protocol)) {
            WebSocketStreamPump aTemp = new WebSocketStreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getRule(), true, exc);
            WebSocketStreamPump bTemp = new WebSocketStreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getRule(), false, null);
            aTemp.init(bTemp);
            bTemp.init(aTemp);
            a = aTemp;
            b = bTemp;
        } else {
            a = new StreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getRule());
            b = new StreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getRule());
        }
        hsr.getSourceSocket().setSoTimeout(0);
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void setExchangeFinished() {
                String threadName = Thread.currentThread().getName();
                new Thread((Runnable)b, threadName + " " + protocol + " Backward Thread").start();
                try {
                    Thread.currentThread().setName(threadName + " " + protocol + " Onward Thread");
                    a.run();
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (IOException e) {
                        log.debug("", (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean isUpgradeToResponse(Response res, String protocol) {
        return res.getStatusCode() == 101 && "upgrade".equalsIgnoreCase(res.getHeader().getFirstValue("Connection")) && protocol.equalsIgnoreCase(res.getHeader().getFirstValue("Upgrade"));
    }

    private void handleConnectRequest(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        if (this.proxy != null) {
            exc.getRequest().write(con.out, this.maxRetries > 1);
            Response response = new Response();
            response.read(con.in, false);
            log.debug("Status code response on CONNECT request: " + response.getStatusCode());
        }
        exc.getRequest().setUri("N/A");
    }

    private void do100ExpectedHandling(Exchange exc, Response response, Connection con) throws IOException, EndOfStreamException {
        exc.getRequest().getBody().write(exc.getRequest().getHeader().isChunked() ? new ChunkedBodyTransferrer(con.out) : new PlainBodyTransferrer(con.out), this.maxRetries > 1);
        con.out.flush();
        response.read(con.in, !exc.getRequest().isHEADRequest());
    }

    private void shutDownRequestInputOutput(Exchange exc, Connection con) throws IOException {
        exc.getHandler().shutdownInput();
        Util.shutdownOutput(con.socket);
    }

    ConnectionManager getConnectionManager() {
        return this.conMgr;
    }

    static {
        HTTP2_PROTOCOLS = new String[]{HTTP2};
    }
}

