/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.http.HttpClientStatusEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientStatusEventBus {
    static final Log log = LogFactory.getLog((String)HttpClientStatusEventBus.class.getName());
    public static final String EXCHANGE_PROPERTY_NAME = "HttpClientStatusEventBus";
    private final List<HttpClientStatusEventListener> listeners = new CopyOnWriteArrayList<HttpClientStatusEventListener>();

    public void registerListener(HttpClientStatusEventListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Already registered: " + listener);
        }
        this.listeners.add(listener);
    }

    public void reportResponse(String destination, int responseCode) {
        long timestamp = System.currentTimeMillis();
        for (HttpClientStatusEventListener listener : this.listeners) {
            try {
                listener.onResponse(timestamp, destination, responseCode);
            }
            catch (Exception e) {
                log.warn((Object)("Listener " + listener + " threw exception (it is logged and ignored)"), (Throwable)e);
            }
        }
    }

    public void reportException(String destination, Exception exception) {
        long timestamp = System.currentTimeMillis();
        for (HttpClientStatusEventListener listener : this.listeners) {
            try {
                listener.onException(timestamp, destination, exception);
            }
            catch (Exception e) {
                log.warn((Object)("Listener " + listener + " threw exception (it is logged and ignored)"), (Throwable)e);
            }
        }
    }
}

