/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.google.common.base.Objects;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.model.IPortChangeListener;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.HttpEndpointListener;
import com.predic8.membrane.core.transport.http.HttpServerThreadFactory;
import com.predic8.membrane.core.transport.http.IpPort;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.TimerManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="transport")
public class HttpTransport
extends Transport {
    private static Logger log = LoggerFactory.getLogger((String)HttpTransport.class.getName());
    public static final String SOURCE_HOSTNAME = "com.predic8.membrane.transport.http.source.Hostname";
    public static final String HEADER_HOST = "com.predic8.membrane.transport.http.header.Host";
    public static final String SOURCE_IP = "com.predic8.membrane.transport.http.source.Ip";
    private int socketTimeout = 30000;
    private int forceSocketCloseOnHotDeployAfter = 30000;
    private boolean tcpNoDelay = true;
    private final Map<Integer, Map<IpPort, HttpEndpointListener>> portListenerMapping = new HashMap<Integer, Map<IpPort, HttpEndpointListener>>();
    private final List<WeakReference<HttpEndpointListener>> stillRunning = new ArrayList<WeakReference<HttpEndpointListener>>();
    private final ThreadPoolExecutor executorService = new ThreadPoolExecutor(20, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new HttpServerThreadFactory());

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
    }

    public synchronized void closePort(IpPort p) throws IOException {
        Map<IpPort, HttpEndpointListener> mih = this.portListenerMapping.get(p.getPort());
        if (mih == null || mih.isEmpty()) {
            return;
        }
        HttpEndpointListener plt = mih.get(p);
        if (plt == null) {
            return;
        }
        log.info("Closing server port: " + p);
        plt.closePort();
        try {
            plt.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        mih.remove(p);
        if (mih.isEmpty()) {
            this.portListenerMapping.remove(p.getPort());
        }
        this.stillRunning.add(new WeakReference<HttpEndpointListener>(plt));
        for (IPortChangeListener listener : this.menuListeners) {
            listener.removePort(p.getPort());
        }
    }

    @Override
    public synchronized void closeAll(boolean waitForCompletion) throws IOException {
        log.debug("Closing all network server sockets.");
        ArrayList<IpPort> all = new ArrayList<IpPort>();
        for (Map<IpPort, HttpEndpointListener> v : this.portListenerMapping.values()) {
            all.addAll(v.keySet());
        }
        for (IpPort ipPort : all) {
            this.closePort(ipPort);
        }
        log.debug("Closing all stream pumps.");
        Router router = this.getRouter();
        if (router != null) {
            router.getStatistics().getStreamPumpStats().closeAllStreamPumps();
        }
        if (waitForCompletion) {
            long now = System.currentTimeMillis();
            log.debug("Waiting for running exchanges to finish.");
            this.executorService.shutdown();
            try {
                while (true) {
                    boolean onlyIdle = System.currentTimeMillis() - now <= (long)this.forceSocketCloseOnHotDeployAfter;
                    this.closeConnections(onlyIdle);
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.warn("Still waiting for running exchanges to finish. (Set <transport forceSocketCloseOnHotDeployAfter=\"" + this.forceSocketCloseOnHotDeployAfter + "\"> to a lower value to forcibly close connections more quickly.");
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeConnections(boolean onlyIdle) throws IOException {
        ArrayList<WeakReference<HttpEndpointListener>> remove = new ArrayList<WeakReference<HttpEndpointListener>>();
        for (WeakReference<HttpEndpointListener> whel : this.stillRunning) {
            HttpEndpointListener hel = (HttpEndpointListener)whel.get();
            if (hel == null) {
                remove.add(whel);
                continue;
            }
            if (!hel.closeConnections(onlyIdle)) continue;
            remove.add(whel);
        }
        for (WeakReference<HttpEndpointListener> whel : remove) {
            this.stillRunning.remove(whel);
        }
    }

    @Override
    public synchronized void openPort(String ip, int port, SSLProvider sslProvider, @Nullable TimerManager timerManager) throws IOException {
        IpPort p;
        if (port == -1) {
            throw new RuntimeException("The port-attribute is missing (probably on a <serviceProxy> element).");
        }
        Map mih = this.portListenerMapping.computeIfAbsent(port, k -> new HashMap());
        HttpEndpointListener hel = (HttpEndpointListener)mih.get(p = new IpPort(ip, port));
        if (hel != null) {
            if (Objects.equal((Object)sslProvider, (Object)hel.getSslProvider())) {
                return;
            }
            throw new RuntimeException(String.format("Lister thread on %s should use the same SSL config", p.toShortString()));
        }
        if (ip == null && !mih.isEmpty() || ip != null && mih.containsKey(new IpPort(null, port))) {
            throw new RuntimeException(HttpTransport.createDiffInterfacesErrorMsg(p, mih));
        }
        HttpEndpointListener portListenerThread = new HttpEndpointListener(p, this, sslProvider, timerManager);
        mih.put(p, portListenerThread);
        portListenerThread.start();
        for (IPortChangeListener listener : this.menuListeners) {
            listener.addPort(port);
        }
    }

    @Override
    public String getOpenBackendConnections(int port) {
        Map<IpPort, HttpEndpointListener> pl = this.portListenerMapping.get(port);
        if (pl != null) {
            for (IpPort ipPort : pl.keySet()) {
                if (ipPort.port != port) continue;
                return Integer.toString(pl.get(ipPort).getNumberOfOpenConnections());
            }
        }
        return "N/A";
    }

    private static String createDiffInterfacesErrorMsg(IpPort p, Map<IpPort, HttpEndpointListener> mih) {
        StringBuilder sb = new StringBuilder("Conflict with listening on the same net interfaces [").append(p.toShortString()).append(", ");
        for (IpPort ip : mih.keySet()) {
            sb.append(ip.toShortString()).append(", ");
        }
        return sb.replace(sb.length() - 2, sb.length(), "]").toString();
    }

    public int getCoreThreadPoolSize() {
        return this.executorService.getCorePoolSize();
    }

    @MCAttribute
    public void setCoreThreadPoolSize(int corePoolSize) {
        this.executorService.setCorePoolSize(corePoolSize);
    }

    public int getMaxThreadPoolSize() {
        return this.executorService.getMaximumPoolSize();
    }

    @MCAttribute
    public void setMaxThreadPoolSize(int value) {
        this.executorService.setMaximumPoolSize(value);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @MCAttribute
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @MCAttribute
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Override
    public boolean isOpeningPorts() {
        return true;
    }

    public int getForceSocketCloseOnHotDeployAfter() {
        return this.forceSocketCloseOnHotDeployAfter;
    }

    @MCAttribute
    public void setForceSocketCloseOnHotDeployAfter(int forceSocketCloseOnHotDeployAfter) {
        this.forceSocketCloseOnHotDeployAfter = forceSocketCloseOnHotDeployAfter;
    }
}

