/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpPort {
    public final InetAddress ip;
    public final int port;

    public IpPort(String ip, int port) throws UnknownHostException {
        this.ip = ip == null ? null : InetAddress.getByName(ip);
        this.port = port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IpPort)) {
            return false;
        }
        IpPort other = (IpPort)obj;
        if (other.port != this.port) {
            return false;
        }
        if (this.ip == null) {
            return other.ip == null;
        }
        return this.ip.equals(other.ip);
    }

    public int hashCode() {
        return 5 * this.port + (this.ip != null ? 3 * this.ip.hashCode() : 0);
    }

    public String toString() {
        return "port=" + this.port + " ip=" + this.ip;
    }

    public String toShortString() {
        return "'" + (this.ip == null ? "*" : this.ip.toString()) + ':' + this.port + '\'';
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }
}

