/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http.client;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.config.spring.BaseLocationApplicationContext;
import com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration;
import com.predic8.membrane.core.transport.http.client.ConnectionConfiguration;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import java.security.InvalidParameterException;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="httpClientConfig")
public class HttpClientConfiguration
implements ApplicationContextAware {
    private int maxRetries = 5;
    private ConnectionConfiguration connection = new ConnectionConfiguration();
    private ProxyConfiguration proxy;
    private AuthenticationConfiguration authentication;
    private SSLParser sslParser;
    private String baseLocation;
    private boolean useExperimentalHttp2;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientConfiguration that = (HttpClientConfiguration)o;
        return this.maxRetries == that.maxRetries && this.useExperimentalHttp2 == that.useExperimentalHttp2 && Objects.equals(this.connection, that.connection) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.sslParser, that.sslParser) && Objects.equals(this.baseLocation, that.baseLocation);
    }

    public int hashCode() {
        return Objects.hash(this.maxRetries, this.connection, this.proxy, this.authentication, this.sslParser, this.baseLocation, this.useExperimentalHttp2);
    }

    public ConnectionConfiguration getConnection() {
        return this.connection;
    }

    @MCChildElement(order=1)
    public void setConnection(ConnectionConfiguration connection) {
        if (connection == null) {
            throw new InvalidParameterException("'connection' parameter cannot be null.");
        }
        this.connection = connection;
    }

    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    @MCChildElement(order=2)
    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    @MCChildElement(order=3)
    public void setAuthentication(AuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @MCAttribute
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=4, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof BaseLocationApplicationContext) {
            this.setBaseLocation(((BaseLocationApplicationContext)applicationContext).getBaseLocation());
        }
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public boolean isUseExperimentalHttp2() {
        return this.useExperimentalHttp2;
    }

    @MCAttribute
    public void setUseExperimentalHttp2(boolean useExperimentalHttp2) {
        this.useExperimentalHttp2 = useExperimentalHttp2;
    }
}

