/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http.client;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.config.security.SSLParser;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

@MCElement(name="proxy", topLevel=false, id="proxy-configuration")
public class ProxyConfiguration {
    public static final String ATTRIBUTE_ACTIVE = "active";
    public static final String ATTRIBUTE_AUTHENTICATION = "authentication";
    private String host;
    private int port;
    private boolean authentication;
    private String username;
    private String password;
    private SSLParser sslParser;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        return this.port == that.port && this.authentication == that.authentication && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.sslParser, that.sslParser);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.authentication, this.username, this.password, this.sslParser);
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int proxyPort) {
        this.port = proxyPort;
    }

    public String getPassword() {
        return this.password;
    }

    @MCAttribute
    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    @MCAttribute
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAuthentication() {
        return this.authentication;
    }

    @MCAttribute
    public void setAuthentication(boolean authentication) {
        this.authentication = authentication;
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    public String getCredentials() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Basic ");
        byte[] base64UserPass = Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes(Constants.UTF_8_CHARSET));
        buffer.append(new String(base64UserPass, Constants.UTF_8_CHARSET));
        return buffer.toString();
    }
}

