/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.transport.http2.FrameProducer;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.twitter.hpack.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameSender
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)FrameSender.class.getName());
    private static final int TYPE_STOP = -1;
    private final OutputStream out;
    private final Encoder encoder;
    private final Settings peerSettings;
    private final Map<Integer, StreamInfo> streams;
    private final String remoteAddr;
    private final LinkedTransferQueue<Frame> queue = new LinkedTransferQueue();
    private final AtomicInteger totalBufferedFrames = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition hasFrame = this.lock.newCondition();

    public FrameSender(OutputStream out, Encoder encoder, Settings peerSettings, Map<Integer, StreamInfo> streams, String remoteAddr) {
        this.out = out;
        this.encoder = encoder;
        this.peerSettings = peerSettings;
        this.streams = streams;
        this.remoteAddr = remoteAddr;
    }

    public void send(Frame frame) {
        if (frame.getType() == 0) {
            StreamInfo streamInfo = this.streams.get(frame.getStreamId());
            try {
                streamInfo.getBufferedDataFrames().acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            streamInfo.getDataFramesToBeSent().add(frame);
        } else {
            this.queue.put(frame);
        }
        this.totalBufferedFrames.incrementAndGet();
        this.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(int streamId, FrameProducer frameProducer) throws IOException {
        long now = System.nanoTime();
        FrameSender frameSender = this;
        synchronized (frameSender) {
            long enter = System.nanoTime();
            if (enter - now > 10000000L) {
                log.warn("Took " + (enter - now) / 1000000L + "ms to acquire lock (streamId=" + streamId + ").");
            }
            for (Frame frame : frameProducer.call(this.encoder, this.peerSettings)) {
                this.send(frame);
            }
        }
    }

    private Frame getNextFrame() {
        Frame frame = this.queue.poll();
        if (frame != null) {
            this.totalBufferedFrames.decrementAndGet();
            return frame;
        }
        for (StreamInfo streamInfo : this.streams.values()) {
            frame = streamInfo.getDataFramesToBeSent().poll();
            if (frame == null) continue;
            streamInfo.getBufferedDataFrames().release();
            this.totalBufferedFrames.decrementAndGet();
            return frame;
        }
        return null;
    }

    private Frame waitForNextFrame() throws InterruptedException {
        this.lock.lock();
        try {
            this.hasFrame.await(1000L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
        Frame frame = this.getNextFrame();
        return frame;
    }

    @Override
    public void run() {
        try {
            this.updateThreadName(true);
            while (true) {
                Frame frame;
                if ((frame = this.getNextFrame()) == null) {
                    this.out.flush();
                    log.debug("found no frame to send, starting wait loop.");
                    while (frame == null) {
                        frame = this.waitForNextFrame();
                    }
                    log.debug("found another frame to send.");
                }
                if (frame.getType() == -1) {
                    break;
                }
                if (frame.getType() == 3) {
                    this.streams.get(frame.getStreamId()).sendRstStream();
                }
                if (frame.getType() == 1) {
                    this.streams.get(frame.getStreamId()).sendHeaders();
                }
                if ((frame.getType() == 1 || frame.getType() == 0) && (frame.getFlags() & 1) != 0) {
                    this.streams.get(frame.getStreamId()).sendEndStream();
                }
                if (log.isTraceEnabled()) {
                    log.trace("sending: " + frame);
                } else if (log.isDebugEnabled()) {
                    log.debug("sending: " + frame.getTypeString() + " length=" + frame.getLength());
                }
                frame.write(this.out);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.updateThreadName(false);
        }
        log.debug("frame sender shutdown");
    }

    public void stop() {
        Frame e = new Frame();
        e.fill(-1, 0, 0, null, 0, 0);
        this.queue.add(e);
        this.fire();
    }

    private void updateThreadName(boolean fromConnection) {
        if (fromConnection) {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP2 Frame Sender ");
            sb.append(this.remoteAddr);
            Thread.currentThread().setName(sb.toString());
        } else {
            Thread.currentThread().setName("RouterThread");
        }
    }

    private void fire() {
        this.lock.lock();
        try {
            this.hasFrame.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

