/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.google.common.collect.ImmutableList;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.InterceptorFlowController;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.AbortException;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.PeerFlowControl;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.RstStreamFrame;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.twitter.hpack.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ExchangeHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)Http2ExchangeHandler.class.getName());
    private static final InterceptorFlowController flowController = new InterceptorFlowController();
    private final StreamInfo streamInfo;
    private final Transport transport;
    private final FrameSender sender;
    private final Settings peerSettings;
    private final PeerFlowControl peerFlowControl;
    private final Exchange exchange;
    private final boolean showSSLExceptions;
    private final String remoteAddr;
    private final int streamId;

    public Http2ExchangeHandler(StreamInfo streamInfo, Transport transport, FrameSender sender, Settings peerSettings, PeerFlowControl peerFlowControl, Exchange exchange, boolean showSSLExceptions, String remoteAddr) {
        this.streamInfo = streamInfo;
        this.transport = transport;
        this.sender = sender;
        this.peerSettings = peerSettings;
        this.peerFlowControl = peerFlowControl;
        this.exchange = exchange;
        this.showSSLExceptions = showSSLExceptions;
        this.remoteAddr = remoteAddr;
        this.streamId = streamInfo.getStreamId();
    }

    @Override
    public void run() {
        try {
            this.updateThreadName(true);
            this.process();
            this.exchange.detach();
        }
        catch (SocketTimeoutException e) {
            log.debug("Socket timed out");
        }
        catch (SocketException se) {
            log.debug("client socket closed");
        }
        catch (SSLException s) {
            if (this.showSSLExceptions) {
                if (s.getCause() instanceof SSLException) {
                    s = (SSLException)s.getCause();
                }
                if (s.getCause() instanceof SocketException) {
                    log.debug("ssl socket closed");
                } else {
                    log.error("", (Throwable)s);
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (EndOfStreamException e) {
            log.debug("stream closed");
        }
        catch (AbortException e) {
            log.debug("exchange aborted.");
        }
        catch (NoMoreRequestsException e) {
        }
        catch (NoResponseException e) {
            log.debug("No response received. Maybe increase the keep-alive timeout on the server.");
        }
        catch (EOFWhileReadingFirstLineException e) {
            log.debug("Client connection terminated before line was read. Line so far: (" + e.getLineSoFar() + ")");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.closeConnections();
            this.exchange.detach();
            this.updateThreadName(false);
        }
    }

    private void process() throws Exception {
        try {
            this.invokeHandlers();
            this.exchange.blockResponseIfNeeded();
        }
        catch (AbortException e) {
            log.debug("Aborted");
            this.exchange.finishExchange(true, e.getMessage());
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            log.debug("exchange set aborted");
            return;
        }
        try {
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            this.exchange.setCompleted();
            log.debug("exchange set completed");
        }
        catch (Exception e) {
            this.exchange.finishExchange(true, e.getMessage());
            throw e;
        }
    }

    private void invokeHandlers() throws IOException, EndOfStreamException, AbortException {
        try {
            flowController.invokeHandlers(this.exchange, this.transport.getInterceptors());
            if (this.exchange.getResponse() == null) {
                throw new AbortException("No response was generated by the interceptor chain.");
            }
        }
        catch (Exception e) {
            if (this.exchange.getResponse() == null) {
                this.exchange.setResponse(AbstractHttpHandler.generateErrorResponse(e, this.exchange, this.transport));
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof EndOfStreamException) {
                throw (EndOfStreamException)e;
            }
            if (e instanceof AbortException) {
                throw (AbortException)e;
            }
            if (e instanceof NoMoreRequestsException) {
                throw (NoMoreRequestsException)e;
            }
            if (e instanceof NoResponseException) {
                throw (NoResponseException)e;
            }
            if (e instanceof EOFWhileReadingFirstLineException) {
                throw (EOFWhileReadingFirstLineException)e;
            }
            log.warn("An exception occured while handling a request: ", (Throwable)e);
        }
    }

    private void updateThreadName(boolean fromConnection) {
        if (fromConnection) {
            StringBuilder sb = new StringBuilder();
            sb.append("RouterThread");
            sb.append(" ");
            sb.append(this.remoteAddr);
            sb.append(" stream ");
            sb.append(this.streamId);
            Thread.currentThread().setName(sb.toString());
        } else {
            Thread.currentThread().setName("RouterThread");
        }
    }

    protected void writeResponse(Response res) throws Exception {
        this.sender.send(this.streamId, (encoder, peerSettings) -> Http2ExchangeHandler.createHeadersFrames(res, res.getHeader(), this.streamId, encoder, peerSettings, false));
        Http2ExchangeHandler.writeMessageBody(this.streamId, this.streamInfo, this.sender, this.peerSettings, this.peerFlowControl, res);
        this.exchange.setTimeResSent(System.currentTimeMillis());
        this.exchange.collectStatistics();
    }

    public static void writeMessageBody(final int streamId, final StreamInfo streamInfo, final FrameSender sender, final Settings peerSettings, final PeerFlowControl peerFlowControl, Message res) throws IOException {
        res.getBody().write(new AbstractBodyTransferrer(){

            @Override
            public void write(byte[] content, int i, int length) throws IOException {
                this.sendData(content, i, length);
            }

            private void sendData(byte[] content, int offset, int length) throws IOException {
                int mLength;
                for (int mOffset = offset; mOffset < offset + length; mOffset += mLength) {
                    mLength = Math.min(peerSettings.getMaxFrameSize(), length - (mOffset - offset));
                    streamInfo.getPeerFlowControl().reserve(mLength, streamId);
                    peerFlowControl.reserve(mLength, streamId);
                    Frame frame = new Frame();
                    frame.fill(0, 0, streamId, content, mOffset, mLength);
                    sender.send(frame);
                }
            }

            @Override
            public void write(Chunk chunk) throws IOException {
                this.sendData(chunk.getContent(), 0, chunk.getLength());
            }

            @Override
            public void finish(Header header) throws IOException {
                if (header != null) {
                    while (!streamInfo.getDataFramesToBeSent().isEmpty()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    sender.send(streamId, (encoder, peerSettings) -> Http2ExchangeHandler.createHeadersFrames(null, header, streamId, encoder, peerSettings, true));
                } else {
                    Frame frame = new Frame();
                    frame.fill(0, 1, streamId, null, 0, 0);
                    sender.send(frame);
                }
            }
        }, false);
    }

    public static List<Frame> createHeadersFrames(Message res, Header header, int streamId, Encoder encoder, Settings peerSettings, boolean isAtEof) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        encoder.setMaxHeaderTableSize((OutputStream)baos, peerSettings.getHeaderTableSize());
        StringBuilder sb = null;
        if (log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Headers on stream ");
            sb.append(streamId);
            sb.append(":\n");
        }
        if (res instanceof Request) {
            Request req = (Request)res;
            String key = ":method";
            String val = req.getMethod();
            encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), val.getBytes(StandardCharsets.US_ASCII), false);
            if (sb != null) {
                sb.append(key);
                sb.append(": ");
                sb.append(val);
                sb.append("\n");
            }
            key = ":scheme";
            val = "https";
            encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), val.getBytes(StandardCharsets.US_ASCII), false);
            if (sb != null) {
                sb.append(key);
                sb.append(": ");
                sb.append(val);
                sb.append("\n");
            }
            key = ":path";
            val = req.getUri();
            encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), val.getBytes(StandardCharsets.US_ASCII), false);
            if (sb != null) {
                sb.append(key);
                sb.append(": ");
                sb.append(val);
                sb.append("\n");
            }
            key = ":authority";
            val = req.getHeader().getHost();
            encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), val.getBytes(StandardCharsets.US_ASCII), false);
            if (sb != null) {
                sb.append(key);
                sb.append(": ");
                sb.append(val);
                sb.append("\n");
            }
        }
        if (res instanceof Response) {
            HeaderField[] keyStatus = ":status";
            String valStatus = "" + ((Response)res).getStatusCode();
            encoder.encodeHeader((OutputStream)baos, keyStatus.getBytes(StandardCharsets.US_ASCII), valStatus.getBytes(StandardCharsets.US_ASCII), false);
            if (sb != null) {
                sb.append((String)keyStatus);
                sb.append(": ");
                sb.append(valStatus);
                sb.append("\n");
            }
        }
        for (HeaderField hf : header.getAllHeaderFields()) {
            String key = hf.getHeaderName().toString().toLowerCase();
            if ("keep-alive".equals(key) || "proxy-connection".equals(key) || "transfer-encoding".equals(key) || "upgrade".equals(key) || "connection".equals(key) || "host".equals(key)) continue;
            boolean sensitive = "set-cookie".equals(key);
            encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), hf.getValue().getBytes(StandardCharsets.US_ASCII), sensitive);
            if (sb == null) continue;
            sb.append(key);
            sb.append(": ");
            sb.append(hf.getValue());
            if (sensitive) {
                sb.append("    (sensitive)");
            }
            sb.append("\n");
        }
        if (sb != null) {
            log.debug(sb.toString());
        }
        byte[] buffer = baos.toByteArray();
        ArrayList<Frame> frames = new ArrayList<Frame>();
        int maxFrameSize = peerSettings.getMaxFrameSize();
        for (int offset = 0; offset < buffer.length; offset += maxFrameSize) {
            Frame frame = new Frame();
            boolean isLast = offset + maxFrameSize >= buffer.length;
            frame.fill(offset == 0 ? 1 : 9, (isLast ? 4 : 0) + (isAtEof ? 1 : 0), streamId, buffer, offset, Math.min(maxFrameSize, buffer.length - offset));
            frames.add(frame);
        }
        return frames;
    }

    private void removeBodyFromBuffer() throws IOException {
    }

    private void closeConnections() {
        if (this.exchange.getStatus() != ExchangeState.COMPLETED) {
            try {
                this.sender.send(this.streamId, (encoder, peerSettings) -> ImmutableList.of((Object)RstStreamFrame.construct(this.streamId, 2)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

