/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http2.Http2ExchangeHandler;
import com.predic8.membrane.core.transport.http2.Http2Logic;
import com.predic8.membrane.core.transport.http2.Http2MessageHandler;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.DNSCache;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ServerHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger((String)Http2ServerHandler.class.getName());
    public static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private static final ExecutorService executor = Util.createNewThreadPool();
    public static final String HTTP2 = "h2_server";
    private final HttpServerHandler httpServerHandler;
    private final Http2Logic logic;

    public Http2ServerHandler(final HttpServerHandler httpServerHandler, final Socket sourceSocket, InputStream srcIn, OutputStream srcOut, boolean showSSLExceptions) {
        super(httpServerHandler.getTransport());
        this.httpServerHandler = httpServerHandler;
        this.logic = new Http2Logic(executor, sourceSocket, srcIn, srcOut, showSSLExceptions, new Http2MessageHandler(){

            @Override
            public Message createMessage() {
                return new Request();
            }

            @Override
            public void handleExchange(StreamInfo streamInfo, Message message, boolean showSSLExceptions, String remoteAddr) {
                Exchange exchange = new Exchange(httpServerHandler);
                exchange.setProperty(Http2ServerHandler.HTTP2, true);
                exchange.setRequest((Request)message);
                exchange.received();
                DNSCache dnsCache = httpServerHandler.getTransport().getRouter().getDnsCache();
                InetAddress remoteAddr2 = sourceSocket.getInetAddress();
                String ip = dnsCache.getHostAddress(remoteAddr2);
                exchange.setRemoteAddrIp(ip);
                exchange.setRemoteAddr(httpServerHandler.getTransport().isReverseDNS() ? dnsCache.getHostName(remoteAddr2) : ip);
                exchange.setOriginalRequestUri(((Request)message).getUri());
                executor.submit(new Http2ExchangeHandler(streamInfo, httpServerHandler.getTransport(), Http2ServerHandler.this.logic.sender, Http2ServerHandler.this.logic.peerSettings, Http2ServerHandler.this.logic.peerFlowControl, exchange, showSSLExceptions, remoteAddr));
            }
        });
    }

    public void handle() throws IOException, EndOfStreamException {
        byte[] preface = ByteUtil.readByteArray(this.logic.srcIn, 24);
        if (!this.isCorrectPreface(preface)) {
            throw new RuntimeException("Incorrect Preface.");
        }
        this.logic.init();
        this.logic.handle();
    }

    private boolean isCorrectPreface(byte[] preface) {
        if (preface.length != PREFACE.length) {
            return false;
        }
        for (int i = 0; i < PREFACE.length; ++i) {
            if (preface[i] == PREFACE[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new NotImplementedException("");
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.httpServerHandler.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.httpServerHandler.getLocalPort();
    }
}

