/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class Http2TlsSupport {
    private static Method setApplicationProtocols;
    private static Method getApplicationProtocol;

    public static void offerHttp2(SSLServerSocket sslss) {
        if (setApplicationProtocols == null) {
            throw new RuntimeException("Support for HTTP/2 is only available when using newer JDKs.");
        }
        SSLParameters sslp = sslss.getSSLParameters();
        try {
            setApplicationProtocols.invoke((Object)sslp, new Object[]{new String[]{"h2", "http/1.1"}});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        sslss.setSSLParameters(sslp);
    }

    public static void offerHttp2(SSLSocket ssls) {
        if (setApplicationProtocols == null) {
            throw new RuntimeException("Support for HTTP/2 is only available when using newer JDKs.");
        }
        SSLParameters sslp = ssls.getSSLParameters();
        try {
            setApplicationProtocols.invoke((Object)sslp, new Object[]{new String[]{"h2", "http/1.1"}});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ssls.setSSLParameters(sslp);
    }

    public static boolean isHttp2(Socket s) {
        if (!(s instanceof SSLSocket)) {
            return false;
        }
        if (getApplicationProtocol == null) {
            return false;
        }
        try {
            String protocol = (String)getApplicationProtocol.invoke((Object)s, new Object[0]);
            return "h2".equals(protocol);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method setApplicationProtocols = null;
        Method getApplicationProtocol = null;
        try {
            setApplicationProtocols = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            getApplicationProtocol = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Http2TlsSupport.setApplicationProtocols = setApplicationProtocols;
        Http2TlsSupport.getApplicationProtocol = getApplicationProtocol;
    }
}

