/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.Settings;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerFlowControl {
    private static final Logger log = LoggerFactory.getLogger(PeerFlowControl.class);
    private final int streamId;
    @GuardedBy(value="this")
    public long peerWindowSize;
    @GuardedBy(value="this")
    public long peerWindowPosition;

    public PeerFlowControl(int streamId, FrameSender sender, Settings peerSettings) {
        this.streamId = streamId;
        this.peerWindowSize = peerSettings.getInitialWindowSize();
    }

    public synchronized void increment(int delta) {
        this.peerWindowSize += (long)delta;
        if (log.isDebugEnabled()) {
            log.debug("stream=" + this.streamId + " size=" + this.peerWindowSize + " pos=" + this.peerWindowPosition + " diff=" + (this.peerWindowSize - this.peerWindowPosition));
        }
        this.notifyAll();
    }

    private void used(int length) {
        this.peerWindowPosition += (long)length;
        if (log.isDebugEnabled()) {
            log.debug("stream=" + this.streamId + " size=" + this.peerWindowSize + " pos=" + this.peerWindowPosition + " diff=" + (this.peerWindowSize - this.peerWindowPosition));
        }
    }

    private boolean canUse(int length) {
        return this.peerWindowSize - this.peerWindowPosition >= (long)length;
    }

    public synchronized void reserve(int wantLength, int streamId) {
        boolean warned = false;
        while (!this.canUse(wantLength)) {
            if (!warned) {
                log.warn("stream " + streamId + " blocked because of flow control on stream " + this.streamId + ".");
                warned = true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.used(wantLength);
    }
}

