/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.transport.http2.FlowControl;
import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.PeerFlowControl;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.StreamState;
import com.predic8.membrane.core.transport.http2.frame.DataFrame;
import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamInfo {
    private static final Logger log = LoggerFactory.getLogger(StreamInfo.class);
    private final FlowControl flowControl;
    private final PeerFlowControl peerFlowControl;
    private final LinkedTransferQueue<DataFrame> dataFramesReceived = new LinkedTransferQueue();
    private final int streamId;
    private final List<StreamInfo> priorityChildren = new ArrayList<StreamInfo>();
    private final LinkedTransferQueue<Frame> dataFramesToBeSent = new LinkedTransferQueue();
    private final Semaphore bufferedDataFrames = new Semaphore(4);
    private StreamInfo priorityParent = null;
    private StreamState state = StreamState.IDLE;
    private int weight;
    private Message message;
    private boolean isTrailer;

    public StreamInfo(int streamId, FrameSender sender, Settings peerSettings, Settings ourSettings) {
        this.streamId = streamId;
        if (streamId == 0) {
            this.peerFlowControl = null;
            this.flowControl = null;
        } else {
            this.peerFlowControl = new PeerFlowControl(streamId, sender, peerSettings);
            this.flowControl = new FlowControl(streamId, sender, ourSettings);
        }
    }

    public void receivedDataFrame(DataFrame df) {
        this.dataFramesReceived.add(df);
        this.flowControl.received(df.getFrame().getLength());
        if (df.isEndStream()) {
            this.receivedEndStream(true);
        }
    }

    public DataFrame removeDataFrame() throws IOException {
        try {
            DataFrame dataFrame = this.dataFramesReceived.poll(1L, TimeUnit.MINUTES);
            if (dataFrame != null) {
                this.flowControl.processed(dataFrame.getFrame().getLength());
            }
            return dataFrame;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public AbstractBody createBody() {
        return new Http2Body();
    }

    public PeerFlowControl getPeerFlowControl() {
        return this.peerFlowControl;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public synchronized void receivedRstStream() {
        if (this.state == StreamState.IDLE) {
            return;
        }
        this.setState(StreamState.CLOSED);
    }

    public synchronized void receivedEndStream(boolean fromDataFrame) {
        if (this.state == StreamState.OPEN) {
            this.setState(StreamState.HALF_CLOSED_REMOTE);
        }
        if (this.state == StreamState.HALF_CLOSED_LOCAL) {
            this.setState(StreamState.CLOSED);
        }
        if (!fromDataFrame) {
            Frame frame = new Frame();
            frame.fill(0, 1, this.streamId, null, 0, 0);
            this.dataFramesReceived.add(frame.asData());
        }
    }

    public synchronized void receivedHeaders() throws IOException {
        if (this.state != StreamState.IDLE && this.state != StreamState.RESERVED_REMOTE && this.state != StreamState.RESERVED_LOCAL && this.state != StreamState.OPEN && this.state != StreamState.HALF_CLOSED_LOCAL) {
            throw new FatalConnectionException(1);
        }
        if (this.state == StreamState.IDLE) {
            this.setState(StreamState.OPEN);
        }
        if (this.state == StreamState.RESERVED_REMOTE) {
            this.setState(StreamState.HALF_CLOSED_LOCAL);
        }
        this.isTrailer = true;
    }

    private void setState(StreamState state) {
        this.state = state;
        log.debug("streamId=" + this.streamId + " changed state to " + state);
    }

    public void receivedPriority() {
    }

    public synchronized void sendRstStream() {
        if (this.state == StreamState.IDLE) {
            return;
        }
        this.setState(StreamState.CLOSED);
    }

    public synchronized void sendHeaders() {
        if (this.state == StreamState.IDLE) {
            this.setState(StreamState.OPEN);
        }
        if (this.state == StreamState.RESERVED_LOCAL) {
            this.setState(StreamState.HALF_CLOSED_REMOTE);
        }
    }

    public synchronized void sendEndStream() {
        if (this.state == StreamState.OPEN) {
            this.setState(StreamState.HALF_CLOSED_LOCAL);
        }
        if (this.state == StreamState.HALF_CLOSED_REMOTE) {
            this.setState(StreamState.CLOSED);
        }
    }

    public List<StreamInfo> getPriorityChildren() {
        return this.priorityChildren;
    }

    public StreamInfo getPriorityParent() {
        return this.priorityParent;
    }

    public void setPriorityParent(StreamInfo priorityParent) {
        this.priorityParent = priorityParent;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public synchronized StreamState getState() {
        return this.state;
    }

    public LinkedTransferQueue<Frame> getDataFramesToBeSent() {
        return this.dataFramesToBeSent;
    }

    public Semaphore getBufferedDataFrames() {
        return this.bufferedDataFrames;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public boolean isTrailer() {
        return this.isTrailer;
    }

    public String toString() {
        return "StreamInfo{streamId=" + this.streamId + ", state=" + this.state + "}";
    }

    private class Http2Body
    extends AbstractBody {
        int streamedLength = 0;
        Header trailer;

        private Http2Body() {
        }

        @Override
        protected void readLocal() throws IOException {
            while (true) {
                DataFrame df;
                if ((df = StreamInfo.this.removeDataFrame()) == null) {
                    continue;
                }
                this.chunks.add(new Chunk(this.createByteArray(df)));
                if (df.isEndStream()) break;
            }
        }

        private byte[] createByteArray(DataFrame df) {
            int len = df.getDataLength();
            byte[] buf = new byte[len];
            if (len > 0) {
                System.arraycopy(df.getContent(), df.getDataStartIndex(), buf, 0, len);
            }
            return buf;
        }

        @Override
        protected void writeAlreadyRead(AbstractBodyTransferrer out) throws IOException {
            if (this.getLength() > 0) {
                out.write(this.getContent(), 0, this.getLength());
            }
            out.finish(this.trailer);
        }

        @Override
        protected void writeNotRead(AbstractBodyTransferrer out) throws IOException {
            this.chunks.clear();
            while (true) {
                DataFrame df;
                if ((df = StreamInfo.this.removeDataFrame()) == null) {
                    continue;
                }
                int len = df.getDataLength();
                if (len > 0) {
                    out.write(df.getContent(), df.getDataStartIndex(), len);
                }
                this.chunks.add(new Chunk(this.createByteArray(df)));
                if (df.isEndStream()) break;
            }
            out.finish(this.trailer);
            this.markAsRead();
        }

        @Override
        protected void writeStreamed(AbstractBodyTransferrer out) throws IOException {
            this.chunks.clear();
            while (true) {
                DataFrame df;
                if ((df = StreamInfo.this.removeDataFrame()) == null) {
                    continue;
                }
                int len = df.getDataLength();
                if (len > 0) {
                    out.write(df.getContent(), df.getDataStartIndex(), len);
                    this.streamedLength += len;
                }
                if (df.isEndStream()) break;
            }
            out.finish(this.trailer);
            this.markAsRead();
        }

        @Override
        protected byte[] getRawLocal() throws IOException {
            if (this.chunks.isEmpty()) {
                log.debug("size of chunks list: " + this.chunks.size() + "  " + this.hashCode());
                log.debug("chunks size is: " + this.chunks.size() + " at time: " + System.currentTimeMillis());
                return new byte[0];
            }
            return this.getContent();
        }

        @Override
        public int getLength() throws IOException {
            if (this.wasStreamed()) {
                return this.streamedLength;
            }
            return super.getLength();
        }

        @Override
        public boolean hasTrailer() {
            return this.trailer != null;
        }

        @Override
        public Header getTrailer() {
            return this.trailer;
        }

        @Override
        public boolean setTrailer(Header trailer) {
            this.trailer = trailer;
            return true;
        }
    }
}

