/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.frame.ContinuationFrame;
import com.predic8.membrane.core.transport.http2.frame.DataFrame;
import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import com.predic8.membrane.core.transport.http2.frame.GoawayFrame;
import com.predic8.membrane.core.transport.http2.frame.HeadersFrame;
import com.predic8.membrane.core.transport.http2.frame.PingFrame;
import com.predic8.membrane.core.transport.http2.frame.PriorityFrame;
import com.predic8.membrane.core.transport.http2.frame.PushPromiseFrame;
import com.predic8.membrane.core.transport.http2.frame.RstStreamFrame;
import com.predic8.membrane.core.transport.http2.frame.SettingsFrame;
import com.predic8.membrane.core.transport.http2.frame.WindowUpdateFrame;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.NotImplementedException;

public class Frame {
    public static final int TYPE_DATA = 0;
    public static final int TYPE_HEADERS = 1;
    public static final int TYPE_PRIORITY = 2;
    public static final int TYPE_RST_STREAM = 3;
    public static final int TYPE_SETTINGS = 4;
    public static final int TYPE_PUSH_PROMISE = 5;
    public static final int TYPE_PING = 6;
    public static final int TYPE_GOAWAY = 7;
    public static final int TYPE_WINDOW_UPDATE = 8;
    public static final int TYPE_CONTINUATION = 9;
    final int maximumFrameSize;
    int length;
    int type;
    int flags;
    int streamId;
    byte[] content;

    public Frame(Settings ourSettings) {
        this.maximumFrameSize = ourSettings.getMaxFrameSize();
    }

    public Frame() {
        this.maximumFrameSize = -1;
    }

    public void fill(int type, int flags, int streamId, byte[] buf, int offset, int length) {
        this.length = length;
        this.type = type;
        this.flags = flags;
        this.streamId = streamId;
        if (length == 0) {
            this.content = null;
        } else {
            this.content = new byte[length];
            System.arraycopy(buf, offset, this.content, 0, length);
        }
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.length >> 16);
        stream.write(this.length >> 8);
        stream.write(this.length);
        stream.write(this.type);
        stream.write(this.flags);
        stream.write(this.streamId >> 24 & 0x7F);
        stream.write(this.streamId >> 16);
        stream.write(this.streamId >> 8);
        stream.write(this.streamId);
        if (this.length > 0) {
            stream.write(this.content, 0, this.length);
        }
    }

    public void read(InputStream stream) throws IOException {
        this.length = this.readByte(stream) << 16 | this.readByte(stream) << 8 | this.readByte(stream);
        if (this.length > this.maximumFrameSize) {
            throw new FatalConnectionException(6);
        }
        this.type = this.readByte(stream);
        this.flags = this.readByte(stream);
        this.streamId = (this.readByte(stream) & 0x7F) << 24 | this.readByte(stream) << 16 | this.readByte(stream) << 8 | this.readByte(stream);
        this.content = ByteUtil.readByteArray(stream, this.length);
    }

    private int readByte(InputStream stream) throws IOException {
        int read = stream.read();
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    public SettingsFrame asSettings() {
        if (this.type != 4) {
            throw new IllegalStateException();
        }
        return new SettingsFrame(this);
    }

    public WindowUpdateFrame asWindowUpdate() {
        if (this.type != 8) {
            throw new IllegalStateException();
        }
        return new WindowUpdateFrame(this);
    }

    public HeadersFrame asHeaders() {
        if (this.type != 1) {
            throw new IllegalStateException();
        }
        return new HeadersFrame(this);
    }

    public ContinuationFrame asContinuation() {
        if (this.type != 9) {
            throw new IllegalStateException();
        }
        return new ContinuationFrame(this);
    }

    public DataFrame asData() {
        if (this.type != 0) {
            throw new IllegalStateException();
        }
        return new DataFrame(this);
    }

    public PriorityFrame asPriority() {
        if (this.type != 2) {
            throw new IllegalStateException();
        }
        return new PriorityFrame(this);
    }

    public PingFrame asPing() {
        if (this.type != 6) {
            throw new IllegalStateException();
        }
        return new PingFrame(this);
    }

    public GoawayFrame asGoaway() {
        if (this.type != 7) {
            throw new IllegalStateException();
        }
        return new GoawayFrame(this);
    }

    public RstStreamFrame asRstStream() {
        if (this.type != 3) {
            throw new IllegalStateException();
        }
        return new RstStreamFrame(this);
    }

    public PushPromiseFrame asPushPromise() {
        if (this.type != 5) {
            throw new IllegalStateException();
        }
        return new PushPromiseFrame(this);
    }

    public String toString() {
        switch (this.type) {
            case 4: {
                return this.asSettings().toString();
            }
            case 8: {
                return this.asWindowUpdate().toString();
            }
            case 1: {
                return this.asHeaders().toString();
            }
            case 0: {
                return this.asData().toString();
            }
            case 2: {
                return this.asPriority().toString();
            }
            case 6: {
                return this.asPing().toString();
            }
            case 7: {
                return this.asGoaway().toString();
            }
            case 3: {
                return this.asRstStream().toString();
            }
            case 5: {
                return this.asPushPromise().toString();
            }
            case 9: {
                return this.asContinuation().toString();
            }
        }
        throw new NotImplementedException("type = " + this.type);
    }

    public void appendHex(StringBuilder sb, byte[] buffer, int offset, int length, int indent) {
        for (int i = 0; i < length; i += 16) {
            int j;
            for (j = 0; j < indent; ++j) {
                sb.append(" ");
            }
            sb.append(String.format("%04X", i));
            sb.append(": ");
            for (j = 0; j < 16; ++j) {
                if (i + j >= length) {
                    sb.append("  ");
                } else {
                    sb.append(String.format("%02X", buffer[offset + i + j]));
                }
                if (j == 7) {
                    sb.append("   ");
                    continue;
                }
                sb.append(" ");
            }
            sb.append("  ");
            for (j = 0; j < 16 && i + j < length; ++j) {
                if (buffer[offset + i + j] < 32) {
                    sb.append(".");
                    continue;
                }
                sb.append((char)buffer[offset + i + j]);
            }
            sb.append("\n");
        }
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        switch (this.type) {
            case 0: {
                return "DATA";
            }
            case 1: {
                return "HEADERS";
            }
            case 2: {
                return "PRIORITY";
            }
            case 3: {
                return "RST_STREAM";
            }
            case 4: {
                return "SETTINGS";
            }
            case 5: {
                return "PUSH_PROMISE";
            }
            case 6: {
                return "PING";
            }
            case 7: {
                return "GOAWAY";
            }
            case 8: {
                return "WINDOW_UPDATE";
            }
            case 9: {
                return "CONTINUATION";
            }
        }
        return "unknown (" + this.type + ")";
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getLength() {
        return this.length;
    }

    public int getFlags() {
        return this.flags;
    }
}

