/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;

public class GoawayFrame {
    private final Frame frame;
    private final int lastStreamId;
    private final int errorCode;

    public GoawayFrame(Frame frame) {
        this.frame = frame;
        this.lastStreamId = (frame.content[0] & 0x7F) << 24 | (frame.content[1] & 0xFF) << 16 | (frame.content[2] & 0xFF) << 8 | frame.content[3] & 0xFF;
        this.errorCode = (frame.content[4] & 0xFF) << 24 | (frame.content[5] & 0xFF) << 16 | (frame.content[6] & 0xFF) << 8 | frame.content[7] & 0xFF;
    }

    public static Frame construct(int streamId, int lastStreamId, int errorCode) {
        byte[] buf = new byte[]{(byte)(lastStreamId >> 24 & 0x7F), (byte)(lastStreamId >> 16), (byte)(lastStreamId >> 8), (byte)lastStreamId, (byte)(errorCode >> 24 & 0x7F), (byte)(errorCode >> 16), (byte)(errorCode >> 8), (byte)errorCode};
        Frame frame = new Frame();
        frame.fill(7, 0, streamId, buf, 0, 8);
        return frame;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Goaway {\n");
        sb.append("  lastStreamId = ");
        sb.append(this.lastStreamId);
        sb.append("\n  errorCode = ");
        sb.append(this.errorCode);
        sb.append("\n  additional debug data:\n");
        this.frame.appendHex(sb, this.frame.content, 8, this.frame.length - 8, 2);
        sb.append("}");
        return sb.toString();
    }

    public Frame getFrame() {
        return this.frame;
    }
}

