/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.HeaderBlockFragment;
import com.predic8.membrane.core.transport.http2.frame.StreamEnd;

public class HeadersFrame
implements HeaderBlockFragment,
StreamEnd {
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    private final Frame frame;
    private final int padLength;
    private final boolean exclusive;
    private final int streamDependency;
    private final int weight;
    private final int headerBlockStartIndex;

    public HeadersFrame(Frame frame) {
        this.frame = frame;
        int p = 0;
        this.padLength = this.isPadded() ? frame.content[p++] : 0;
        if (this.isPriority()) {
            this.exclusive = (frame.content[p] & 0x80) != 0;
            this.streamDependency = (frame.content[p++] & 0x7F) << 24 | (frame.content[p++] & 0xFF) << 16 | (frame.content[p++] & 0xFF) << 8 | frame.content[p++] & 0xFF;
            this.weight = (frame.content[p++] & 0xFF) + 1;
        } else {
            this.exclusive = false;
            this.streamDependency = 0;
            this.weight = 0;
        }
        this.headerBlockStartIndex = p;
    }

    @Override
    public boolean isEndStream() {
        return (this.frame.flags & 1) != 0;
    }

    @Override
    public boolean isEndHeaders() {
        return (this.frame.flags & 4) != 0;
    }

    public boolean isPadded() {
        return (this.frame.flags & 8) != 0;
    }

    public boolean isPriority() {
        return (this.frame.flags & 0x20) != 0;
    }

    @Override
    public int getHeaderBlockStartIndex() {
        return this.headerBlockStartIndex;
    }

    @Override
    public int getHeaderBlockLength() {
        return this.frame.length - this.padLength - this.headerBlockStartIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Headers {\n");
        sb.append("  streamId = ");
        sb.append(this.frame.streamId);
        sb.append("\n  flags = ");
        if (this.isEndHeaders()) {
            sb.append("END_HEADERS ");
        }
        if (this.isEndStream()) {
            sb.append("END_STREAM");
        }
        sb.append("\n");
        if (this.isPriority()) {
            sb.append("  priority: ");
            if (this.exclusive) {
                sb.append("exclusive, ");
            }
            sb.append("weight = ");
            sb.append(this.weight);
            sb.append(", streamDependency = ");
            sb.append(this.streamDependency);
            sb.append("\n");
        }
        sb.append("  header block data: \n");
        this.frame.appendHex(sb, this.frame.content, this.getHeaderBlockStartIndex(), this.getHeaderBlockLength(), 2);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public byte[] getContent() {
        return this.frame.getContent();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

