/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import java.io.IOException;

public class RstStreamFrame {
    private final Frame frame;
    private final int errorCode;

    public RstStreamFrame(Frame frame) {
        this.frame = frame;
        this.errorCode = (frame.content[0] & 0xFF) << 24 | (frame.content[1] & 0xFF) << 16 | (frame.content[2] & 0xFF) << 8 | frame.content[3] & 0xFF;
    }

    public static Frame construct(int streamId, int errorCode) {
        byte[] buf = new byte[]{(byte)(errorCode >> 24 & 0x7F), (byte)(errorCode >> 16), (byte)(errorCode >> 8), (byte)errorCode};
        Frame frame = new Frame();
        frame.fill(3, 0, streamId, buf, 0, 4);
        return frame;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RstStream {\n");
        sb.append("\n  errorCode = ");
        sb.append(this.errorCode);
        sb.append("}");
        return sb.toString();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void validateSize() throws IOException {
        if (this.frame.length != 4) {
            throw new FatalConnectionException(6);
        }
    }
}

