/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import org.apache.commons.lang3.NotImplementedException;

public class SettingsFrame {
    public static final int FLAG_ACK = 1;
    public static final int ID_SETTINGS_HEADER_TABLE_SIZE = 1;
    public static final int ID_SETTINGS_ENABLE_PUSH = 2;
    public static final int ID_SETTINGS_MAX_CONCURRENT_STREAMS = 3;
    public static final int ID_SETTINGS_INITIAL_WINDOW_SIZE = 4;
    public static final int ID_SETTINGS_MAX_FRAME_SIZE = 5;
    public static final int ID_SETTINGS_MAX_HEADER_LIST_SIZE = 6;
    private final Frame frame;

    public SettingsFrame(Frame frame) {
        this.frame = frame;
    }

    public int getSettingsCount() {
        return this.frame.length / 6;
    }

    public int getSettingsId(int i) {
        if (i < 0 || i >= this.getSettingsCount()) {
            throw new IllegalArgumentException();
        }
        return (this.frame.content[i * 6] & 0xFF) << 8 | this.frame.content[i * 6 + 1] & 0xFF;
    }

    public long getSettingsValue(int i) {
        if (i < 0 || i >= this.getSettingsCount()) {
            throw new IllegalArgumentException();
        }
        return (long)(this.frame.content[i * 6 + 2] & 0xFF) << 24 | (long)((this.frame.content[i * 6 + 3] & 0xFF) << 16) | (long)((this.frame.content[i * 6 + 4] & 0xFF) << 8) | (long)(this.frame.content[i * 6 + 5] & 0xFF);
    }

    public String getSettingsIdAsString(int i) {
        switch (this.getSettingsId(i)) {
            case 1: {
                return "SETTINGS_HEADER_TABLE_SIZE";
            }
            case 2: {
                return "SETTINGS_ENABLE_PUSH";
            }
            case 3: {
                return "SETTINGS_MAX_CONCURRENT_STREAMS";
            }
            case 4: {
                return "SETTINGS_INITIAL_WINDOW_SIZE";
            }
            case 5: {
                return "SETTINGS_MAX_FRAME_SIZE ";
            }
            case 6: {
                return "SETTINGS_MAX_HEADER_LIST_SIZE ";
            }
        }
        throw new NotImplementedException("i=" + i);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Settings {\n");
        if (this.isAck()) {
            sb.append("  Flags: ACK\n");
        }
        for (int i = 0; i < this.getSettingsCount(); ++i) {
            sb.append("  ");
            sb.append(this.getSettingsIdAsString(i));
            sb.append(" = ");
            sb.append(this.getSettingsValue(i));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Frame ack() {
        Frame frame = new Frame();
        frame.fill(4, 1, 0, null, 0, 0);
        return frame;
    }

    public static Frame empty() {
        Frame frame = new Frame();
        frame.fill(4, 0, 0, null, 0, 0);
        return frame;
    }

    public static Frame diff(Settings oldS, Settings newS) {
        byte[] buf = new byte[36];
        int p = 0;
        p = SettingsFrame.put(p, buf, 1, oldS.getHeaderTableSize(), newS.getHeaderTableSize());
        p = SettingsFrame.put(p, buf, 2, oldS.getEnablePush(), newS.getEnablePush());
        p = SettingsFrame.put(p, buf, 3, oldS.getMaxConcurrentStreams(), newS.getMaxConcurrentStreams());
        p = SettingsFrame.put(p, buf, 4, oldS.getInitialWindowSize(), newS.getInitialWindowSize());
        p = SettingsFrame.put(p, buf, 5, oldS.getMaxFrameSize(), newS.getMaxFrameSize());
        p = SettingsFrame.put(p, buf, 6, oldS.getMaxHeaderListSize(), newS.getMaxHeaderListSize());
        Frame frame = new Frame();
        frame.fill(4, 0, 0, buf, 0, p);
        return frame;
    }

    private static int put(int p, byte[] buf, int key, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return p;
        }
        buf[p++] = (byte)(key >> 8);
        buf[p++] = (byte)key;
        buf[p++] = (byte)(newValue >> 24);
        buf[p++] = (byte)(newValue >> 16);
        buf[p++] = (byte)(newValue >> 8);
        buf[p++] = (byte)newValue;
        return p;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isAck() {
        return (this.frame.flags & 1) != 0;
    }
}

