/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl.acme;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.predic8.membrane.core.config.security.acme.KubernetesStorage;
import com.predic8.membrane.core.kubernetes.client.KubernetesApiException;
import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyPair;
import com.predic8.membrane.core.transport.ssl.acme.AcmeSynchronizedStorageEngine;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcmeKubernetesStorageEngine
implements AcmeSynchronizedStorageEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeKubernetesStorageEngine.class);
    private final KubernetesClient client;
    private final String namespace;
    private final String lease;
    private final String identity = UUID.randomUUID().toString();
    private final SimpleDateFormat sdf;
    private final SimpleDateFormat sdf2;
    private final String accountSecret;
    private final String prefix;

    public AcmeKubernetesStorageEngine(KubernetesStorage ks, @Nullable KubernetesClientFactory kubernetesClientFactory) {
        if (kubernetesClientFactory == null) {
            kubernetesClientFactory = new KubernetesClientFactory(null);
        }
        this.client = kubernetesClientFactory.createClient(ks.getBaseURL());
        this.namespace = ks.getNamespace() != null ? ks.getNamespace() : this.client.getNamespace();
        this.lease = ks.getMasterLease();
        LOG.info("acme: using identity " + this.identity + " for master election");
        this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS000'Z'");
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.sdf2.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.accountSecret = ks.getAccountSecret();
        this.prefix = ks.getPrefix() == null ? "" : ks.getPrefix();
    }

    @Override
    public String getAccountKey() {
        return this.getSecretEntry(this.accountSecret, "key");
    }

    @Override
    public void setAccountKey(String key) {
        this.setSecretEntry(this.accountSecret, "key", key);
    }

    @Override
    public String getAccountURL() {
        return this.getSecretEntry(this.accountSecret, "url");
    }

    @Override
    public void setAccountURL(String url) {
        this.setSecretEntry(this.accountSecret, "url", url);
    }

    @Override
    public String getAccountContacts() {
        return this.getSecretEntry(this.accountSecret, "contacts");
    }

    @Override
    public void setAccountContacts(String contacts) {
        this.setSecretEntry(this.accountSecret, "contacts", contacts);
    }

    @Override
    public void setKeyPair(String[] hosts, AcmeKeyPair key) {
        this.setSecretEntry(this.prefix + this.id(hosts), "key-public", key.getPublicKey(), "key-private", key.getPrivateKey());
    }

    @Override
    public String getPublicKey(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts), "key-public");
    }

    @Override
    public String getPrivateKey(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts), "key-private");
    }

    @Override
    public void setCertChain(String[] hosts, String caChain) {
        this.setSecretEntry(this.prefix + this.id(hosts), "certs", caChain);
    }

    @Override
    public String getCertChain(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts), "certs");
    }

    @Override
    public void setToken(String host, String token) {
        this.setSecretEntry(this.prefix + host + "-token", "token", token);
    }

    @Override
    public String getToken(String host) {
        return this.getSecretEntry(this.prefix + host + "-token", "token");
    }

    @Override
    public String getOAL(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "oal");
    }

    @Override
    public void setOAL(String[] hosts, String oal) {
        this.setSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "oal", oal);
    }

    @Override
    public String getOALError(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "error");
    }

    @Override
    public void setOALError(String[] hosts, String oalError) {
        this.setSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "error", oalError);
    }

    @Override
    public String getOALKey(String[] hosts) {
        return this.getSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "key");
    }

    @Override
    public void setOALKey(String[] hosts, String oalKey) {
        this.setSecretEntry(this.prefix + this.id(hosts) + "-oal-current", "key", oalKey);
    }

    @Override
    public void archiveOAL(String[] hosts) {
        try {
            Map secret = this.client.read("v1", "Secret", this.namespace, this.prefix + this.id(hosts) + "-oal-current");
            Map metadata = (Map)secret.get("metadata");
            metadata.remove("managedFields");
            metadata.remove("creationTimestamp");
            metadata.remove("uid");
            metadata.remove("resourceVersion");
            metadata.put("name", this.prefix + this.id(hosts) + "-oal-" + System.currentTimeMillis());
            this.client.create(secret);
            this.client.delete("v1", "Secret", this.namespace, this.prefix + this.id(hosts) + "-oal-current");
        }
        catch (KubernetesApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireLease(long durationMillis) {
        String renewTime;
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            renewTime = this.sdf.format(new Date(System.currentTimeMillis() + durationMillis));
        }
        ImmutableMap l = ImmutableMap.of((Object)"apiVersion", (Object)"coordination.k8s.io/v1", (Object)"kind", (Object)"Lease", (Object)"metadata", (Object)ImmutableMap.of((Object)"name", (Object)this.lease, (Object)"namespace", (Object)this.namespace), (Object)"spec", (Object)ImmutableMap.of());
        try {
            this.client.createAndEdit((Map)l, le -> {
                String oldHolder;
                HashMap<String, Object> spec = (HashMap<String, Object>)le.get("spec");
                if (spec == null) {
                    spec = new HashMap<String, Object>();
                    le.put("spec", spec);
                }
                if ((oldHolder = (String)spec.get("holderIdentity")) != null && !"".equals(oldHolder)) {
                    String oldRenew = (String)spec.get("renewTime");
                    if (oldRenew == null || "".equals(oldRenew)) {
                        throw new LeaseException("holder, but no renew time is set.");
                    }
                    try {
                        if (new Date().getTime() < this.parse(oldRenew).getTime()) {
                            throw new LeaseException("lease is not expired yet.");
                        }
                    }
                    catch (ParseException e) {
                        throw new LeaseException(e);
                    }
                }
                spec.put("holderIdentity", this.identity);
                spec.put("renewTime", renewTime);
                spec.put("leaseTransitions", this.longValue(spec.get("leaseTransitions")) + 1L);
            });
            return true;
        }
        catch (LeaseException e) {
            LOG.debug("Could not acquire lease.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KubernetesApiException e) {
            LOG.warn("Could not acquire lease.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parse(String date) throws ParseException {
        int p = ((String)date).indexOf(90);
        if (p > 7 && Character.isDigit(((String)date).charAt(p - 1)) && Character.isDigit(((String)date).charAt(p - 2)) && Character.isDigit(((String)date).charAt(p - 3)) && Character.isDigit(((String)date).charAt(p - 4)) && Character.isDigit(((String)date).charAt(p - 5)) && Character.isDigit(((String)date).charAt(p - 6))) {
            date = ((String)date).substring(0, p - 3) + ((String)date).substring(p);
        }
        SimpleDateFormat simpleDateFormat = this.sdf2;
        synchronized (simpleDateFormat) {
            return this.sdf2.parse((String)date);
        }
    }

    private long longValue(Object l) {
        if (l == null) {
            return 0L;
        }
        if (l instanceof Long) {
            return (Long)l;
        }
        if (l instanceof Integer) {
            return ((Integer)l).intValue();
        }
        if (l instanceof Byte) {
            return ((Byte)l).byteValue();
        }
        if (l instanceof Short) {
            return ((Short)l).shortValue();
        }
        throw new RuntimeException("Unhandled number type: " + l.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prolongLease(long durationMillis) {
        String renewTime;
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            renewTime = this.sdf.format(new Date(System.currentTimeMillis() + durationMillis));
        }
        try {
            this.client.edit("coordination.k8s.io/v1", "Lease", this.namespace, this.lease, le -> {
                Map spec = (Map)le.get("spec");
                String oldHolder = (String)spec.get("holderIdentity");
                if (!this.identity.equals(oldHolder)) {
                    throw new LeaseException("holder is not us.");
                }
                String oldRenew = (String)spec.get("renewTime");
                try {
                    if (new Date().getTime() > this.parse(oldRenew).getTime()) {
                        throw new LeaseException("lease has already expired.");
                    }
                }
                catch (ParseException e) {
                    throw new LeaseException(e);
                }
                spec.put("renewTime", renewTime);
            });
            return true;
        }
        catch (KubernetesApiException | LeaseException e) {
            LOG.warn("could not prolong lease.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void releaseLease() {
        try {
            this.client.edit("coordination.k8s.io/v1", "Lease", this.namespace, this.lease, le -> {
                Map spec = (Map)le.get("spec");
                String oldHolder = (String)spec.get("holderIdentity");
                if (!this.identity.equals(oldHolder)) {
                    throw new LeaseException("holder is not us.");
                }
                spec.put("holderIdentity", "");
                spec.remove("renewTime");
                spec.put("leaseTransitions", this.longValue(spec.get("leaseTransitions")) + 1L);
            });
        }
        catch (KubernetesApiException | LeaseException e) {
            LOG.warn("could not release lease.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSecretEntry(String secretName, String secretKey) {
        try {
            String b64 = (String)((Map)this.client.read("v1", "Secret", this.namespace, secretName).get("data")).get(secretKey);
            if (b64 == null) {
                return null;
            }
            return new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KubernetesApiException e) {
            if (e.getCode() == 404 && "NotFound".equals(e.getReason())) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    private void setSecretEntry(String secretName, String secretKey, String value) {
        this.setSecretEntry(secretName, secretKey, value, null, null);
    }

    private void setSecretEntry(String secretName, String secretKey1, String value1, String secretKey2, String value2) {
        String v1B64 = Base64.getEncoder().encodeToString(value1.getBytes(StandardCharsets.UTF_8));
        String v2B64 = secretKey2 == null ? null : Base64.getEncoder().encodeToString(value2.getBytes(StandardCharsets.UTF_8));
        ImmutableMap secret = ImmutableMap.of((Object)"apiVersion", (Object)"v1", (Object)"data", (Object)ImmutableMap.of(), (Object)"kind", (Object)"Secret", (Object)"metadata", (Object)ImmutableMap.of((Object)"name", (Object)secretName, (Object)"namespace", (Object)this.namespace), (Object)"type", (Object)"Opaque");
        try {
            this.client.createAndEdit((Map)secret, m -> {
                HashMap<String, String> data = (HashMap<String, String>)m.get("data");
                if (data == null) {
                    data = new HashMap<String, String>();
                    m.put("data", data);
                }
                data.put(secretKey1, v1B64);
                if (secretKey2 != null) {
                    data.put(secretKey2, v2B64);
                }
            });
        }
        catch (KubernetesApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String id(String[] hosts) {
        int i = Arrays.hashCode(hosts);
        if (i < 0) {
            i = Integer.MAX_VALUE + i + 1;
        }
        return hosts[0].replaceAll("\\*\\.", "") + (String)(hosts.length > 1 ? "-" + i : "");
    }

    public void provisionDns(String domain, String record) {
        ImmutableMap wantedRecord = ImmutableMap.of((Object)"type", (Object)"TXT", (Object)"timeout", (Object)300, (Object)"value", (Object)("\"" + record + "\""));
        Object dnsRecord = ImmutableMap.of((Object)"apiVersion", (Object)"dns.predic8.de/v1beta1", (Object)"kind", (Object)"DnsRecord", (Object)"metadata", (Object)ImmutableMap.of((Object)"name", (Object)(domain + "-acme-challenge"), (Object)"namespace", (Object)this.namespace), (Object)"spec", (Object)ImmutableMap.of((Object)"hostnames", (Object)Lists.newArrayList((Object[])new String[]{"_acme-challenge." + domain}), (Object)"values", (Object)Lists.newArrayList((Object[])new Map[]{wantedRecord})));
        try {
            block7: {
                try {
                    this.client.read((Map)dnsRecord);
                    this.client.delete((Map)dnsRecord);
                }
                catch (KubernetesApiException e) {
                    if (e.getCode() == 404) break block7;
                    throw new RuntimeException(e);
                }
            }
            this.client.apply((Map)dnsRecord);
            for (int i = 0; i < 60; ++i) {
                Object success;
                Thread.sleep(500L);
                dnsRecord = this.client.read((Map)dnsRecord);
                Object status = dnsRecord.get("status");
                if (status != null && (success = ((Map)status).get("success")) != null && success.equals(true)) break;
                if (i != 59) continue;
                throw new RuntimeException("DNS challenge did not become successful within one minute.");
            }
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KubernetesApiException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LeaseException
    extends RuntimeException {
        public LeaseException(String message) {
            super(message);
        }

        public LeaseException(Throwable cause) {
            super(cause);
        }
    }
}

