/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ws;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.transport.ws.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFrameAssembler {
    protected static Logger log = LoggerFactory.getLogger((String)WebSocketFrameAssembler.class.getName());
    static final int BUFFER_SIZE = 8192;
    private final Exchange originalExchange;
    InputStream in;
    byte[] buffer = new byte[8192];

    public WebSocketFrameAssembler(InputStream in, Exchange originalExchange) {
        this.in = in;
        this.originalExchange = originalExchange;
    }

    public synchronized void readFrames(Consumer<WebSocketFrame> consumer) throws IOException {
        int read;
        WebSocketFrame frame = new WebSocketFrame();
        if (this.originalExchange != null) {
            frame.setOriginalExchange(this.originalExchange);
        }
        int offset = 0;
        while ((read = this.in.read(this.buffer, offset, this.buffer.length - offset)) > 0) {
            int handled;
            offset += read;
            while ((handled = frame.tryRead(this.buffer, 0, offset)) > 0) {
                consumer.accept(frame);
                System.arraycopy(this.buffer, handled, this.buffer, 0, offset - handled);
                offset -= handled;
            }
            if (offset < this.buffer.length || handled != 0) continue;
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }
}

