/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ws.interceptors;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.ws.WebSocketFrame;
import com.predic8.membrane.core.transport.ws.WebSocketInterceptorInterface;
import com.predic8.membrane.core.transport.ws.WebSocketSender;
import com.predic8.membrane.core.util.EndOfStreamException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@MCElement(name="wsStompReassembler")
public class WebSocketStompReassembler
implements WebSocketInterceptorInterface {
    List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    @Override
    public void init(Router router) throws Exception {
        for (Interceptor i : this.interceptors) {
            i.init(router);
        }
    }

    @Override
    public void handleFrame(WebSocketFrame wsStompFrame, boolean frameTravelsToRight, WebSocketSender sender) throws Exception {
        if (wsStompFrame.getOpcode() != 1) {
            sender.handleFrame(wsStompFrame);
            return;
        }
        Exchange exc = this.convertToExchange(wsStompFrame);
        for (int i = 0; i < this.interceptors.size(); ++i) {
            if (this.interceptors.get(i).handleRequest(exc) == Outcome.CONTINUE) continue;
            return;
        }
        this.modifyOriginalFrameWithExchange(wsStompFrame, exc);
        sender.handleFrame(wsStompFrame);
    }

    private void modifyOriginalFrameWithExchange(WebSocketFrame wsStompFrame, Exchange exc) throws IOException {
        this.baos.reset();
        if (exc.getRequest().getMethod().isEmpty()) {
            this.baos.write(10);
        } else {
            exc.getRequest().writeSTOMP(this.baos, true);
            this.baos.write(0);
        }
        wsStompFrame.setPayload(this.baos.toByteArray());
    }

    private Exchange convertToExchange(WebSocketFrame wsStompFrame) throws IOException, EndOfStreamException {
        byte[] realPayload = new byte[(int)wsStompFrame.getPayloadLength()];
        System.arraycopy(wsStompFrame.getPayload(), 0, realPayload, 0, (int)wsStompFrame.getPayloadLength());
        if (wsStompFrame.getPayloadLength() == 0L) {
            throw new IOException("Empty STOMP frame.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(wsStompFrame.getPayload(), 0, (int)wsStompFrame.getPayloadLength() - 1);
        Request request = new Request();
        if (this.isHeartBeat(wsStompFrame)) {
            request.setMethod("");
            request.setBody(new Body(bais));
        } else {
            if (wsStompFrame.getPayload()[(int)wsStompFrame.getPayloadLength() - 1] != 0) {
                throw new IOException("STOMP frame is not terminated by \\0.");
            }
            request.read(bais, true);
        }
        Exchange result = new Exchange(null);
        result.setRequest(request);
        if (wsStompFrame.getOriginalExchange() != null) {
            result.setProperty("WS_ORIGINAL_EXCHANGE", wsStompFrame.getOriginalExchange());
        }
        return result;
    }

    private boolean isHeartBeat(WebSocketFrame frame) {
        return frame.getPayloadLength() == 2L && frame.getPayload()[0] == 13 && frame.getPayload()[1] == 10 || frame.getPayloadLength() == 1L && frame.getPayload()[0] == 10;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

