/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.http.Chunk;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteUtil {
    private static Logger log = LoggerFactory.getLogger((String)ByteUtil.class.getName());

    public static byte[] readByteArray(InputStream in, int length) throws IOException {
        if (length < 0) {
            return ByteUtil.getByteArrayData(in);
        }
        byte[] content = new byte[length];
        int count = 0;
        for (int offset = 0; offset < length && (count = in.read(content, offset, length - offset)) >= 0; offset += count) {
        }
        return content;
    }

    public static byte[] getByteArrayData(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((read = stream.read(buffer)) >= 0) {
            bos.write(buffer, 0, read);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return bos.toByteArray();
    }

    public static void readStream(InputStream stream) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        while ((read = stream.read(buffer)) >= 0) {
        }
    }

    public static byte[] getDecompressedData(byte[] compressedData) throws IOException {
        Inflater decompressor = new Inflater(true);
        decompressor.setInput(compressedData);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        while (!decompressor.finished()) {
            int count;
            byte[] buf = new byte[1024];
            try {
                count = decompressor.inflate(buf);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (buf.length == count) {
                Chunk chunk = new Chunk(buf);
                chunks.add(chunk);
                continue;
            }
            if (count >= buf.length) continue;
            byte[] shortContent = new byte[count];
            System.arraycopy(buf, 0, shortContent, 0, count);
            Chunk chunk = new Chunk(shortContent);
            chunks.add(chunk);
        }
        log.debug("Number of decompressed chunks: " + chunks.size());
        if (chunks.size() > 0) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (Chunk chunk : chunks) {
                chunk.write(bos);
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bos.toByteArray();
        }
        return null;
    }

    public static int getValueOfBits(byte b, int minBitPosition, int maxBitPosition) {
        byte result = 0;
        for (int i = minBitPosition; i <= maxBitPosition; ++i) {
            if (!ByteUtil.getBitValueBigEndian(b, i)) continue;
            result = ByteUtil.setBitValueBigEndian(result, i, true);
        }
        return Byte.toUnsignedInt(result);
    }

    public static boolean getBitValueBigEndian(byte b, int position) {
        return ByteUtil.getBitValue(b, position, true);
    }

    public static boolean getBitValue(byte b, int position, boolean isBigEndian) {
        if (isBigEndian) {
            position = 7 - position;
        }
        return (b & 1 << position) != 0;
    }

    public static byte setBitValue(byte b, int position, boolean value, boolean isBigEndian) {
        if (isBigEndian) {
            position = 7 - position;
        }
        b = value ? (byte)(b | 1 << position) : (byte)(b & ~(1 << position));
        return b;
    }

    public static byte setBitValueBigEndian(byte b, int position, boolean value) {
        return ByteUtil.setBitValue(b, position, value, true);
    }

    public static byte setBitValues(byte b, int beginning, int end, int value) {
        byte valByte = (byte)value;
        for (int i = beginning; i <= end; ++i) {
            if (!ByteUtil.getBitValueBigEndian(valByte, i)) continue;
            b = ByteUtil.setBitValueBigEndian(b, i, true);
        }
        return b;
    }

    public static byte setBitValuesBigEndian(byte b, int beginning, int end, int value) {
        return ByteUtil.setBitValues(b, beginning, end, value);
    }

    public static int getNumberOfBits(int i) {
        return 32 - Integer.numberOfLeadingZeros(i);
    }
}

