/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangesUtil;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.interceptor.statistics.PropertyComparator;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import java.util.Comparator;

public class ComparatorFactory {
    public static Comparator<AbstractExchange> getAbstractExchangeComparator(String propName, String order) {
        if ("statusCode".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Integer>(order, new PropertyComparator.ValueResolver<AbstractExchange, Integer>(){

                @Override
                public Integer get(AbstractExchange exc) {
                    return exc.getResponse().getStatusCode();
                }
            });
        }
        if ("proxy".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRule().toString();
                }
            });
        }
        if ("method".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRequest().getMethod();
                }
            });
        }
        if ("path".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRequest().getUri();
                }
            });
        }
        if ("client".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRemoteAddr();
                }
            });
        }
        if ("server".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getServer();
                }
            });
        }
        if ("reqContentType".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRequestContentType();
                }
            });
        }
        if ("reqContentLength".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, new PropertyComparator.ValueResolver<AbstractExchange, Long>(){

                @Override
                public Long get(AbstractExchange exc) {
                    return exc.getRequestContentLength();
                }
            });
        }
        if ("respContentType".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getResponseContentType();
                }
            });
        }
        if ("respContentLength".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, new PropertyComparator.ValueResolver<AbstractExchange, Long>(){

                @Override
                public Long get(AbstractExchange exc) {
                    return exc.getResponseContentLength();
                }
            });
        }
        if ("duration".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, new PropertyComparator.ValueResolver<AbstractExchange, Long>(){

                @Override
                public Long get(AbstractExchange exc) {
                    return exc.getTimeResReceived() - exc.getTimeReqSent();
                }
            });
        }
        if ("msgFilePath".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return exc.getRequest().getMethod();
                }
            });
        }
        if ("time".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, new PropertyComparator.ValueResolver<AbstractExchange, String>(){

                @Override
                public String get(AbstractExchange exc) {
                    return ExchangesUtil.getTime(exc);
                }
            });
        }
        throw new IllegalArgumentException("AbstractExchange can't be compared using property [" + propName + "]");
    }

    public static Comparator<AbstractServiceProxy> getAbstractServiceProxyComparator(String propName, String order) {
        if ("listenPort".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, Integer>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, Integer>(){

                @Override
                public Integer get(AbstractServiceProxy p) {
                    return p.getKey().getPort();
                }
            });
        }
        if ("virtualHost".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, String>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, String>(){

                @Override
                public String get(AbstractServiceProxy p) {
                    return p.getKey().getHost();
                }
            });
        }
        if ("method".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, String>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, String>(){

                @Override
                public String get(AbstractServiceProxy p) {
                    return p.getKey().getMethod();
                }
            });
        }
        if ("path".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, String>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, String>(){

                @Override
                public String get(AbstractServiceProxy p) {
                    return p.getKey().getPath();
                }
            });
        }
        if ("targetHost".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, String>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, String>(){

                @Override
                public String get(AbstractServiceProxy p) {
                    return p.getTargetHost();
                }
            });
        }
        if ("targetPort".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, Integer>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, Integer>(){

                @Override
                public Integer get(AbstractServiceProxy p) {
                    return p.getTargetPort();
                }
            });
        }
        if ("count".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, Integer>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, Integer>(){

                @Override
                public Integer get(AbstractServiceProxy p) {
                    return p.getStatisticCollector().getCount();
                }
            });
        }
        if ("name".equals(propName)) {
            return new PropertyComparator<AbstractServiceProxy, String>(order, new PropertyComparator.ValueResolver<AbstractServiceProxy, String>(){

                @Override
                public String get(AbstractServiceProxy p) {
                    return p.toString();
                }
            });
        }
        throw new IllegalArgumentException("AbstractServiceProxy can't be compared using property [" + propName + "]");
    }

    public static Comparator<ClientStatistics> getClientStatisticsComparator(String propName, String order) {
        if ("name".equals(propName)) {
            return new PropertyComparator<ClientStatistics, String>(order, new PropertyComparator.ValueResolver<ClientStatistics, String>(){

                @Override
                public String get(ClientStatistics c) {
                    return c.getClient();
                }
            });
        }
        if ("count".equals(propName)) {
            return new PropertyComparator<ClientStatistics, Integer>(order, new PropertyComparator.ValueResolver<ClientStatistics, Integer>(){

                @Override
                public Integer get(ClientStatistics c) {
                    return c.getCount();
                }
            });
        }
        if ("min".equals(propName)) {
            return new PropertyComparator<ClientStatistics, Long>(order, new PropertyComparator.ValueResolver<ClientStatistics, Long>(){

                @Override
                public Long get(ClientStatistics c) {
                    return c.getMinDuration();
                }
            });
        }
        if ("max".equals(propName)) {
            return new PropertyComparator<ClientStatistics, Long>(order, new PropertyComparator.ValueResolver<ClientStatistics, Long>(){

                @Override
                public Long get(ClientStatistics c) {
                    return c.getMaxDuration();
                }
            });
        }
        if ("avg".equals(propName)) {
            return new PropertyComparator<ClientStatistics, Long>(order, new PropertyComparator.ValueResolver<ClientStatistics, Long>(){

                @Override
                public Long get(ClientStatistics c) {
                    return c.getAvgDuration();
                }
            });
        }
        throw new IllegalArgumentException("ClientsStatistics can't be compared using property [" + propName + "]");
    }
}

