/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.util.HttpUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorUtil {
    private static Logger log = LoggerFactory.getLogger((String)ErrorUtil.class.getName());
    public static ObjectMapper om = new ObjectMapper();

    public static void createAndSetErrorResponse(Exchange exc, int statusCode, String message) {
        Response.ResponseBuilder builder = Response.ResponseBuilder.newInstance().status(statusCode, HttpUtil.getMessageForStatusCode(statusCode));
        if (ErrorUtil.requestsAcceptsHtmlMimeType(exc)) {
            builder.contentType("text/html;charset=UTF-8").body(HttpUtil.htmlMessage(HttpUtil.getMessageForStatusCode(statusCode), message)).build();
        } else {
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("error", message);
            try {
                builder.contentType("application/json").body(om.writeValueAsBytes(json)).build();
            }
            catch (JsonProcessingException e) {
                log.error("Should never happen!");
            }
        }
        exc.setResponse(builder.build());
    }

    private static boolean requestsAcceptsHtmlMimeType(Exchange exc) {
        return exc.getRequest().getHeader().getAccept() != null && exc.getRequest().getHeader().getAccept().contains("html");
    }
}

