/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.beautifier.HtmlBeautifierFormatter;
import com.predic8.beautifier.PlainBeautifierFormatter;
import com.predic8.beautifier.XMLBeautifier;
import com.predic8.beautifier.XMLBeautifierFormatter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtil {
    private static Logger log = LoggerFactory.getLogger((String)TextUtil.class.getName());
    private static final char[] source = new char[]{'*', '?', '.', '\\', '(', ')', '+', '|', '^', '$', '%', '@'};
    private static final String[] replace = new String[]{".*", ".", "\\.", "\\\\", "\\(", "\\)", "\\+", "\\|", "\\^", "\\$", "\\%", "\\@"};
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public static String formatXML(Reader reader) {
        return TextUtil.formatXML(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXML(Reader reader, boolean asHTML) {
        StringWriter out = new StringWriter();
        try {
            HtmlBeautifierFormatter formatter = asHTML ? new HtmlBeautifierFormatter((Writer)out, 0) : new PlainBeautifierFormatter((Writer)out, 0);
            XMLBeautifier beautifier = new XMLBeautifier((XMLBeautifierFormatter)formatter);
            beautifier.parse(reader);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                out.close();
                reader.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return out.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String globToRegExp(String glob) {
        StringBuilder buf = new StringBuilder();
        buf.append("^");
        for (int i = 0; i < glob.length(); ++i) {
            TextUtil.appendReplacement(glob.charAt(i), buf);
        }
        buf.append("$");
        return buf.toString();
    }

    private static void appendReplacement(char c, StringBuilder buf) {
        for (int j = 0; j < source.length; ++j) {
            if (c != source[j]) continue;
            buf.append(replace[j]);
            return;
        }
        buf.append(c);
    }

    public static String toEnglishList(String conjuction, String ... args) {
        ArrayList<String> l = new ArrayList<String>();
        for (String arg : args) {
            if (arg == null || arg.length() <= 0) continue;
            l.add(arg);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            sb.append((String)l.get(i));
            if (i == l.size() - 2) {
                sb.append(" ");
                sb.append(conjuction);
                sb.append(" ");
            }
            if (i >= l.size() - 2) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Object capitalize(String english) {
        if (english.length() == 0) {
            return "";
        }
        return Character.toString(Character.toUpperCase(english.charAt(0))) + english.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidXMLSnippet(String s) {
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(new StringReader("<a>" + s + "</a>"));
            }
            XMLEvent event = null;
            while (parser.hasNext()) {
                event = (XMLEvent)parser.next();
            }
            return event != null && event.isEndDocument();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public static String linkURL(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            url = StringEscapeUtils.escapeHtml4((String)url);
            return "<a href=\"" + url + "\">" + url + "</a>";
        }
        return StringEscapeUtils.escapeHtml4((String)url);
    }

    public static Object removeFinalChar(String s) {
        StringBuilder sb = new StringBuilder(s);
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String removeCommonLeadingIndentation(String src) {
        Object[] lines = src.split("\n");
        int indent = Integer.MAX_VALUE;
        for (String string : lines) {
            int i;
            if (StringUtils.strip((String)string).length() == 0) continue;
            for (i = 0; i < string.length() && string.charAt(i) == '\t'; ++i) {
            }
            indent = Math.min(indent, i);
        }
        if (indent == 0 || indent == Integer.MAX_VALUE) {
            return src;
        }
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = ((String)lines[i]).length() > indent ? ((String)lines[i]).substring(indent) : "";
        }
        return StringUtils.join((Object[])lines, (char)'\n');
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

