/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.util.URI;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLParamUtil {
    private static final Pattern paramsPat = Pattern.compile("([^=]*)=?(.*)");

    public static Map<String, String> getParams(URIFactory uriFactory, Exchange exc, DuplicateKeyOrInvalidFormStrategy duplicateKeyOrInvalidFormStrategy) throws Exception {
        URI jUri = uriFactory.create(exc.getRequest().getUri());
        String q = jUri.getRawQuery();
        if (q == null) {
            if (URLParamUtil.hasNoFormParams(exc)) {
                return new HashMap<String, String>();
            }
            q = new String(exc.getRequest().getBody().getContent(), exc.getRequest().getCharset());
        }
        return URLParamUtil.parseQueryString(q, duplicateKeyOrInvalidFormStrategy);
    }

    public static String getStringParam(URIFactory uriFactory, Exchange exc, String name) throws Exception {
        return URLParamUtil.getParams(uriFactory, exc, DuplicateKeyOrInvalidFormStrategy.ERROR).get(name);
    }

    public static int getIntParam(URIFactory uriFactory, Exchange exc, String name) throws Exception {
        return Integer.parseInt(URLParamUtil.getParams(uriFactory, exc, DuplicateKeyOrInvalidFormStrategy.ERROR).get(name));
    }

    private static boolean hasNoFormParams(Exchange exc) throws IOException {
        return !"application/x-www-form-urlencoded".equals(exc.getRequest().getHeader().getContentType()) || exc.getRequest().isBodyEmpty();
    }

    public static String createQueryString(String ... params) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < params.length; i += 2) {
            if (i != 0) {
                buf.append('&');
            }
            buf.append(URLEncoder.encode(params[i], StandardCharsets.UTF_8));
            buf.append('=');
            buf.append(URLEncoder.encode(params[i + 1], StandardCharsets.UTF_8));
        }
        return buf.toString();
    }

    public static Map<String, String> parseQueryString(String query, DuplicateKeyOrInvalidFormStrategy duplicateKeyOrInvalidFormStrategy) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String p : query.split("&")) {
            Matcher m = paramsPat.matcher(p);
            if (m.matches()) {
                String key = URLDecoder.decode(m.group(1), StandardCharsets.UTF_8);
                String value = URLDecoder.decode(m.group(2), StandardCharsets.UTF_8);
                String oldValue = (String)params.get(key);
                if (oldValue == null) {
                    params.put(key, value);
                    continue;
                }
                switch (duplicateKeyOrInvalidFormStrategy) {
                    case ERROR: {
                        throw new RuntimeException("Could not parse query: " + query);
                    }
                    case MERGE_USING_COMMA: {
                        params.put(key, oldValue + "," + value);
                    }
                }
                continue;
            }
            if (duplicateKeyOrInvalidFormStrategy != DuplicateKeyOrInvalidFormStrategy.ERROR) continue;
            throw new RuntimeException("Could not parse query: " + query);
        }
        return params;
    }

    public static String encode(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(p.getKey(), StandardCharsets.UTF_8));
            sb.append("=");
            sb.append(URLEncoder.encode(p.getValue(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public static enum DuplicateKeyOrInvalidFormStrategy {
        ERROR,
        MERGE_USING_COMMA;

    }

    public static class ParamBuilder {
        HashMap<String, String> params = new HashMap();

        public ParamBuilder add(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public String build() {
            return URLParamUtil.encode(this.params);
        }
    }
}

