/* Copyright 2021 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/license/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.predic8.membrane.core.config.spring;

import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.interceptor.Interceptor;

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.ArrayList;

/**
  * Automatically generated by {@link com.predic8.membrane.annot.generator.kubernetes.K8sHelperGenerator}
  */
public class K8sHelperGeneratorAutoGenerated {
    public static Map<String, Class<?>> elementMapping = new HashMap<>();
    public static Map<String, Map<String, Class<?>>> localElementMapping = new HashMap<>();
    public static List<String> crdSingularNames = new ArrayList<>();

    private static void localElementMappingPut(String context, String name, Class<?> clazz) {
        Map<String, Class<?>> local = localElementMapping.get(context);
        if (local == null) {
            local = new HashMap<>();
            localElementMapping.put(context, local);
            localElementMapping.put(context.toLowerCase(), local);
        }
        local.put(name, clazz);
        local.put(name.toLowerCase(), clazz);
    }

    public static Class<?> getLocal(String context, String key) {
        Map<String, Class<?>> local = localElementMapping.get(context);
        if (local == null)
            return null;
        return local.get(key);
    }

    static {

        crdSingularNames.add("analyser");
        crdSingularNames.add("statisticsprovider");
        crdSingularNames.add("router");
        crdSingularNames.add("limitedmemoryexchangestore");
        crdSingularNames.add("ntlm");
        crdSingularNames.add("elasticsearchexchangestore");
        crdSingularNames.add("template");
        crdSingularNames.add("statisticscsv");
        crdSingularNames.add("httpclient");
        crdSingularNames.add("stompclient");
        crdSingularNames.add("resolvermap");
        crdSingularNames.add("claims");
        crdSingularNames.add("redisoriginalexchangestore");
        crdSingularNames.add("spdy");
        crdSingularNames.add("rest2soap");
        crdSingularNames.add("private");
        crdSingularNames.add("sslproxy");
        crdSingularNames.add("filestore");
        crdSingularNames.add("jwtauth");
        crdSingularNames.add("xmlprotection");
        crdSingularNames.add("wadlrewriter");
        crdSingularNames.add("if");
        crdSingularNames.add("keygenerator");
        crdSingularNames.add("http2xml");
        crdSingularNames.add("tokenvalidator");
        crdSingularNames.add("staticclientlist");
        crdSingularNames.add("wsinterceptor");
        crdSingularNames.add("clusternotification");
        crdSingularNames.add("httpschemaresolver");
        crdSingularNames.add("exchangestore");
        crdSingularNames.add("throttle");
        crdSingularNames.add("keyfile");
        crdSingularNames.add("prometheus");
        crdSingularNames.add("bean");
        crdSingularNames.add("jwks");
        crdSingularNames.add("accountregistration");
        crdSingularNames.add("userfeature");
        crdSingularNames.add("graphqlprotection");
        crdSingularNames.add("dispatching");
        crdSingularNames.add("clamav");
        crdSingularNames.add("key");
        crdSingularNames.add("accesscontrol");
        crdSingularNames.add("xenauthentication");
        crdSingularNames.add("proxy");
        crdSingularNames.add("groovy");
        crdSingularNames.add("oauth2authserver");
        crdSingularNames.add("soapstacktracefilter");
        crdSingularNames.add("include");
        crdSingularNames.add("logcontext");
        crdSingularNames.add("formvalidation");
        crdSingularNames.add("defaultconfig");
        crdSingularNames.add("statisticsjdbc");
        crdSingularNames.add("return");
        crdSingularNames.add("login");
        crdSingularNames.add("groovytemplate");
        crdSingularNames.add("etcdresolver");
        crdSingularNames.add("urifactory");
        crdSingularNames.add("testservice");
        crdSingularNames.add("stompproxy");
        crdSingularNames.add("xmlsessionidextractor");
        crdSingularNames.add("ratelimiter");
        crdSingularNames.add("jmxexporter");
        crdSingularNames.add("jsonpointerextractor");
        crdSingularNames.add("adminconsole");
        crdSingularNames.add("serviceproxy");
        crdSingularNames.add("authhead2body");
        crdSingularNames.add("methodoverride");
        crdSingularNames.add("trust");
        crdSingularNames.add("membrane");
        crdSingularNames.add("swaggerproxy");
        crdSingularNames.add("rewriter");
        crdSingularNames.add("exclude");
        crdSingularNames.add("staticuserdataprovider");
        crdSingularNames.add("index");
        crdSingularNames.add("wsstompreassembler");
        crdSingularNames.add("forgetfulexchangestore");
        crdSingularNames.add("inmemorystore");
        crdSingularNames.add("gatekeeper");
        crdSingularNames.add("setheader");
        crdSingularNames.add("rulematching");
        crdSingularNames.add("headerjwtretriever");
        crdSingularNames.add("oauth2permissionchecker");
        crdSingularNames.add("jsessionidextractor");
        crdSingularNames.add("swaggerapikeyrequirer");
        crdSingularNames.add("oauth2resource");
        crdSingularNames.add("routeripresolver");
        crdSingularNames.add("interceptor");
        crdSingularNames.add("keystore");
        crdSingularNames.add("api");
        crdSingularNames.add("sessionoriginalexchangestore");
        crdSingularNames.add("websocket");
        crdSingularNames.add("internalproxy");
        crdSingularNames.add("apikeychecker");
        crdSingularNames.add("soapproxy");
        crdSingularNames.add("balancer");
        crdSingularNames.add("registration");
        crdSingularNames.add("cookieoriginalexchangestore");
        crdSingularNames.add("jdbcuserdataprovider");
        crdSingularNames.add("wslog");
        crdSingularNames.add("tcp");
        crdSingularNames.add("webserviceexplorer");
        crdSingularNames.add("etcdregistryapiconfig");
        crdSingularNames.add("fileexchangestore");
        crdSingularNames.add("truststore");
        crdSingularNames.add("acme");
        crdSingularNames.add("ssl");
        crdSingularNames.add("httpclientconfig");
        crdSingularNames.add("oauth2resource2");
        crdSingularNames.add("etcdbasedconfigurator");
        crdSingularNames.add("urlnormalizer");
        crdSingularNames.add("log");
        crdSingularNames.add("jwtsessionmanager");
        crdSingularNames.add("inmemorysessionmanager2");
        crdSingularNames.add("soap2rest");
        crdSingularNames.add("wsdlrewriter");
        crdSingularNames.add("counter");
        crdSingularNames.add("apimanagement");
        crdSingularNames.add("shutdown");
        crdSingularNames.add("faultmonitoringstrategy");
        crdSingularNames.add("xpathextractor");
        crdSingularNames.add("jwtsessionmanager2");
        crdSingularNames.add("redissessionmanager");
        crdSingularNames.add("amquota");
        crdSingularNames.add("transport");
        crdSingularNames.add("xml2json");
        crdSingularNames.add("xmlcontentfilter");
        crdSingularNames.add("nodeonlinechecker");
        crdSingularNames.add("certificate");
        crdSingularNames.add("swaggerrewriter");
        crdSingularNames.add("amratelimiter");
        crdSingularNames.add("memoryexchangestore");
        crdSingularNames.add("basicauthentication");
        crdSingularNames.add("kubernetesvalidation");
        crdSingularNames.add("customstatementjdbcuserdataprovider");
        crdSingularNames.add("transform");
        crdSingularNames.add("bythreadstrategy");
        crdSingularNames.add("simpleapiconfig");
        crdSingularNames.add("headerfilter");
        crdSingularNames.add("amstatisticscollector");
        crdSingularNames.add("roundrobinstrategy");
        crdSingularNames.add("jsonprotection");
        crdSingularNames.add("javascript");
        crdSingularNames.add("acmehttpchallenge");
        crdSingularNames.add("reverseproxying");
        crdSingularNames.add("json2xml");
        crdSingularNames.add("wsdlpublisher");
        crdSingularNames.add("switch");
        crdSingularNames.add("bearertoken");
        crdSingularNames.add("etcdpublisher");
        crdSingularNames.add("webserver");
        crdSingularNames.add("validator");
        crdSingularNames.add("soapoperationextractor");
        crdSingularNames.add("limit");
        crdSingularNames.add("beautifier");
        crdSingularNames.add("cache");
        crdSingularNames.add("regexreplacer");
        crdSingularNames.add("accountblocker");
        crdSingularNames.add("redis");

        elementMapping.put("analyser", com.predic8.membrane.core.interceptor.MessageAnalyser.class);
        elementMapping.put("analyser", com.predic8.membrane.core.interceptor.MessageAnalyser.class);
        elementMapping.put("statisticsProvider", com.predic8.membrane.core.interceptor.statistics.StatisticsProvider.class);
        elementMapping.put("statisticsprovider", com.predic8.membrane.core.interceptor.statistics.StatisticsProvider.class);
        elementMapping.put("router", com.predic8.membrane.core.Router.class);
        elementMapping.put("router", com.predic8.membrane.core.Router.class);
        elementMapping.put("limitedMemoryExchangeStore", com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore.class);
        elementMapping.put("limitedmemoryexchangestore", com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore.class);
        elementMapping.put("ntlm", com.predic8.membrane.core.interceptor.ntlm.NtlmInterceptor.class);
        elementMapping.put("ntlm", com.predic8.membrane.core.interceptor.ntlm.NtlmInterceptor.class);
        elementMapping.put("elasticSearchExchangeStore", com.predic8.membrane.core.exchangestore.ElasticSearchExchangeStore.class);
        elementMapping.put("elasticsearchexchangestore", com.predic8.membrane.core.exchangestore.ElasticSearchExchangeStore.class);
        elementMapping.put("template", com.predic8.membrane.core.interceptor.templating.TemplateInterceptor.class);
        elementMapping.put("template", com.predic8.membrane.core.interceptor.templating.TemplateInterceptor.class);
        elementMapping.put("statisticsCSV", com.predic8.membrane.core.interceptor.statistics.StatisticsCSVInterceptor.class);
        elementMapping.put("statisticscsv", com.predic8.membrane.core.interceptor.statistics.StatisticsCSVInterceptor.class);
        elementMapping.put("httpClient", com.predic8.membrane.core.interceptor.HTTPClientInterceptor.class);
        elementMapping.put("httpclient", com.predic8.membrane.core.interceptor.HTTPClientInterceptor.class);
        elementMapping.put("stompClient", com.predic8.membrane.core.interceptor.stomp.STOMPClient.class);
        elementMapping.put("stompclient", com.predic8.membrane.core.interceptor.stomp.STOMPClient.class);
        elementMapping.put("resolverMap", com.predic8.membrane.core.resolver.ResolverMap.class);
        elementMapping.put("resolvermap", com.predic8.membrane.core.resolver.ResolverMap.class);
        elementMapping.put("claims", com.predic8.membrane.core.interceptor.oauth2.ClaimList.class);
        elementMapping.put("claims", com.predic8.membrane.core.interceptor.oauth2.ClaimList.class);
        elementMapping.put("redisOriginalExchangeStore", com.predic8.membrane.core.interceptor.oauth2client.RedisOriginalExchangeStore.class);
        elementMapping.put("redisoriginalexchangestore", com.predic8.membrane.core.interceptor.oauth2client.RedisOriginalExchangeStore.class);
        elementMapping.put("spdy", com.predic8.membrane.core.interceptor.tunnel.SPDYInterceptor.class);
        elementMapping.put("spdy", com.predic8.membrane.core.interceptor.tunnel.SPDYInterceptor.class);
        elementMapping.put("rest2Soap", com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor.class);
        elementMapping.put("rest2soap", com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor.class);
        elementMapping.put("private", com.predic8.membrane.core.config.security.Key.Private.class);
        elementMapping.put("private", com.predic8.membrane.core.config.security.Key.Private.class);
        elementMapping.put("sslProxy", com.predic8.membrane.core.rules.SSLProxy.class);
        elementMapping.put("sslproxy", com.predic8.membrane.core.rules.SSLProxy.class);
        elementMapping.put("fileStore", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.FileStore.class);
        elementMapping.put("filestore", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.FileStore.class);
        elementMapping.put("jwtAuth", com.predic8.membrane.core.interceptor.jwt.JwtAuthInterceptor.class);
        elementMapping.put("jwtauth", com.predic8.membrane.core.interceptor.jwt.JwtAuthInterceptor.class);
        elementMapping.put("xmlProtection", com.predic8.membrane.core.interceptor.xmlprotection.XMLProtectionInterceptor.class);
        elementMapping.put("xmlprotection", com.predic8.membrane.core.interceptor.xmlprotection.XMLProtectionInterceptor.class);
        elementMapping.put("wadlRewriter", com.predic8.membrane.core.interceptor.WADLInterceptor.class);
        elementMapping.put("wadlrewriter", com.predic8.membrane.core.interceptor.WADLInterceptor.class);
        elementMapping.put("if", com.predic8.membrane.core.interceptor.flow.ConditionalInterceptor.class);
        elementMapping.put("if", com.predic8.membrane.core.interceptor.flow.ConditionalInterceptor.class);
        elementMapping.put("keyGenerator", com.predic8.membrane.core.config.security.KeyGenerator.class);
        elementMapping.put("keygenerator", com.predic8.membrane.core.config.security.KeyGenerator.class);
        elementMapping.put("http2xml", com.predic8.membrane.core.interceptor.rest.HTTP2XMLInterceptor.class);
        elementMapping.put("http2xml", com.predic8.membrane.core.interceptor.rest.HTTP2XMLInterceptor.class);
        elementMapping.put("tokenValidator", com.predic8.membrane.core.interceptor.oauth2.tokenvalidation.OAuth2TokenValidatorInterceptor.class);
        elementMapping.put("tokenvalidator", com.predic8.membrane.core.interceptor.oauth2.tokenvalidation.OAuth2TokenValidatorInterceptor.class);
        elementMapping.put("staticClientList", com.predic8.membrane.core.interceptor.oauth2.StaticClientList.class);
        elementMapping.put("staticclientlist", com.predic8.membrane.core.interceptor.oauth2.StaticClientList.class);
        elementMapping.put("wsInterceptor", com.predic8.membrane.core.transport.ws.interceptors.WebSocketSpringInterceptor.class);
        elementMapping.put("wsinterceptor", com.predic8.membrane.core.transport.ws.interceptors.WebSocketSpringInterceptor.class);
        elementMapping.put("clusterNotification", com.predic8.membrane.core.interceptor.balancer.ClusterNotificationInterceptor.class);
        elementMapping.put("clusternotification", com.predic8.membrane.core.interceptor.balancer.ClusterNotificationInterceptor.class);
        elementMapping.put("httpSchemaResolver", com.predic8.membrane.core.resolver.HTTPSchemaResolver.class);
        elementMapping.put("httpschemaresolver", com.predic8.membrane.core.resolver.HTTPSchemaResolver.class);
        elementMapping.put("exchangeStore", com.predic8.membrane.core.interceptor.ExchangeStoreInterceptor.class);
        elementMapping.put("exchangestore", com.predic8.membrane.core.interceptor.ExchangeStoreInterceptor.class);
        elementMapping.put("throttle", com.predic8.membrane.core.interceptor.ThrottleInterceptor.class);
        elementMapping.put("throttle", com.predic8.membrane.core.interceptor.ThrottleInterceptor.class);
        elementMapping.put("keyFile", com.predic8.membrane.core.interceptor.swagger.KeyFileApiKeyValidator.class);
        elementMapping.put("keyfile", com.predic8.membrane.core.interceptor.swagger.KeyFileApiKeyValidator.class);
        elementMapping.put("prometheus", com.predic8.membrane.core.interceptor.prometheus.PrometheusInterceptor.class);
        elementMapping.put("prometheus", com.predic8.membrane.core.interceptor.prometheus.PrometheusInterceptor.class);
        elementMapping.put("bean", com.predic8.membrane.core.kubernetes.Bean.class);
        elementMapping.put("bean", com.predic8.membrane.core.kubernetes.Bean.class);
        elementMapping.put("jwks", com.predic8.membrane.core.interceptor.jwt.Jwks.class);
        elementMapping.put("jwks", com.predic8.membrane.core.interceptor.jwt.Jwks.class);
        elementMapping.put("accountRegistration", com.predic8.membrane.core.interceptor.registration.RegistrationInterceptor.class);
        elementMapping.put("accountregistration", com.predic8.membrane.core.interceptor.registration.RegistrationInterceptor.class);
        elementMapping.put("userFeature", com.predic8.membrane.core.interceptor.UserFeatureInterceptor.class);
        elementMapping.put("userfeature", com.predic8.membrane.core.interceptor.UserFeatureInterceptor.class);
        elementMapping.put("graphQLProtection", com.predic8.membrane.core.graphql.GraphQLProtectionInterceptor.class);
        elementMapping.put("graphqlprotection", com.predic8.membrane.core.graphql.GraphQLProtectionInterceptor.class);
        elementMapping.put("dispatching", com.predic8.membrane.core.interceptor.DispatchingInterceptor.class);
        elementMapping.put("dispatching", com.predic8.membrane.core.interceptor.DispatchingInterceptor.class);
        elementMapping.put("clamav", com.predic8.membrane.core.interceptor.antivirus.ClamAntiVirusInterceptor.class);
        elementMapping.put("clamav", com.predic8.membrane.core.interceptor.antivirus.ClamAntiVirusInterceptor.class);
        elementMapping.put("key", com.predic8.membrane.core.config.security.Key.class);
        elementMapping.put("key", com.predic8.membrane.core.config.security.Key.class);
        elementMapping.put("accessControl", com.predic8.membrane.core.interceptor.acl.AccessControlInterceptor.class);
        elementMapping.put("accesscontrol", com.predic8.membrane.core.interceptor.acl.AccessControlInterceptor.class);
        elementMapping.put("xenAuthentication", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.class);
        elementMapping.put("xenauthentication", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.class);
        elementMapping.put("proxy", com.predic8.membrane.core.rules.ProxyRule.class);
        elementMapping.put("proxy", com.predic8.membrane.core.rules.ProxyRule.class);
        elementMapping.put("groovy", com.predic8.membrane.core.interceptor.groovy.GroovyInterceptor.class);
        elementMapping.put("groovy", com.predic8.membrane.core.interceptor.groovy.GroovyInterceptor.class);
        elementMapping.put("oauth2authserver", com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor.class);
        elementMapping.put("oauth2authserver", com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor.class);
        elementMapping.put("soapStackTraceFilter", com.predic8.membrane.core.interceptor.xmlcontentfilter.SOAPStackTraceFilterInterceptor.class);
        elementMapping.put("soapstacktracefilter", com.predic8.membrane.core.interceptor.xmlcontentfilter.SOAPStackTraceFilterInterceptor.class);
        elementMapping.put("include", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.Include.class);
        elementMapping.put("include", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.Include.class);
        elementMapping.put("logContext", com.predic8.membrane.core.interceptor.LoggingContextInterceptor.class);
        elementMapping.put("logcontext", com.predic8.membrane.core.interceptor.LoggingContextInterceptor.class);
        elementMapping.put("formValidation", com.predic8.membrane.core.interceptor.formvalidation.FormValidationInterceptor.class);
        elementMapping.put("formvalidation", com.predic8.membrane.core.interceptor.formvalidation.FormValidationInterceptor.class);
        elementMapping.put("defaultConfig", com.predic8.membrane.core.DefaultConfig.class);
        elementMapping.put("defaultconfig", com.predic8.membrane.core.DefaultConfig.class);
        elementMapping.put("statisticsJDBC", com.predic8.membrane.core.interceptor.statistics.StatisticsJDBCInterceptor.class);
        elementMapping.put("statisticsjdbc", com.predic8.membrane.core.interceptor.statistics.StatisticsJDBCInterceptor.class);
        elementMapping.put("return", com.predic8.membrane.core.interceptor.misc.ReturnInterceptor.class);
        elementMapping.put("return", com.predic8.membrane.core.interceptor.misc.ReturnInterceptor.class);
        elementMapping.put("login", com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor.class);
        elementMapping.put("login", com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor.class);
        elementMapping.put("groovyTemplate", com.predic8.membrane.core.interceptor.groovy.GroovyTemplateInterceptor.class);
        elementMapping.put("groovytemplate", com.predic8.membrane.core.interceptor.groovy.GroovyTemplateInterceptor.class);
        elementMapping.put("etcdResolver", com.predic8.membrane.core.cloud.etcd.EtcdResolver.class);
        elementMapping.put("etcdresolver", com.predic8.membrane.core.cloud.etcd.EtcdResolver.class);
        elementMapping.put("uriFactory", com.predic8.membrane.core.util.URIFactory.class);
        elementMapping.put("urifactory", com.predic8.membrane.core.util.URIFactory.class);
        elementMapping.put("testService", com.predic8.membrane.core.interceptor.testservice.TestServiceInterceptor.class);
        elementMapping.put("testservice", com.predic8.membrane.core.interceptor.testservice.TestServiceInterceptor.class);
        elementMapping.put("stompProxy", com.predic8.membrane.core.rules.STOMPProxy.class);
        elementMapping.put("stompproxy", com.predic8.membrane.core.rules.STOMPProxy.class);
        elementMapping.put("xmlSessionIdExtractor", com.predic8.membrane.core.interceptor.balancer.XMLElementSessionIdExtractor.class);
        elementMapping.put("xmlsessionidextractor", com.predic8.membrane.core.interceptor.balancer.XMLElementSessionIdExtractor.class);
        elementMapping.put("rateLimiter", com.predic8.membrane.core.interceptor.ratelimit.RateLimitInterceptor.class);
        elementMapping.put("ratelimiter", com.predic8.membrane.core.interceptor.ratelimit.RateLimitInterceptor.class);
        elementMapping.put("jmxExporter", com.predic8.membrane.core.jmx.JmxExporter.class);
        elementMapping.put("jmxexporter", com.predic8.membrane.core.jmx.JmxExporter.class);
        elementMapping.put("jsonPointerExtractor", com.predic8.membrane.core.interceptor.json.JsonPointerExtractorInterceptor.class);
        elementMapping.put("jsonpointerextractor", com.predic8.membrane.core.interceptor.json.JsonPointerExtractorInterceptor.class);
        elementMapping.put("adminConsole", com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor.class);
        elementMapping.put("adminconsole", com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor.class);
        elementMapping.put("serviceProxy", com.predic8.membrane.core.rules.ServiceProxy.class);
        elementMapping.put("serviceproxy", com.predic8.membrane.core.rules.ServiceProxy.class);
        elementMapping.put("authHead2Body", com.predic8.membrane.core.interceptor.AuthHead2BodyInterceptor.class);
        elementMapping.put("authhead2body", com.predic8.membrane.core.interceptor.AuthHead2BodyInterceptor.class);
        elementMapping.put("methodOverride", com.predic8.membrane.core.interceptor.MethodOverrideInterceptor.class);
        elementMapping.put("methodoverride", com.predic8.membrane.core.interceptor.MethodOverrideInterceptor.class);
        elementMapping.put("trust", com.predic8.membrane.core.config.security.Trust.class);
        elementMapping.put("trust", com.predic8.membrane.core.config.security.Trust.class);
        elementMapping.put("membrane", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.MembraneAuthorizationService.class);
        elementMapping.put("membrane", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.MembraneAuthorizationService.class);
        elementMapping.put("swaggerProxy", com.predic8.membrane.core.rules.SwaggerProxy.class);
        elementMapping.put("swaggerproxy", com.predic8.membrane.core.rules.SwaggerProxy.class);
        elementMapping.put("rewriter", com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor.class);
        elementMapping.put("rewriter", com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor.class);
        elementMapping.put("exclude", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.Exclude.class);
        elementMapping.put("exclude", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.Exclude.class);
        elementMapping.put("staticUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider.class);
        elementMapping.put("staticuserdataprovider", com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider.class);
        elementMapping.put("index", com.predic8.membrane.core.interceptor.IndexInterceptor.class);
        elementMapping.put("index", com.predic8.membrane.core.interceptor.IndexInterceptor.class);
        elementMapping.put("wsStompReassembler", com.predic8.membrane.core.transport.ws.interceptors.WebSocketStompReassembler.class);
        elementMapping.put("wsstompreassembler", com.predic8.membrane.core.transport.ws.interceptors.WebSocketStompReassembler.class);
        elementMapping.put("forgetfulExchangeStore", com.predic8.membrane.core.exchangestore.ForgetfulExchangeStore.class);
        elementMapping.put("forgetfulexchangestore", com.predic8.membrane.core.exchangestore.ForgetfulExchangeStore.class);
        elementMapping.put("inMemoryStore", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.InMemoryStore.class);
        elementMapping.put("inmemorystore", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.InMemoryStore.class);
        elementMapping.put("gatekeeper", com.predic8.membrane.core.interceptor.gatekeeper.GateKeeperClientInterceptor.class);
        elementMapping.put("gatekeeper", com.predic8.membrane.core.interceptor.gatekeeper.GateKeeperClientInterceptor.class);
        elementMapping.put("setHeader", com.predic8.membrane.core.interceptor.misc.SetHeaderInterceptor.class);
        elementMapping.put("setheader", com.predic8.membrane.core.interceptor.misc.SetHeaderInterceptor.class);
        elementMapping.put("ruleMatching", com.predic8.membrane.core.interceptor.RuleMatchingInterceptor.class);
        elementMapping.put("rulematching", com.predic8.membrane.core.interceptor.RuleMatchingInterceptor.class);
        elementMapping.put("headerJwtRetriever", com.predic8.membrane.core.interceptor.jwt.HeaderJwtRetriever.class);
        elementMapping.put("headerjwtretriever", com.predic8.membrane.core.interceptor.jwt.HeaderJwtRetriever.class);
        elementMapping.put("oauth2PermissionChecker", com.predic8.membrane.core.interceptor.oauth2client.OAuth2PermissionCheckerInterceptor.class);
        elementMapping.put("oauth2permissionchecker", com.predic8.membrane.core.interceptor.oauth2client.OAuth2PermissionCheckerInterceptor.class);
        elementMapping.put("jSessionIdExtractor", com.predic8.membrane.core.interceptor.balancer.JSESSIONIDExtractor.class);
        elementMapping.put("jsessionidextractor", com.predic8.membrane.core.interceptor.balancer.JSESSIONIDExtractor.class);
        elementMapping.put("swaggerApiKeyRequirer", com.predic8.membrane.core.interceptor.swagger.SwaggerApiKeyRequirer.class);
        elementMapping.put("swaggerapikeyrequirer", com.predic8.membrane.core.interceptor.swagger.SwaggerApiKeyRequirer.class);
        elementMapping.put("oauth2Resource", com.predic8.membrane.core.interceptor.oauth2.OAuth2ResourceInterceptor.class);
        elementMapping.put("oauth2resource", com.predic8.membrane.core.interceptor.oauth2.OAuth2ResourceInterceptor.class);
        elementMapping.put("routerIpResolver", com.predic8.membrane.core.interceptor.gatekeeper.RouterIpResolverInterceptor.class);
        elementMapping.put("routeripresolver", com.predic8.membrane.core.interceptor.gatekeeper.RouterIpResolverInterceptor.class);
        elementMapping.put("interceptor", com.predic8.membrane.core.interceptor.SpringInterceptor.class);
        elementMapping.put("interceptor", com.predic8.membrane.core.interceptor.SpringInterceptor.class);
        elementMapping.put("keystore", com.predic8.membrane.core.config.security.KeyStore.class);
        elementMapping.put("keystore", com.predic8.membrane.core.config.security.KeyStore.class);
        elementMapping.put("api", com.predic8.membrane.core.openapi.serviceproxy.APIProxy.class);
        elementMapping.put("api", com.predic8.membrane.core.openapi.serviceproxy.APIProxy.class);
        elementMapping.put("sessionOriginalExchangeStore", com.predic8.membrane.core.interceptor.oauth2client.SessionOriginalExchangeStore.class);
        elementMapping.put("sessionoriginalexchangestore", com.predic8.membrane.core.interceptor.oauth2client.SessionOriginalExchangeStore.class);
        elementMapping.put("webSocket", com.predic8.membrane.core.interceptor.tunnel.WebSocketInterceptor.class);
        elementMapping.put("websocket", com.predic8.membrane.core.interceptor.tunnel.WebSocketInterceptor.class);
        elementMapping.put("internalProxy", com.predic8.membrane.core.rules.InternalProxy.class);
        elementMapping.put("internalproxy", com.predic8.membrane.core.rules.InternalProxy.class);
        elementMapping.put("apiKeyChecker", com.predic8.membrane.core.interceptor.swagger.ApiKeyCheckerInterceptor.class);
        elementMapping.put("apikeychecker", com.predic8.membrane.core.interceptor.swagger.ApiKeyCheckerInterceptor.class);
        elementMapping.put("soapProxy", com.predic8.membrane.core.rules.SOAPProxy.class);
        elementMapping.put("soapproxy", com.predic8.membrane.core.rules.SOAPProxy.class);
        elementMapping.put("balancer", com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor.class);
        elementMapping.put("balancer", com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor.class);
        elementMapping.put("registration", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration.class);
        elementMapping.put("registration", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration.class);
        elementMapping.put("cookieOriginalExchangeStore", com.predic8.membrane.core.interceptor.oauth2client.CookieOriginialExchangeStore.class);
        elementMapping.put("cookieoriginalexchangestore", com.predic8.membrane.core.interceptor.oauth2client.CookieOriginialExchangeStore.class);
        elementMapping.put("jdbcUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.JdbcUserDataProvider.class);
        elementMapping.put("jdbcuserdataprovider", com.predic8.membrane.core.interceptor.authentication.session.JdbcUserDataProvider.class);
        elementMapping.put("wsLog", com.predic8.membrane.core.transport.ws.interceptors.WebSocketLogInterceptor.class);
        elementMapping.put("wslog", com.predic8.membrane.core.transport.ws.interceptors.WebSocketLogInterceptor.class);
        elementMapping.put("tcp", com.predic8.membrane.core.interceptor.tunnel.TCPInterceptor.class);
        elementMapping.put("tcp", com.predic8.membrane.core.interceptor.tunnel.TCPInterceptor.class);
        elementMapping.put("webServiceExplorer", com.predic8.membrane.core.interceptor.soap.WebServiceExplorerInterceptor.class);
        elementMapping.put("webserviceexplorer", com.predic8.membrane.core.interceptor.soap.WebServiceExplorerInterceptor.class);
        elementMapping.put("etcdRegistryApiConfig", com.predic8.membrane.core.interceptor.apimanagement.apiconfig.EtcdRegistryApiConfig.class);
        elementMapping.put("etcdregistryapiconfig", com.predic8.membrane.core.interceptor.apimanagement.apiconfig.EtcdRegistryApiConfig.class);
        elementMapping.put("fileExchangeStore", com.predic8.membrane.core.exchangestore.FileExchangeStore.class);
        elementMapping.put("fileexchangestore", com.predic8.membrane.core.exchangestore.FileExchangeStore.class);
        elementMapping.put("truststore", com.predic8.membrane.core.config.security.TrustStore.class);
        elementMapping.put("truststore", com.predic8.membrane.core.config.security.TrustStore.class);
        elementMapping.put("acme", com.predic8.membrane.core.config.security.acme.Acme.class);
        elementMapping.put("acme", com.predic8.membrane.core.config.security.acme.Acme.class);
        elementMapping.put("ssl", com.predic8.membrane.core.config.security.SSLParser.class);
        elementMapping.put("ssl", com.predic8.membrane.core.config.security.SSLParser.class);
        elementMapping.put("httpClientConfig", com.predic8.membrane.core.transport.http.client.HttpClientConfiguration.class);
        elementMapping.put("httpclientconfig", com.predic8.membrane.core.transport.http.client.HttpClientConfiguration.class);
        elementMapping.put("oauth2Resource2", com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor.class);
        elementMapping.put("oauth2resource2", com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor.class);
        elementMapping.put("etcdBasedConfigurator", com.predic8.membrane.core.cloud.etcd.EtcdBasedConfigurator.class);
        elementMapping.put("etcdbasedconfigurator", com.predic8.membrane.core.cloud.etcd.EtcdBasedConfigurator.class);
        elementMapping.put("urlNormalizer", com.predic8.membrane.core.interceptor.URLNormalizerInterceptor.class);
        elementMapping.put("urlnormalizer", com.predic8.membrane.core.interceptor.URLNormalizerInterceptor.class);
        elementMapping.put("log", com.predic8.membrane.core.interceptor.LogInterceptor.class);
        elementMapping.put("log", com.predic8.membrane.core.interceptor.LogInterceptor.class);
        elementMapping.put("jwtSessionManager", com.predic8.membrane.core.interceptor.session.JwtSessionManager.class);
        elementMapping.put("jwtsessionmanager", com.predic8.membrane.core.interceptor.session.JwtSessionManager.class);
        elementMapping.put("inMemorySessionManager2", com.predic8.membrane.core.interceptor.session.InMemorySessionManager.class);
        elementMapping.put("inmemorysessionmanager2", com.predic8.membrane.core.interceptor.session.InMemorySessionManager.class);
        elementMapping.put("soap2Rest", com.predic8.membrane.core.interceptor.rest.SOAP2RESTInterceptor.class);
        elementMapping.put("soap2rest", com.predic8.membrane.core.interceptor.rest.SOAP2RESTInterceptor.class);
        elementMapping.put("wsdlRewriter", com.predic8.membrane.core.interceptor.WSDLInterceptor.class);
        elementMapping.put("wsdlrewriter", com.predic8.membrane.core.interceptor.WSDLInterceptor.class);
        elementMapping.put("counter", com.predic8.membrane.core.interceptor.CountInterceptor.class);
        elementMapping.put("counter", com.predic8.membrane.core.interceptor.CountInterceptor.class);
        elementMapping.put("apiManagement", com.predic8.membrane.core.interceptor.apimanagement.ApiManagementInterceptor.class);
        elementMapping.put("apimanagement", com.predic8.membrane.core.interceptor.apimanagement.ApiManagementInterceptor.class);
        elementMapping.put("shutdown", com.predic8.membrane.core.interceptor.shutdown.ShutdownInterceptor.class);
        elementMapping.put("shutdown", com.predic8.membrane.core.interceptor.shutdown.ShutdownInterceptor.class);
        elementMapping.put("faultMonitoringStrategy", com.predic8.membrane.core.interceptor.balancer.faultmonitoring.FaultMonitoringStrategy.class);
        elementMapping.put("faultmonitoringstrategy", com.predic8.membrane.core.interceptor.balancer.faultmonitoring.FaultMonitoringStrategy.class);
        elementMapping.put("xpathExtractor", com.predic8.membrane.core.interceptor.xml.XmlPathExtractorInterceptor.class);
        elementMapping.put("xpathextractor", com.predic8.membrane.core.interceptor.xml.XmlPathExtractorInterceptor.class);
        elementMapping.put("jwtSessionManager2", com.predic8.membrane.core.interceptor.authentication.session.JwtSessionManager.class);
        elementMapping.put("jwtsessionmanager2", com.predic8.membrane.core.interceptor.authentication.session.JwtSessionManager.class);
        elementMapping.put("redisSessionManager", com.predic8.membrane.core.interceptor.session.RedisSessionManager.class);
        elementMapping.put("redissessionmanager", com.predic8.membrane.core.interceptor.session.RedisSessionManager.class);
        elementMapping.put("amQuota", com.predic8.membrane.core.interceptor.apimanagement.quota.AMQuota.class);
        elementMapping.put("amquota", com.predic8.membrane.core.interceptor.apimanagement.quota.AMQuota.class);
        elementMapping.put("transport", com.predic8.membrane.core.transport.http.HttpTransport.class);
        elementMapping.put("transport", com.predic8.membrane.core.transport.http.HttpTransport.class);
        elementMapping.put("xml2Json", com.predic8.membrane.core.interceptor.xml.Xml2JsonInterceptor.class);
        elementMapping.put("xml2json", com.predic8.membrane.core.interceptor.xml.Xml2JsonInterceptor.class);
        elementMapping.put("xmlContentFilter", com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilterInterceptor.class);
        elementMapping.put("xmlcontentfilter", com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilterInterceptor.class);
        elementMapping.put("nodeOnlineChecker", com.predic8.membrane.core.interceptor.balancer.NodeOnlineChecker.class);
        elementMapping.put("nodeonlinechecker", com.predic8.membrane.core.interceptor.balancer.NodeOnlineChecker.class);
        elementMapping.put("certificate", com.predic8.membrane.core.config.security.Certificate.class);
        elementMapping.put("certificate", com.predic8.membrane.core.config.security.Certificate.class);
        elementMapping.put("swaggerRewriter", com.predic8.membrane.core.interceptor.swagger.SwaggerRewriterInterceptor.class);
        elementMapping.put("swaggerrewriter", com.predic8.membrane.core.interceptor.swagger.SwaggerRewriterInterceptor.class);
        elementMapping.put("amRateLimiter", com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.AMRateLimiter.class);
        elementMapping.put("amratelimiter", com.predic8.membrane.core.interceptor.apimanagement.rateLimiter.AMRateLimiter.class);
        elementMapping.put("memoryExchangeStore", com.predic8.membrane.core.exchangestore.MemoryExchangeStore.class);
        elementMapping.put("memoryexchangestore", com.predic8.membrane.core.exchangestore.MemoryExchangeStore.class);
        elementMapping.put("basicAuthentication", com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor.class);
        elementMapping.put("basicauthentication", com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor.class);
        elementMapping.put("kubernetesValidation", com.predic8.membrane.core.interceptor.kubernetes.KubernetesValidationInterceptor.class);
        elementMapping.put("kubernetesvalidation", com.predic8.membrane.core.interceptor.kubernetes.KubernetesValidationInterceptor.class);
        elementMapping.put("customStatementJdbcUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CustomStatementJdbcUserDataProvider.class);
        elementMapping.put("customstatementjdbcuserdataprovider", com.predic8.membrane.core.interceptor.authentication.session.CustomStatementJdbcUserDataProvider.class);
        elementMapping.put("transform", com.predic8.membrane.core.interceptor.xslt.XSLTInterceptor.class);
        elementMapping.put("transform", com.predic8.membrane.core.interceptor.xslt.XSLTInterceptor.class);
        elementMapping.put("byThreadStrategy", com.predic8.membrane.core.interceptor.balancer.ByThreadStrategy.class);
        elementMapping.put("bythreadstrategy", com.predic8.membrane.core.interceptor.balancer.ByThreadStrategy.class);
        elementMapping.put("simpleApiConfig", com.predic8.membrane.core.interceptor.apimanagement.apiconfig.SimpleApiConfig.class);
        elementMapping.put("simpleapiconfig", com.predic8.membrane.core.interceptor.apimanagement.apiconfig.SimpleApiConfig.class);
        elementMapping.put("headerFilter", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.class);
        elementMapping.put("headerfilter", com.predic8.membrane.core.interceptor.HeaderFilterInterceptor.class);
        elementMapping.put("amStatisticsCollector", com.predic8.membrane.core.interceptor.apimanagement.statistics.AMStatisticsCollector.class);
        elementMapping.put("amstatisticscollector", com.predic8.membrane.core.interceptor.apimanagement.statistics.AMStatisticsCollector.class);
        elementMapping.put("roundRobinStrategy", com.predic8.membrane.core.interceptor.balancer.RoundRobinStrategy.class);
        elementMapping.put("roundrobinstrategy", com.predic8.membrane.core.interceptor.balancer.RoundRobinStrategy.class);
        elementMapping.put("jsonProtection", com.predic8.membrane.core.interceptor.json.JsonProtectionInterceptor.class);
        elementMapping.put("jsonprotection", com.predic8.membrane.core.interceptor.json.JsonProtectionInterceptor.class);
        elementMapping.put("javascript", com.predic8.membrane.core.interceptor.javascript.JavascriptInterceptor.class);
        elementMapping.put("javascript", com.predic8.membrane.core.interceptor.javascript.JavascriptInterceptor.class);
        elementMapping.put("acmeHttpChallenge", com.predic8.membrane.core.interceptor.AcmeHttpChallengeInterceptor.class);
        elementMapping.put("acmehttpchallenge", com.predic8.membrane.core.interceptor.AcmeHttpChallengeInterceptor.class);
        elementMapping.put("reverseProxying", com.predic8.membrane.core.interceptor.rewrite.ReverseProxyingInterceptor.class);
        elementMapping.put("reverseproxying", com.predic8.membrane.core.interceptor.rewrite.ReverseProxyingInterceptor.class);
        elementMapping.put("json2Xml", com.predic8.membrane.core.interceptor.xml.Json2XmlInterceptor.class);
        elementMapping.put("json2xml", com.predic8.membrane.core.interceptor.xml.Json2XmlInterceptor.class);
        elementMapping.put("wsdlPublisher", com.predic8.membrane.core.interceptor.server.WSDLPublisherInterceptor.class);
        elementMapping.put("wsdlpublisher", com.predic8.membrane.core.interceptor.server.WSDLPublisherInterceptor.class);
        elementMapping.put("switch", com.predic8.membrane.core.interceptor.cbr.XPathCBRInterceptor.class);
        elementMapping.put("switch", com.predic8.membrane.core.interceptor.cbr.XPathCBRInterceptor.class);
        elementMapping.put("bearerToken", com.predic8.membrane.core.interceptor.oauth2.tokengenerators.BearerTokenGenerator.class);
        elementMapping.put("bearertoken", com.predic8.membrane.core.interceptor.oauth2.tokengenerators.BearerTokenGenerator.class);
        elementMapping.put("etcdPublisher", com.predic8.membrane.core.cloud.etcd.EtcdPublisher.class);
        elementMapping.put("etcdpublisher", com.predic8.membrane.core.cloud.etcd.EtcdPublisher.class);
        elementMapping.put("webServer", com.predic8.membrane.core.interceptor.server.WebServerInterceptor.class);
        elementMapping.put("webserver", com.predic8.membrane.core.interceptor.server.WebServerInterceptor.class);
        elementMapping.put("validator", com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor.class);
        elementMapping.put("validator", com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor.class);
        elementMapping.put("soapOperationExtractor", com.predic8.membrane.core.interceptor.soap.SoapOperationExtractor.class);
        elementMapping.put("soapoperationextractor", com.predic8.membrane.core.interceptor.soap.SoapOperationExtractor.class);
        elementMapping.put("limit", com.predic8.membrane.core.interceptor.LimitInterceptor.class);
        elementMapping.put("limit", com.predic8.membrane.core.interceptor.LimitInterceptor.class);
        elementMapping.put("beautifier", com.predic8.membrane.core.interceptor.beautifier.BeautifierInterceptor.class);
        elementMapping.put("beautifier", com.predic8.membrane.core.interceptor.beautifier.BeautifierInterceptor.class);
        elementMapping.put("cache", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.class);
        elementMapping.put("cache", com.predic8.membrane.core.interceptor.cache.CacheInterceptor.class);
        elementMapping.put("regExReplacer", com.predic8.membrane.core.interceptor.RegExReplaceInterceptor.class);
        elementMapping.put("regexreplacer", com.predic8.membrane.core.interceptor.RegExReplaceInterceptor.class);
        elementMapping.put("accountBlocker", com.predic8.membrane.core.interceptor.authentication.session.AccountBlocker.class);
        elementMapping.put("accountblocker", com.predic8.membrane.core.interceptor.authentication.session.AccountBlocker.class);
        elementMapping.put("redis", com.predic8.membrane.core.util.RedisConnector.class);
        elementMapping.put("redis", com.predic8.membrane.core.util.RedisConnector.class);
        localElementMappingPut("clusters", "cluster", com.predic8.membrane.core.interceptor.balancer.Cluster.class);
        localElementMappingPut("ntlm", "headerRetriever", com.predic8.membrane.core.interceptor.ntlm.HeaderNTLMRetriever.class);
        localElementMappingPut("stompClient", "connection", com.predic8.membrane.core.transport.http.client.ConnectionConfiguration.class);
        localElementMappingPut("claims", "scope", com.predic8.membrane.core.interceptor.oauth2.ClaimList.Scope.class);
        localElementMappingPut("request", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("request", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("rest2Soap", "mapping", com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor.Mapping.class);
        localElementMappingPut("sslProxy", "connection", com.predic8.membrane.core.transport.http.client.ConnectionConfiguration.class);
        localElementMappingPut("sslProxy", "gatekeeper", com.predic8.membrane.core.sslinterceptor.GateKeeperClientInterceptor.class);
        localElementMappingPut("sslProxy", "routerIpResolver", com.predic8.membrane.core.sslinterceptor.RouterIpResolverInterceptor.class);
        localElementMappingPut("sslProxy", "target", com.predic8.membrane.core.rules.SSLProxy.Target.class);
        localElementMappingPut("if", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("if", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("staticClientList", "client", com.predic8.membrane.core.interceptor.oauth2.Client.class);
        localElementMappingPut("bean", "clusters", com.predic8.membrane.core.interceptor.balancer.Balancer.class);
        localElementMappingPut("bean", "github", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GithubAuthorizationService.class);
        localElementMappingPut("bean", "headerRetriever", com.predic8.membrane.core.interceptor.ntlm.HeaderNTLMRetriever.class);
        localElementMappingPut("bean", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("bean", "header", com.predic8.membrane.core.interceptor.swagger.HeaderApiKeyTransmissionStrategy.class);
        localElementMappingPut("bean", "case", com.predic8.membrane.core.interceptor.cbr.Case.class);
        localElementMappingPut("bean", "gatekeeper", com.predic8.membrane.core.sslinterceptor.GateKeeperClientInterceptor.class);
        localElementMappingPut("bean", "google", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GoogleAuthorizationService.class);
        localElementMappingPut("bean", "attribute", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.AttributeMap.Attribute.class);
        localElementMappingPut("bean", "client", com.predic8.membrane.core.interceptor.oauth2.Client.class);
        localElementMappingPut("bean", "user", com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider.User.class);
        localElementMappingPut("bean", "connection", com.predic8.membrane.core.transport.http.client.ConnectionConfiguration.class);
        localElementMappingPut("bean", "routerIpResolver", com.predic8.membrane.core.sslinterceptor.RouterIpResolverInterceptor.class);
        localElementMappingPut("bean", "jwk", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.JwtSessionManager.Jwk.class);
        localElementMappingPut("bean", "jwk", com.predic8.membrane.core.interceptor.session.JwtSessionManager.Jwk.class);
        localElementMappingPut("bean", "target", com.predic8.membrane.core.rules.AbstractServiceProxy.Target.class);
        localElementMappingPut("bean", "scope", com.predic8.membrane.core.interceptor.oauth2.ClaimList.Scope.class);
        localElementMappingPut("bean", "userInfo", com.predic8.membrane.core.interceptor.oauth2client.OAuth2PermissionCheckerInterceptor.UserInfoValueSource.class);
        localElementMappingPut("bean", "openapi", com.predic8.membrane.core.openapi.serviceproxy.APIProxy.Spec.class);
        localElementMappingPut("bean", "totpTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.TOTPTokenProvider.class);
        localElementMappingPut("bean", "claim", com.predic8.membrane.core.interceptor.oauth2server.Claim.class);
        localElementMappingPut("bean", "sessionManager", com.predic8.membrane.core.interceptor.authentication.session.SessionManager.class);
        localElementMappingPut("bean", "emailTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.EmailTokenProvider.class);
        localElementMappingPut("bean", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("bean", "target", com.predic8.membrane.core.rules.SSLProxy.Target.class);
        localElementMappingPut("bean", "path", com.predic8.membrane.core.config.Path.class);
        localElementMappingPut("bean", "emptyTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.EmptyTokenProvider.class);
        localElementMappingPut("bean", "map", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.AttributeMap.class);
        localElementMappingPut("bean", "map", com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor.Mapping.class);
        localElementMappingPut("bean", "whateverMobileSMSTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.WhateverMobileSMSTokenProvider.class);
        localElementMappingPut("bean", "node", com.predic8.membrane.core.interceptor.balancer.Node.class);
        localElementMappingPut("bean", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("bean", "jwtSessionManager", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.JwtSessionManager.class);
        localElementMappingPut("bean", "jwk", com.predic8.membrane.core.interceptor.jwt.Jwks.Jwk.class);
        localElementMappingPut("bean", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("bean", "property", com.predic8.membrane.core.interceptor.xml.XmlPathExtractorInterceptor.Property.class);
        localElementMappingPut("bean", "field", com.predic8.membrane.core.interceptor.formvalidation.FormValidationInterceptor.Field.class);
        localElementMappingPut("bean", "kubernetesStorage", com.predic8.membrane.core.config.security.acme.KubernetesStorage.class);
        localElementMappingPut("bean", "telekomSMSTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.TelekomSMSTokenProvider.class);
        localElementMappingPut("bean", "dnsOperator", com.predic8.membrane.core.config.security.acme.DnsOperatorAcmeValidation.class);
        localElementMappingPut("bean", "authentication", com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration.class);
        localElementMappingPut("bean", "cluster", com.predic8.membrane.core.interceptor.balancer.Cluster.class);
        localElementMappingPut("bean", "proxy", com.predic8.membrane.core.transport.http.client.ProxyConfiguration.class);
        localElementMappingPut("bean", "fileStorage", com.predic8.membrane.core.config.security.acme.FileStorage.class);
        localElementMappingPut("bean", "property", com.predic8.membrane.core.interceptor.json.JsonPointerExtractorInterceptor.Property.class);
        localElementMappingPut("bean", "mapping", com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor.Mapping.class);
        localElementMappingPut("bean", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("bean", "inMemorySessionManager", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.InMemorySessionManager.class);
        localElementMappingPut("bean", "memoryStorage", com.predic8.membrane.core.config.security.acme.MemoryStorage.class);
        localElementMappingPut("jwks", "jwk", com.predic8.membrane.core.interceptor.jwt.Jwks.Jwk.class);
        localElementMappingPut("xenAuthentication", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("xenAuthentication", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("xenAuthentication", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("xenAuthentication", "jwtSessionManager", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.JwtSessionManager.class);
        localElementMappingPut("xenAuthentication", "inMemorySessionManager", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.InMemorySessionManager.class);
        localElementMappingPut("proxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("proxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("oauth2authserver", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("oauth2authserver", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("oauth2authserver", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("oauth2authserver", "sessionManager", com.predic8.membrane.core.interceptor.authentication.session.SessionManager.class);
        localElementMappingPut("formValidation", "field", com.predic8.membrane.core.interceptor.formvalidation.FormValidationInterceptor.Field.class);
        localElementMappingPut("login", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("login", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("login", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("login", "sessionManager", com.predic8.membrane.core.interceptor.authentication.session.SessionManager.class);
        localElementMappingPut("login", "totpTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.TOTPTokenProvider.class);
        localElementMappingPut("login", "emailTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.EmailTokenProvider.class);
        localElementMappingPut("login", "emptyTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.EmptyTokenProvider.class);
        localElementMappingPut("login", "whateverMobileSMSTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.WhateverMobileSMSTokenProvider.class);
        localElementMappingPut("login", "telekomSMSTokenProvider", com.predic8.membrane.core.interceptor.authentication.session.TelekomSMSTokenProvider.class);
        localElementMappingPut("stompProxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("stompProxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("jsonPointerExtractor", "property", com.predic8.membrane.core.interceptor.json.JsonPointerExtractorInterceptor.Property.class);
        localElementMappingPut("serviceProxy", "path", com.predic8.membrane.core.config.Path.class);
        localElementMappingPut("serviceProxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("serviceProxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("serviceProxy", "target", com.predic8.membrane.core.rules.AbstractServiceProxy.Target.class);
        localElementMappingPut("swaggerProxy", "path", com.predic8.membrane.core.config.Path.class);
        localElementMappingPut("swaggerProxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("swaggerProxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("swaggerProxy", "target", com.predic8.membrane.core.rules.AbstractServiceProxy.Target.class);
        localElementMappingPut("rewriter", "map", com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor.Mapping.class);
        localElementMappingPut("staticUserDataProvider", "user", com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider.User.class);
        localElementMappingPut("wsStompReassembler", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("wsStompReassembler", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("response", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("response", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("map", "attribute", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.AttributeMap.Attribute.class);
        localElementMappingPut("oauth2PermissionChecker", "userInfo", com.predic8.membrane.core.interceptor.oauth2client.OAuth2PermissionCheckerInterceptor.UserInfoValueSource.class);
        localElementMappingPut("swaggerApiKeyRequirer", "header", com.predic8.membrane.core.interceptor.swagger.HeaderApiKeyTransmissionStrategy.class);
        localElementMappingPut("oauth2Resource", "github", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GithubAuthorizationService.class);
        localElementMappingPut("oauth2Resource", "google", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GoogleAuthorizationService.class);
        localElementMappingPut("oauth2Resource", "sessionManager", com.predic8.membrane.core.interceptor.authentication.session.SessionManager.class);
        localElementMappingPut("unifyingUserDataProvider", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("unifyingUserDataProvider", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("unifyingUserDataProvider", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("interceptor", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("interceptor", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("jwtSessionManager", "jwk", com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor.JwtSessionManager.Jwk.class);
        localElementMappingPut("api", "openapi", com.predic8.membrane.core.openapi.serviceproxy.APIProxy.Spec.class);
        localElementMappingPut("api", "path", com.predic8.membrane.core.config.Path.class);
        localElementMappingPut("api", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("api", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("api", "target", com.predic8.membrane.core.rules.AbstractServiceProxy.Target.class);
        localElementMappingPut("internalProxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("internalProxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("internalProxy", "target", com.predic8.membrane.core.rules.AbstractServiceProxy.Target.class);
        localElementMappingPut("apiKeyChecker", "header", com.predic8.membrane.core.interceptor.swagger.HeaderApiKeyTransmissionStrategy.class);
        localElementMappingPut("cachingUserDataProvider", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("cachingUserDataProvider", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("cachingUserDataProvider", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("soapProxy", "path", com.predic8.membrane.core.config.Path.class);
        localElementMappingPut("soapProxy", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("soapProxy", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("balancer", "clusters", com.predic8.membrane.core.interceptor.balancer.Balancer.class);
        localElementMappingPut("registration", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("registration", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("acme", "kubernetesStorage", com.predic8.membrane.core.config.security.acme.KubernetesStorage.class);
        localElementMappingPut("acme", "fileStorage", com.predic8.membrane.core.config.security.acme.FileStorage.class);
        localElementMappingPut("acme", "memoryStorage", com.predic8.membrane.core.config.security.acme.MemoryStorage.class);
        localElementMappingPut("acme", "dnsOperator", com.predic8.membrane.core.config.security.acme.DnsOperatorAcmeValidation.class);
        localElementMappingPut("httpClientConfig", "connection", com.predic8.membrane.core.transport.http.client.ConnectionConfiguration.class);
        localElementMappingPut("httpClientConfig", "proxy", com.predic8.membrane.core.transport.http.client.ProxyConfiguration.class);
        localElementMappingPut("httpClientConfig", "authentication", com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration.class);
        localElementMappingPut("oauth2Resource2", "github", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GithubAuthorizationService.class);
        localElementMappingPut("oauth2Resource2", "google", com.predic8.membrane.core.interceptor.oauth2.authorizationservice.GoogleAuthorizationService.class);
        localElementMappingPut("jwtSessionManager", "jwk", com.predic8.membrane.core.interceptor.session.JwtSessionManager.Jwk.class);
        localElementMappingPut("xpathExtractor", "property", com.predic8.membrane.core.interceptor.xml.XmlPathExtractorInterceptor.Property.class);
        localElementMappingPut("cluster", "node", com.predic8.membrane.core.interceptor.balancer.Node.class);
        localElementMappingPut("transport", "request", com.predic8.membrane.core.interceptor.flow.RequestInterceptor.class);
        localElementMappingPut("transport", "response", com.predic8.membrane.core.interceptor.flow.ResponseInterceptor.class);
        localElementMappingPut("basicAuthentication", "unifyingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider.class);
        localElementMappingPut("basicAuthentication", "cachingUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider.class);
        localElementMappingPut("basicAuthentication", "ldapUserDataProvider", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.class);
        localElementMappingPut("basicAuthentication", "user", com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider.User.class);
        localElementMappingPut("switch", "case", com.predic8.membrane.core.interceptor.cbr.Case.class);
        localElementMappingPut("ldapUserDataProvider", "map", com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider.AttributeMap.class);
    }
}
