/* Copyright 2012,2013 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License. */

package com.predic8.membrane.core.config.spring;

/**
  * Automatically generated by com.predic8.membrane.annot.generator.Parsers.
  */
public class NamespaceHandlerAutoGenerated {

	public static void registerBeanDefinitionParsers(NamespaceHandler nh) {
		nh.registerGlobalBeanDefinitionParser("analyser", new AnalyserParser());
		nh.registerGlobalBeanDefinitionParser("statisticsProvider", new StatisticsProviderParser());
		nh.registerGlobalBeanDefinitionParser("router", new RouterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor", "clusters", new ClustersParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "clusters", new ClustersParser());
		nh.registerGlobalBeanDefinitionParser("limitedMemoryExchangeStore", new LimitedMemoryExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("ntlm", new NtlmParser());
		nh.registerGlobalBeanDefinitionParser("elasticSearchExchangeStore", new ElasticSearchExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("template", new TemplateParser());
		nh.registerGlobalBeanDefinitionParser("statisticsCSV", new StatisticsCSVParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "github", new GithubParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2ResourceInterceptor", "github", new GithubParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor", "github", new GithubParser());
		nh.registerGlobalBeanDefinitionParser("httpClient", new HttpClientParser());
		nh.registerGlobalBeanDefinitionParser("stompClient", new StompClientParser());
		nh.registerGlobalBeanDefinitionParser("resolverMap", new ResolverMapParser());
		nh.registerGlobalBeanDefinitionParser("claims", new ClaimsParser());
		nh.registerGlobalBeanDefinitionParser("redisOriginalExchangeStore", new RedisOriginalExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("spdy", new SpdyParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.ntlm.NtlmInterceptor", "headerRetriever", new HeaderRetrieverParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "headerRetriever", new HeaderRetrieverParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.RequestInterceptor", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.ConditionalInterceptor", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ProxyRule", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.STOMPProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ServiceProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SwaggerProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.ws.interceptors.WebSocketStompReassembler", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.ResponseInterceptor", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.SpringInterceptor", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.openapi.serviceproxy.APIProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.InternalProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SOAPProxy", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.http.HttpTransport", "request", new RequestParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "request", new RequestParser());
		nh.registerGlobalBeanDefinitionParser("rest2Soap", new Rest2SoapParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "header", new HeaderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.swagger.SwaggerApiKeyRequirer", "header", new HeaderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.swagger.ApiKeyCheckerInterceptor", "header", new HeaderParser());
		nh.registerGlobalBeanDefinitionParser("private", new PrivateParser());
		nh.registerGlobalBeanDefinitionParser("sslProxy", new SslProxyParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "case", new SwitchcaseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.cbr.XPathCBRInterceptor", "case", new SwitchcaseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SSLProxy", "gatekeeper", new SslProxygatekeeperParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "gatekeeper", new SslProxygatekeeperParser());
		nh.registerGlobalBeanDefinitionParser("fileStore", new FileStoreParser());
		nh.registerGlobalBeanDefinitionParser("jwtAuth", new JwtAuthParser());
		nh.registerGlobalBeanDefinitionParser("xmlProtection", new XmlProtectionParser());
		nh.registerGlobalBeanDefinitionParser("wadlRewriter", new WadlRewriterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "google", new GoogleParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2ResourceInterceptor", "google", new GoogleParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor", "google", new GoogleParser());
		nh.registerGlobalBeanDefinitionParser("if", new IfParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "attribute", new AttributeParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider$AttributeMap", "attribute", new AttributeParser());
		nh.registerGlobalBeanDefinitionParser("keyGenerator", new KeyGeneratorParser());
		nh.registerGlobalBeanDefinitionParser("http2xml", new Http2xmlParser());
		nh.registerGlobalBeanDefinitionParser("tokenValidator", new TokenValidatorParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "client", new StaticClientListclientParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.StaticClientList", "client", new StaticClientListclientParser());
		nh.registerGlobalBeanDefinitionParser("staticClientList", new StaticClientListParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "user", new StaticUserDataProvideruserParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider", "user", new StaticUserDataProvideruserParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor", "user", new StaticUserDataProvideruserParser());
		nh.registerGlobalBeanDefinitionParser("wsInterceptor", new WsInterceptorParser());
		nh.registerGlobalBeanDefinitionParser("clusterNotification", new ClusterNotificationParser());
		nh.registerGlobalBeanDefinitionParser("httpSchemaResolver", new HttpSchemaResolverParser());
		nh.registerGlobalBeanDefinitionParser("exchangeStore", new ExchangeStoreParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.stomp.STOMPClient", "connection", new ConnectionParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SSLProxy", "connection", new ConnectionParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.http.client.HttpClientConfiguration", "connection", new ConnectionParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "connection", new ConnectionParser());
		nh.registerGlobalBeanDefinitionParser("throttle", new ThrottleParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SSLProxy", "routerIpResolver", new SslProxyrouterIpResolverParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "routerIpResolver", new SslProxyrouterIpResolverParser());
		nh.registerGlobalBeanDefinitionParser("keyFile", new KeyFileParser());
		nh.registerGlobalBeanDefinitionParser("prometheus", new PrometheusParser());
		nh.registerGlobalBeanDefinitionParser("bean", new BeanParser());
		nh.registerGlobalBeanDefinitionParser("jwks", new JwksParser());
		nh.registerGlobalBeanDefinitionParser("accountRegistration", new AccountRegistrationParser());
		nh.registerGlobalBeanDefinitionParser("userFeature", new UserFeatureParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor$JwtSessionManager", "jwk", new XenAuthenticationjwtSessionManagerjwkParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "jwk", new XenAuthenticationjwtSessionManagerjwkParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.session.JwtSessionManager", "jwk", new JwtSessionManagerjwkParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "jwk", new JwtSessionManagerjwkParser());
		nh.registerGlobalBeanDefinitionParser("graphQLProtection", new GraphQLProtectionParser());
		nh.registerGlobalBeanDefinitionParser("dispatching", new DispatchingParser());
		nh.registerGlobalBeanDefinitionParser("clamav", new ClamavParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ServiceProxy", "target", new TargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SwaggerProxy", "target", new TargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.openapi.serviceproxy.APIProxy", "target", new TargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.InternalProxy", "target", new TargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "target", new TargetParser());
		nh.registerGlobalBeanDefinitionParser("key", new KeyParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.ClaimList", "scope", new ClaimsscopeParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "scope", new ClaimsscopeParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2client.OAuth2PermissionCheckerInterceptor", "userInfo", new UserInfoParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "userInfo", new UserInfoParser());
		nh.registerGlobalBeanDefinitionParser("accessControl", new AccessControlParser());
		nh.registerGlobalBeanDefinitionParser("xenAuthentication", new XenAuthenticationParser());
		nh.registerGlobalBeanDefinitionParser("proxy", new ProxyParser());
		nh.registerGlobalBeanDefinitionParser("groovy", new GroovyParser());
		nh.registerGlobalBeanDefinitionParser("oauth2authserver", new Oauth2authserverParser());
		nh.registerGlobalBeanDefinitionParser("soapStackTraceFilter", new SoapStackTraceFilterParser());
		nh.registerGlobalBeanDefinitionParser("include", new IncludeParser());
		nh.registerGlobalBeanDefinitionParser("logContext", new LogContextParser());
		nh.registerGlobalBeanDefinitionParser("formValidation", new FormValidationParser());
		nh.registerGlobalBeanDefinitionParser("defaultConfig", new DefaultConfigParser());
		nh.registerGlobalBeanDefinitionParser("statisticsJDBC", new StatisticsJDBCParser());
		nh.registerGlobalBeanDefinitionParser("return", new ReturnParser());
		nh.registerGlobalBeanDefinitionParser("login", new LoginParser());
		nh.registerGlobalBeanDefinitionParser("groovyTemplate", new GroovyTemplateParser());
		nh.registerGlobalBeanDefinitionParser("etcdResolver", new EtcdResolverParser());
		nh.registerGlobalBeanDefinitionParser("uriFactory", new UriFactoryParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.openapi.serviceproxy.APIProxy", "openapi", new OpenapiParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "openapi", new OpenapiParser());
		nh.registerGlobalBeanDefinitionParser("testService", new TestServiceParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "totpTokenProvider", new TotpTokenProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "totpTokenProvider", new TotpTokenProviderParser());
		nh.registerGlobalBeanDefinitionParser("stompProxy", new StompProxyParser());
		nh.registerGlobalBeanDefinitionParser("xmlSessionIdExtractor", new XmlSessionIdExtractorParser());
		nh.registerGlobalBeanDefinitionParser("rateLimiter", new RateLimiterParser());
		nh.registerGlobalBeanDefinitionParser("jmxExporter", new JmxExporterParser());
		nh.registerGlobalBeanDefinitionParser("jsonPointerExtractor", new JsonPointerExtractorParser());
		nh.registerGlobalBeanDefinitionParser("adminConsole", new AdminConsoleParser());
		nh.registerGlobalBeanDefinitionParser("serviceProxy", new ServiceProxyParser());
		nh.registerGlobalBeanDefinitionParser("authHead2Body", new AuthHead2BodyParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "claim", new SupportedClaimsclaimParser());
		nh.registerGlobalBeanDefinitionParser("methodOverride", new MethodOverrideParser());
		nh.registerGlobalBeanDefinitionParser("trust", new TrustParser());
		nh.registerGlobalBeanDefinitionParser("membrane", new MembraneParser());
		nh.registerGlobalBeanDefinitionParser("swaggerProxy", new SwaggerProxyParser());
		nh.registerGlobalBeanDefinitionParser("rewriter", new RewriterParser());
		nh.registerGlobalBeanDefinitionParser("exclude", new ExcludeParser());
		nh.registerGlobalBeanDefinitionParser("staticUserDataProvider", new StaticUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor", "sessionManager", new SessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "sessionManager", new SessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2ResourceInterceptor", "sessionManager", new SessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "sessionManager", new SessionManagerParser());
		nh.registerGlobalBeanDefinitionParser("index", new IndexinterceptorParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "emailTokenProvider", new EmailTokenProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "emailTokenProvider", new EmailTokenProviderParser());
		nh.registerGlobalBeanDefinitionParser("wsStompReassembler", new WsStompReassemblerParser());
		nh.registerGlobalBeanDefinitionParser("forgetfulExchangeStore", new ForgetfulExchangeStoreParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.RequestInterceptor", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.ConditionalInterceptor", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ProxyRule", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.STOMPProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ServiceProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SwaggerProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.ws.interceptors.WebSocketStompReassembler", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.flow.ResponseInterceptor", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.SpringInterceptor", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.openapi.serviceproxy.APIProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.InternalProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SOAPProxy", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.http.HttpTransport", "response", new ResponseParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "response", new ResponseParser());
		nh.registerGlobalBeanDefinitionParser("inMemoryStore", new InMemoryStoreParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SSLProxy", "target", new SslProxytargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "target", new SslProxytargetParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.ServiceProxy", "path", new PathParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SwaggerProxy", "path", new PathParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.openapi.serviceproxy.APIProxy", "path", new PathParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.rules.SOAPProxy", "path", new PathParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "path", new PathParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "emptyTokenProvider", new EmptyTokenProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "emptyTokenProvider", new EmptyTokenProviderParser());
		nh.registerGlobalBeanDefinitionParser("gatekeeper", new GatekeeperParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LDAPUserDataProvider", "map", new LdapUserDataProvidermapParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "map", new LdapUserDataProvidermapParser());
		nh.registerGlobalBeanDefinitionParser("setHeader", new SetHeaderParser());
		nh.registerGlobalBeanDefinitionParser("ruleMatching", new RuleMatchingParser());
		nh.registerGlobalBeanDefinitionParser("headerJwtRetriever", new HeaderJwtRetrieverParser());
		nh.registerGlobalBeanDefinitionParser("oauth2PermissionChecker", new Oauth2PermissionCheckerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor", "map", new RewritermapParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "map", new RewritermapParser());
		nh.registerGlobalBeanDefinitionParser("jSessionIdExtractor", new JSessionIdExtractorParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "whateverMobileSMSTokenProvider", new WhateverMobileSMSTokenProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "whateverMobileSMSTokenProvider", new WhateverMobileSMSTokenProviderParser());
		nh.registerGlobalBeanDefinitionParser("swaggerApiKeyRequirer", new SwaggerApiKeyRequirerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.balancer.Cluster", "node", new NodeParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "node", new NodeParser());
		nh.registerGlobalBeanDefinitionParser("oauth2Resource", new Oauth2ResourceParser());
		nh.registerGlobalBeanDefinitionParser("routerIpResolver", new RouterIpResolverParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor", "unifyingUserDataProvider", new UnifyingUserDataProviderParser());
		nh.registerGlobalBeanDefinitionParser("interceptor", new InterceptorParser());
		nh.registerGlobalBeanDefinitionParser("keystore", new KeystoreParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "jwtSessionManager", new XenAuthenticationjwtSessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor", "jwtSessionManager", new XenAuthenticationjwtSessionManagerParser());
		nh.registerGlobalBeanDefinitionParser("api", new ApiParser());
		nh.registerGlobalBeanDefinitionParser("sessionOriginalExchangeStore", new SessionOriginalExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("webSocket", new WebSocketParser());
		nh.registerGlobalBeanDefinitionParser("internalProxy", new InternalProxyParser());
		nh.registerGlobalBeanDefinitionParser("apiKeyChecker", new ApiKeyCheckerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.jwt.Jwks", "jwk", new JwksjwkParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "jwk", new JwksjwkParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor", "cachingUserDataProvider", new CachingUserDataProviderParser());
		nh.registerGlobalBeanDefinitionParser("soapProxy", new SoapProxyParser());
		nh.registerGlobalBeanDefinitionParser("balancer", new BalancerParser());
		nh.registerGlobalBeanDefinitionParser("registration", new RegistrationParser());
		nh.registerGlobalBeanDefinitionParser("cookieOriginalExchangeStore", new CookieOriginalExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("jdbcUserDataProvider", new JdbcUserDataProviderParser());
		nh.registerGlobalBeanDefinitionParser("wsLog", new WsLogParser());
		nh.registerGlobalBeanDefinitionParser("tcp", new TcpParser());
		nh.registerGlobalBeanDefinitionParser("webServiceExplorer", new WebServiceExplorerParser());
		nh.registerGlobalBeanDefinitionParser("etcdRegistryApiConfig", new EtcdRegistryApiConfigParser());
		nh.registerGlobalBeanDefinitionParser("fileExchangeStore", new FileExchangeStoreParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "property", new XpathmapParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.xml.XmlPathExtractorInterceptor", "property", new XpathmapParser());
		nh.registerGlobalBeanDefinitionParser("truststore", new TruststoreParser());
		nh.registerGlobalBeanDefinitionParser("acme", new AcmeParser());
		nh.registerGlobalBeanDefinitionParser("ssl", new SslParser());
		nh.registerGlobalBeanDefinitionParser("httpClientConfig", new HttpClientConfigParser());
		nh.registerGlobalBeanDefinitionParser("oauth2Resource2", new Oauth2Resource2Parser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "field", new FormValidationfieldParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.formvalidation.FormValidationInterceptor", "field", new FormValidationfieldParser());
		nh.registerGlobalBeanDefinitionParser("etcdBasedConfigurator", new EtcdBasedConfiguratorParser());
		nh.registerGlobalBeanDefinitionParser("urlNormalizer", new UrlNormalizerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.config.security.acme.Acme", "kubernetesStorage", new KubernetesStorageParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "kubernetesStorage", new KubernetesStorageParser());
		nh.registerGlobalBeanDefinitionParser("log", new LogParser());
		nh.registerGlobalBeanDefinitionParser("jwtSessionManager", new JwtSessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "telekomSMSTokenProvider", new TelekomSMSTokenProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "telekomSMSTokenProvider", new TelekomSMSTokenProviderParser());
		nh.registerGlobalBeanDefinitionParser("inMemorySessionManager2", new InMemorySessionManager2Parser());
		nh.registerGlobalBeanDefinitionParser("soap2Rest", new Soap2RestParser());
		nh.registerGlobalBeanDefinitionParser("wsdlRewriter", new WsdlRewriterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.config.security.acme.Acme", "dnsOperator", new DnsOperatorParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "dnsOperator", new DnsOperatorParser());
		nh.registerGlobalBeanDefinitionParser("counter", new CounterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.http.client.HttpClientConfiguration", "authentication", new AuthenticationParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "authentication", new AuthenticationParser());
		nh.registerGlobalBeanDefinitionParser("apiManagement", new ApiManagementParser());
		nh.registerGlobalBeanDefinitionParser("shutdown", new ShutdownParser());
		nh.registerGlobalBeanDefinitionParser("faultMonitoringStrategy", new FaultMonitoringStrategyParser());
		nh.registerGlobalBeanDefinitionParser("xpathExtractor", new XpathExtractorParser());
		nh.registerGlobalBeanDefinitionParser("jwtSessionManager2", new JwtSessionManager2Parser());
		nh.registerGlobalBeanDefinitionParser("redisSessionManager", new RedisSessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.balancer.Balancer", "cluster", new ClusterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "cluster", new ClusterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.transport.http.client.HttpClientConfiguration", "proxy", new ProxyconfigurationParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "proxy", new ProxyconfigurationParser());
		nh.registerGlobalBeanDefinitionParser("amQuota", new AmQuotaParser());
		nh.registerGlobalBeanDefinitionParser("transport", new TransportParser());
		nh.registerGlobalBeanDefinitionParser("xml2Json", new Xml2JsonParser());
		nh.registerGlobalBeanDefinitionParser("xmlContentFilter", new XmlContentFilterParser());
		nh.registerGlobalBeanDefinitionParser("nodeOnlineChecker", new NodeOnlineCheckerParser());
		nh.registerGlobalBeanDefinitionParser("certificate", new CertificateParser());
		nh.registerGlobalBeanDefinitionParser("swaggerRewriter", new SwaggerRewriterParser());
		nh.registerGlobalBeanDefinitionParser("amRateLimiter", new AmRateLimiterParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.config.security.acme.Acme", "fileStorage", new FileStorageParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "fileStorage", new FileStorageParser());
		nh.registerGlobalBeanDefinitionParser("memoryExchangeStore", new MemoryExchangeStoreParser());
		nh.registerGlobalBeanDefinitionParser("basicAuthentication", new BasicAuthenticationParser());
		nh.registerGlobalBeanDefinitionParser("kubernetesValidation", new KubernetesValidationParser());
		nh.registerGlobalBeanDefinitionParser("customStatementJdbcUserDataProvider", new CustomStatementJdbcUserDataProviderParser());
		nh.registerGlobalBeanDefinitionParser("transform", new TransformParser());
		nh.registerGlobalBeanDefinitionParser("byThreadStrategy", new ByThreadStrategyParser());
		nh.registerGlobalBeanDefinitionParser("simpleApiConfig", new SimpleApiConfigParser());
		nh.registerGlobalBeanDefinitionParser("headerFilter", new HeaderFilterParser());
		nh.registerGlobalBeanDefinitionParser("amStatisticsCollector", new AmStatisticsCollectorParser());
		nh.registerGlobalBeanDefinitionParser("roundRobinStrategy", new RoundRobinStrategyParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "property", new JsonpointermapParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.json.JsonPointerExtractorInterceptor", "property", new JsonpointermapParser());
		nh.registerGlobalBeanDefinitionParser("jsonProtection", new JsonProtectionParser());
		nh.registerGlobalBeanDefinitionParser("javascript", new JavascriptParser());
		nh.registerGlobalBeanDefinitionParser("acmeHttpChallenge", new AcmeHttpChallengeParser());
		nh.registerGlobalBeanDefinitionParser("reverseProxying", new ReverseProxyingParser());
		nh.registerGlobalBeanDefinitionParser("json2Xml", new Json2XmlParser());
		nh.registerGlobalBeanDefinitionParser("wsdlPublisher", new WsdlPublisherParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "mapping", new Rest2SoapmappingParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor", "mapping", new Rest2SoapmappingParser());
		nh.registerGlobalBeanDefinitionParser("switch", new SwitchParser());
		nh.registerGlobalBeanDefinitionParser("bearerToken", new BearerTokenParser());
		nh.registerGlobalBeanDefinitionParser("etcdPublisher", new EtcdPublisherParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.LoginInterceptor", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.UnifyingUserDataProvider", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.session.CachingUserDataProvider", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.BasicAuthenticationInterceptor", "ldapUserDataProvider", new LdapUserDataProviderParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "inMemorySessionManager", new InMemorySessionManagerParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.interceptor.authentication.xen.XenAuthenticationInterceptor", "inMemorySessionManager", new InMemorySessionManagerParser());
		nh.registerGlobalBeanDefinitionParser("webServer", new WebServerParser());
		nh.registerGlobalBeanDefinitionParser("validator", new ValidatorParser());
		nh.registerGlobalBeanDefinitionParser("soapOperationExtractor", new SoapOperationExtractorParser());
		nh.registerGlobalBeanDefinitionParser("limit", new LimitParser());
		nh.registerGlobalBeanDefinitionParser("beautifier", new BeautifierParser());
		nh.registerGlobalBeanDefinitionParser("cache", new CacheParser());
		nh.registerGlobalBeanDefinitionParser("regExReplacer", new RegExReplacerParser());
		nh.registerGlobalBeanDefinitionParser("accountBlocker", new AccountBlockerParser());
		nh.registerGlobalBeanDefinitionParser("redis", new RedisParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.config.security.acme.Acme", "memoryStorage", new MemoryStorageParser());
		nh.registerLocalBeanDefinitionParser("com.predic8.membrane.core.kubernetes.Bean", "memoryStorage", new MemoryStorageParser());
	}
}
