/* Copyright 2012 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License. */

package com.predic8.membrane.core.config.spring;

import org.w3c.dom.Element;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

/**
  * Automatically generated by com.predic8.membrane.annot.generator.Parsers.
  */
public class Oauth2Resource2Parser extends AbstractParser {

	protected Class<?> getBeanClass(org.w3c.dom.Element element) {
		return com.predic8.membrane.core.interceptor.oauth2client.OAuth2Resource2Interceptor.class;
	}
	@Override
	protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
		setPropertyIfSet("id", element, builder);
		setIdIfNeeded(element, parserContext, "oauth2Resource2");
		setPropertyIfSet("publicURL", "publicURL", element, builder);
		setPropertyIfSet("revalidateTokenAfter", "revalidateTokenAfter", element, builder);
		setPropertyIfSet("callbackPath", "callbackPath", element, builder);
		setPropertyIfSet("skipUserInfo", "skipUserInfo", element, builder);
		parseChildren(element, parserContext, builder);
	}
@Override
protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
	if (com.predic8.membrane.core.interceptor.session.SessionManager.class.isAssignableFrom(clazz)) {
		setProperty(builder, "sessionManager", child);
	} else 
	if (com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService.class.isAssignableFrom(clazz)) {
		setProperty(builder, "authService", child);
	} else 
	if (com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore.class.isAssignableFrom(clazz)) {
		setProperty(builder, "originalExchangeStore", child);
	} else 
	{
		throw new RuntimeException("Unknown child class \"" + clazz + "\".");
	}
}
}
