/* Copyright 2012 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License. */

package com.predic8.membrane.core.config.spring;

import org.w3c.dom.Element;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

/**
  * Automatically generated by com.predic8.membrane.annot.generator.Parsers.
  */
public class SslParser extends AbstractParser {

	protected Class<?> getBeanClass(org.w3c.dom.Element element) {
		return com.predic8.membrane.core.config.security.SSLParser.class;
	}
	@Override
	protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
		setIdIfNeeded(element, parserContext, "ssl");
		setPropertyIfSet("algorithm", "algorithm", element, builder);
		setPropertyIfSet("protocol", "protocol", element, builder);
		setPropertyIfSet("protocols", "protocols", element, builder);
		setPropertyIfSet("ciphers", "ciphers", element, builder);
		setPropertyIfSet("clientAuth", "clientAuth", element, builder);
		setPropertyIfSet("ignoreTimestampCheckFailure", "ignoreTimestampCheckFailure", element, builder);
		setPropertyIfSet("endpointIdentificationAlgorithm", "endpointIdentificationAlgorithm", element, builder);
		setPropertyIfSet("serverName", "serverName", element, builder);
		setPropertyIfSet("showSSLExceptions", "showSSLExceptions", element, builder);
		setPropertyIfSet("useAsDefault", "useAsDefault", element, builder);
		setPropertyIfSet("useExperimentalHttp2", "useExperimentalHttp2", element, builder);
		parseChildren(element, parserContext, builder);
	}
@Override
protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
	if (com.predic8.membrane.core.config.security.KeyStore.class.isAssignableFrom(clazz)) {
		setProperty(builder, "keyStore", child);
	} else 
	if (com.predic8.membrane.core.config.security.Key.class.isAssignableFrom(clazz)) {
		setProperty(builder, "key", child);
	} else 
	if (com.predic8.membrane.core.config.security.KeyGenerator.class.isAssignableFrom(clazz)) {
		setProperty(builder, "keyGenerator", child);
	} else 
	if (com.predic8.membrane.core.config.security.TrustStore.class.isAssignableFrom(clazz)) {
		setProperty(builder, "trustStore", child);
	} else 
	if (com.predic8.membrane.core.config.security.Trust.class.isAssignableFrom(clazz)) {
		setProperty(builder, "trust", child);
	} else 
	if (com.predic8.membrane.core.config.security.acme.Acme.class.isAssignableFrom(clazz)) {
		setProperty(builder, "acme", child);
	} else 
	{
		throw new RuntimeException("Unknown child class \"" + clazz + "\".");
	}
}
}
