/* Copyright 2012 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License. */

package com.predic8.membrane.core.config.spring;

import org.w3c.dom.Element;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

/**
  * Automatically generated by com.predic8.membrane.annot.generator.Parsers.
  */
public class SwitchParser extends AbstractParser {

	protected Class<?> getBeanClass(org.w3c.dom.Element element) {
		return com.predic8.membrane.core.interceptor.cbr.XPathCBRInterceptor.class;
	}
	@Override
	protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
		setPropertyIfSet("id", element, builder);
		setIdIfNeeded(element, parserContext, "switch");
		builder.addPropertyValue("cases", new java.util.ArrayList<Object>());
		parseChildren(element, parserContext, builder);
		if (builder.getBeanDefinition().getPropertyValues().getPropertyValue("cases[0]") == null)
			throw new RuntimeException("Property 'cases' is required, but none was defined (empty list).");
	}
@Override
protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
	if (com.predic8.membrane.core.interceptor.cbr.Case.class.isAssignableFrom(clazz)) {
		setProperty(builder, "cases"+"["+ incrementCounter(builder, "cases") + "]" , child);
	} else 
	{
		throw new RuntimeException("Unknown child class \"" + clazz + "\".");
	}
}
}
