/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.balancer.client;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.util.MessageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBNotificationClient {
    private static final Logger log = LoggerFactory.getLogger((String)LBNotificationClient.class.getName());
    private static final SecureRandom secureRandom = new SecureRandom();
    private final String propertiesFile = "client.properties";
    private String cmd;
    private String host;
    private String port;
    private String cmURL;
    private String balancer;
    private String cluster;
    private SecretKeySpec skeySpec;

    public static void main(String[] args) throws Exception {
        new LBNotificationClient().run(args);
    }

    public void run(String[] args) throws Exception {
        CommandLine cl = new DefaultParser().parse(this.getOptions(), args, false);
        if (cl.hasOption('h') || args.length < 2) {
            this.printUsage();
            return;
        }
        this.parseArguments(cl);
        this.logArguments();
        Response res = this.notifiyClusterManager();
        if (res.getStatusCode() != 204) {
            throw new Exception("Got StatusCode: " + res.getStatusCode());
        }
        log.info("Sent " + this.cmd + " message to " + this.host + ":" + this.port + (this.skeySpec != null ? " encrypted" : ""));
    }

    private Response notifiyClusterManager() throws Exception {
        try (HttpClient client = new HttpClient();){
            Exchange exc = new Exchange(null);
            Request r = MessageUtil.getPostRequest(this.getRequestURL());
            r.setBodyContent(new byte[0]);
            exc.setRequest(r);
            exc.getDestinations().add(this.getRequestURL());
            Response response = client.call(exc).getResponse();
            return response;
        }
    }

    private void parseArguments(CommandLine cl) throws Exception {
        if (!new File("client.properties").exists()) {
            log.warn("no properties file found at: " + new File("client.properties").getAbsolutePath());
        }
        this.cmd = this.getArgument(cl, 0, '-', null, null, "No command up, down or takeout specified!");
        this.host = this.getArgument(cl, 1, 'H', null, null, "No host name specified!");
        this.port = this.getArgument(cl, 2, 'p', null, "80", "");
        this.balancer = this.getArgument(cl, -1, 'b', null, "Default", "");
        this.cluster = this.getArgument(cl, -1, 'c', null, "Default", "");
        this.cmURL = this.getArgument(cl, -1, 'u', "clusterManager", null, "No cluster manager location found!");
        String key = this.getArgument(cl, -1, '-', "key", "", null);
        if (!"".equals(key)) {
            this.skeySpec = new SecretKeySpec(Hex.decodeHex((char[])key.toCharArray()), "AES");
        }
    }

    private String getArgument(CommandLine cl, int clArgPos, char option, String prop, String def, String errMsg) throws Exception {
        if (clArgPos != -1 && cl.getArgs().length > clArgPos) {
            return cl.getArgs()[clArgPos];
        }
        if (option != '-' && cl.hasOption(option)) {
            return cl.getOptionValue(option);
        }
        if (prop != null && new File("client.properties").exists()) {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream("client.properties");){
                props.load(is);
            }
            if (props.containsKey(prop)) {
                return props.getProperty(prop);
            }
        }
        if (def != null) {
            return def;
        }
        throw new MissingArgumentException(errMsg);
    }

    private String getQueryString() {
        String time = String.valueOf(System.currentTimeMillis());
        return "balancer=" + this.balancer + "&cluster=" + this.cluster + "&host=" + this.host + "&port=" + this.port + "&time=" + time + "&nonce=" + secureRandom.nextLong();
    }

    private String getRequestURL() throws Exception {
        if (this.skeySpec != null) {
            return this.cmURL + "/" + this.cmd + "?data=" + URLEncoder.encode(this.getEncryptedQueryString(), StandardCharsets.UTF_8);
        }
        String time = String.valueOf(System.currentTimeMillis());
        return this.cmURL + "/" + this.cmd + "?balancer=" + this.balancer + "&cluster=" + this.cluster + "&host=" + this.host + "&port=" + this.port + "&time=" + time;
    }

    private String getEncryptedQueryString() throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.skeySpec);
        return new String(Base64.encodeBase64((byte[])cipher.doFinal(this.getQueryString().getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
    }

    private void logArguments() {
        log.debug("cmd: " + this.cmd);
        log.debug("host: " + this.host);
        log.debug("port: " + this.port);
        log.debug("cmURL: " + this.cmURL);
        log.debug("cluster: " + this.cluster);
        log.debug("balancer: " + this.balancer);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "print usage.");
        options.addOption("b", "balancer", true, "Sets the balancer name for the operation. (Default:Default)");
        options.addOption("c", "cluster", true, "Sets the cluster name for the operation. (Default:Default)");
        options.addOption("H", "host", true, "Sets the host name for the operation.");
        options.addOption("p", "port", true, "Sets the port for the operation. (Default:80)");
        options.addOption("u", "clusterManager", true, "Sets the url of the cluster manager.");
        options.addOption("e", "useEncryption", false, "When set the parameters will be encrypted.");
        return options;
    }

    private void printUsage() {
        String usage = "(up|down|takeout) (host|-h host) [port|-p port] [args] ";
        String header = "Creats signed up and down messages for the load balancer push interface.";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(80);
        helpFormatter.printHelp("(up|down|takeout) (host|-h host) [port|-p port] [args] ", "Creats signed up and down messages for the load balancer push interface.", this.getOptions(), null);
    }
}

