/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCMain;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.HotDeploymentThread;
import com.predic8.membrane.core.RuleManager;
import com.predic8.membrane.core.Statistics;
import com.predic8.membrane.core.config.spring.BaseLocationApplicationContext;
import com.predic8.membrane.core.config.spring.TrackingApplicationContext;
import com.predic8.membrane.core.config.spring.TrackingFileSystemXmlApplicationContext;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore;
import com.predic8.membrane.core.interceptor.FlowController;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.jmx.JmxExporter;
import com.predic8.membrane.core.jmx.JmxRouter;
import com.predic8.membrane.core.kubernetes.KubernetesWatcher;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.openapi.OpenAPIParsingException;
import com.predic8.membrane.core.openapi.serviceproxy.DuplicatePathException;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.ProxyDisplayInfo;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.http.HttpServerThreadFactory;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.DNSCache;
import com.predic8.membrane.core.util.TimerManager;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

@MCMain(outputPackage="com.predic8.membrane.core.config.spring", outputName="router-conf.xsd", targetNamespace="http://membrane-soa.org/proxies/1/")
@MCElement(name="router")
public class Router
implements Lifecycle,
ApplicationContextAware,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger((String)Router.class.getName());
    protected static final HashSet<ApplicationContext> hotDeployingContexts = new HashSet();
    private ApplicationContext beanFactory;
    private String baseLocation;
    protected RuleManager ruleManager = new RuleManager();
    protected final FlowController flowController;
    protected ExchangeStore exchangeStore = new LimitedMemoryExchangeStore();
    protected Transport transport;
    protected ResolverMap resolverMap;
    protected DNSCache dnsCache = new DNSCache();
    protected final ExecutorService backgroundInitializer = Executors.newSingleThreadExecutor(new HttpServerThreadFactory("Router Background Initializer"));
    protected HotDeploymentThread hdt;
    protected URIFactory uriFactory = new URIFactory(false);
    protected final Statistics statistics = new Statistics();
    protected String jmxRouterName;
    private boolean production;
    private boolean hotDeploy = true;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean running;
    private int retryInitInterval = 300000;
    private boolean retryInit;
    private Timer reinitializer;
    private String id;
    private final KubernetesWatcher kubernetesWatcher = new KubernetesWatcher(this);
    private final TimerManager timerManager = new TimerManager();
    private final HttpClientFactory httpClientFactory = new HttpClientFactory(this.timerManager);
    private final KubernetesClientFactory kubernetesClientFactory = new KubernetesClientFactory(this.httpClientFactory);

    public Router() {
        this.ruleManager.setRouter(this);
        this.resolverMap = new ResolverMap(this.httpClientFactory, this.kubernetesClientFactory);
        this.resolverMap.addRuleResolver(this);
        this.flowController = new FlowController(this);
    }

    public Collection<Proxy> getRules() {
        return this.getRuleManager().getRulesBySource(RuleManager.RuleDefinitionSource.SPRING);
    }

    @MCChildElement(order=3)
    public void setRules(Collection<Proxy> proxies) {
        this.getRuleManager().removeAllRules();
        for (Proxy proxy : proxies) {
            this.getRuleManager().addProxy(proxy, RuleManager.RuleDefinitionSource.SPRING);
        }
    }

    public static Router init(String resource) {
        log.debug("loading spring config: {}", (Object)resource);
        TrackingFileSystemXmlApplicationContext bf = new TrackingFileSystemXmlApplicationContext(new String[]{resource}, false);
        bf.refresh();
        bf.start();
        return (Router)bf.getBean("router", Router.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
        if (applicationContext instanceof BaseLocationApplicationContext) {
            this.setBaseLocation(((BaseLocationApplicationContext)applicationContext).getBaseLocation());
        }
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
        ruleManager.setRouter(this);
    }

    public ExchangeStore getExchangeStore() {
        return this.exchangeStore;
    }

    @MCAttribute
    public void setExchangeStore(ExchangeStore exchangeStore) {
        this.exchangeStore = exchangeStore;
    }

    public Transport getTransport() {
        return this.transport;
    }

    @MCChildElement(order=1, allowForeign=true)
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public HttpClientConfiguration getHttpClientConfig() {
        return this.resolverMap.getHTTPSchemaResolver().getHttpClientConfig();
    }

    @MCChildElement
    public void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.resolverMap.getHTTPSchemaResolver().setHttpClientConfig(httpClientConfig);
    }

    public DNSCache getDnsCache() {
        return this.dnsCache;
    }

    public ResolverMap getResolverMap() {
        return this.resolverMap;
    }

    public void shutdown() {
        this.backgroundInitializer.shutdown();
        if (this.transport != null) {
            this.transport.closeAll();
        }
        this.timerManager.shutdown();
    }

    @Deprecated
    public void shutdownNoWait() {
        this.shutdown();
    }

    public ExecutorService getBackgroundInitializer() {
        return this.backgroundInitializer;
    }

    public Proxy getParentProxy(Interceptor interceptor) {
        for (Proxy r : this.getRuleManager().getRules()) {
            if (r.getInterceptors() == null) continue;
            for (Interceptor i : r.getInterceptors()) {
                if (i != interceptor) continue;
                return r;
            }
        }
        throw new IllegalArgumentException("No parent proxy found for the given interceptor.");
    }

    public void add(Proxy proxy) throws IOException {
        if (!(proxy instanceof SSLableProxy)) {
            this.ruleManager.addProxy(proxy, RuleManager.RuleDefinitionSource.MANUAL);
        } else {
            SSLableProxy sp = (SSLableProxy)proxy;
            this.ruleManager.addProxyAndOpenPortIfNew(sp);
        }
    }

    public void init() throws Exception {
        this.initRemainingRules();
        this.transport.init(this);
    }

    private void initRemainingRules() throws Exception {
        for (Proxy proxy : this.getRuleManager().getRules()) {
            proxy.init(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            if (this.transport == null && this.beanFactory != null && !this.beanFactory.getBeansOfType(Transport.class).isEmpty()) {
                throw new RuntimeException("unclaimed transport detected. - please migrate to 4.0");
            }
            if (this.exchangeStore == null) {
                this.exchangeStore = new LimitedMemoryExchangeStore();
            }
            if (this.transport == null) {
                this.transport = new HttpTransport();
            }
            this.kubernetesWatcher.start();
            this.init();
            this.initJmx();
            this.getRuleManager().openPorts();
            try {
                if (this.hotDeploy) {
                    this.startHotDeployment();
                }
            }
            catch (Exception e) {
                this.shutdown();
                throw e;
            }
            if (this.retryInitInterval > 0) {
                this.startAutoReinitializer();
            }
        }
        catch (DuplicatePathException e) {
            System.err.printf("================================================================================================\n\nConfiguration Error: Several OpenAPI Documents share the same path!\n\nAn API routes and validates requests according to the path of the OpenAPI's servers.url fields.\nWithin one API the same path should be used only by one OpenAPI. Change the paths or place\nopenapi-elements into separate api-elements.\n\nShared path: %s\n%n", e.getPath());
            System.exit(1);
        }
        catch (OpenAPIParsingException e) {
            System.err.printf("================================================================================================\n\nConfiguration Error: Could not read or parse OpenAPI Document\n\nReason: %s\n\nLocation: %s\n\nHave a look at the proxies.xml file.\n", e.getMessage(), e.getLocation());
            System.exit(1);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.startJmx();
        Object object = this.lock;
        synchronized (object) {
            this.running = true;
        }
        ProxyDisplayInfo.logInfosAboutStartedProxies(this.ruleManager);
        log.info("{} {} up and running!", (Object)"Membrane API Gateway", (Object)Constants.VERSION);
    }

    private void startJmx() {
        if (this.getBeanFactory() != null) {
            try {
                ((JmxExporter)((Object)this.getBeanFactory().getBean("jmxExporter"))).initAfterBeansAdded();
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    private void initJmx() {
        if (this.beanFactory != null) {
            try {
                JmxExporter exporter = (JmxExporter)((Object)this.beanFactory.getBean("jmxExporter"));
                exporter.addBean("org.membrane-soa:00=routers, name=" + this.jmxRouterName, new JmxRouter(this, exporter));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHotDeployment() {
        if (this.hdt != null) {
            throw new IllegalStateException("Hot deployment already started.");
        }
        if (!(this.beanFactory instanceof TrackingApplicationContext)) {
            log.warn("ApplicationContext is not a TrackingApplicationContext. Please set <router hotDeploy=\"false\">.\n");
            return;
        }
        if (!(this.beanFactory instanceof AbstractRefreshableApplicationContext)) {
            throw new RuntimeException("ApplicationContext is not a AbstractRefreshableApplicationContext. Please set <router hotDeploy=\"false\">.");
        }
        HashSet<ApplicationContext> hashSet = hotDeployingContexts;
        synchronized (hashSet) {
            if (hotDeployingContexts.contains(this.beanFactory)) {
                return;
            }
            hotDeployingContexts.add(this.beanFactory);
        }
        this.hdt = new HotDeploymentThread((AbstractRefreshableApplicationContext)this.beanFactory);
        this.hdt.setFiles(((TrackingApplicationContext)this.beanFactory).getFiles());
        this.hdt.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHotDeployment() {
        this.stopAutoReinitializer();
        if (this.hdt != null) {
            this.hdt.stopASAP();
            this.hdt = null;
            HashSet<ApplicationContext> hashSet = hotDeployingContexts;
            synchronized (hashSet) {
                hotDeployingContexts.remove(this.beanFactory);
            }
        }
    }

    private void startAutoReinitializer() {
        if (this.getInactiveRules().isEmpty()) {
            return;
        }
        this.reinitializer = new Timer("auto reinitializer", true);
        this.reinitializer.schedule(new TimerTask(){

            @Override
            public void run() {
                Router.this.tryReinitialization();
            }
        }, this.retryInitInterval, (long)this.retryInitInterval);
    }

    public void tryReinitialization() {
        boolean stillFailing = false;
        ArrayList<Proxy> inactive = this.getInactiveRules();
        if (!inactive.isEmpty()) {
            log.info("Trying to activate all inactive rules.");
            for (Proxy proxy : inactive) {
                try {
                    log.info("Trying to start API {}.", (Object)proxy.getName());
                    Proxy newProxy = proxy.clone();
                    if (!newProxy.isActive()) {
                        log.warn("New rule for API {} is still not active.", (Object)proxy.getName());
                        stillFailing = true;
                    }
                    this.getRuleManager().replaceRule(proxy, newProxy);
                }
                catch (CloneNotSupportedException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        if (stillFailing) {
            log.info("There are still inactive rules.");
        } else {
            this.stopAutoReinitializer();
            log.info("All rules have been initialized.");
        }
    }

    private void stopAutoReinitializer() {
        if (this.reinitializer != null) {
            this.reinitializer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.kubernetesWatcher.stop();
        if (this.hdt != null) {
            this.stopHotDeployment();
        }
        this.shutdown();
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    public void stopAll() {
        for (String s : this.getBeanFactory().getBeanNamesForType(Router.class)) {
            ((Router)this.getBeanFactory().getBean(s)).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    @MCAttribute
    public void setHotDeploy(boolean hotDeploy) {
        if (this.isRunning()) {
            if (this.hotDeploy && !hotDeploy) {
                this.stopHotDeployment();
            }
            if (!this.hotDeploy && hotDeploy) {
                this.startHotDeployment();
            }
        }
        this.hotDeploy = hotDeploy;
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public int getRetryInitInterval() {
        return this.retryInitInterval;
    }

    @MCAttribute
    public void setRetryInitInterval(int retryInitInterval) {
        this.retryInitInterval = retryInitInterval;
    }

    private ArrayList<Proxy> getInactiveRules() {
        ArrayList<Proxy> inactive = new ArrayList<Proxy>();
        for (Proxy proxy : this.getRuleManager().getRules()) {
            if (proxy.isActive()) continue;
            inactive.add(proxy);
        }
        return inactive;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public ApplicationContext getBeanFactory() {
        return this.beanFactory;
    }

    public boolean isRetryInit() {
        return this.retryInit;
    }

    @MCAttribute
    public void setRetryInit(boolean retryInit) {
        this.retryInit = retryInit;
    }

    public URIFactory getUriFactory() {
        return this.uriFactory;
    }

    @MCChildElement(order=-1, allowForeign=true)
    public void setUriFactory(URIFactory uriFactory) {
        this.uriFactory = uriFactory;
    }

    public boolean isProduction() {
        return this.production;
    }

    @MCAttribute
    public void setProduction(boolean production) {
        this.production = production;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    @MCAttribute
    public void setJmx(String name) {
        this.jmxRouterName = name;
    }

    public String getJmx() {
        return this.jmxRouterName;
    }

    public void setBeanName(String s) {
        this.id = s;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.isRunning()) {
                this.lock.wait();
            }
        }
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public KubernetesClientFactory getKubernetesClientFactory() {
        return this.kubernetesClientFactory;
    }

    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public FlowController getFlowController() {
        return this.flowController;
    }
}

