/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.model.IExchangesStoreListener;
import com.predic8.membrane.core.model.IRuleChangeListener;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.proxies.InternalProxy;
import com.predic8.membrane.core.proxies.NotPortOpeningProxy;
import com.predic8.membrane.core.proxies.NullProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.ProxyRule;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.IpPort;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContextCollection;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.URIUtil;
import com.predic8.membrane.core.util.URLUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private static final Logger log = LoggerFactory.getLogger((String)RuleManager.class.getName());
    private Router router;
    protected final List<Proxy> proxies = new Vector<Proxy>();
    private final List<RuleDefinitionSource> ruleSources = new ArrayList<RuleDefinitionSource>();
    private final Set<IRuleChangeListener> listeners = new HashSet<IRuleChangeListener>();

    public boolean isAnyRuleWithPort(int port) {
        for (Proxy proxy : this.proxies) {
            if (proxy.getKey().getPort() != port) continue;
            return true;
        }
        return false;
    }

    public void addProxyAndOpenPortIfNew(SSLableProxy proxy) throws IOException {
        this.addProxyAndOpenPortIfNew(proxy, RuleDefinitionSource.MANUAL);
    }

    public synchronized void addProxyAndOpenPortIfNew(SSLableProxy proxy, RuleDefinitionSource source) throws IOException {
        if (this.exists(proxy.getKey())) {
            return;
        }
        this.router.getTransport().openPort(proxy, this.router.getTimerManager());
        this.proxies.add(proxy);
        this.ruleSources.add(source);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(proxy);
        }
    }

    public synchronized void addProxy(Proxy proxy, RuleDefinitionSource source) {
        if (this.exists(proxy.getKey())) {
            return;
        }
        this.proxies.add(proxy);
        this.ruleSources.add(source);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(proxy);
        }
    }

    public synchronized void openPorts() throws IOException {
        HashMap<IpPort, SSLProvider> sslProviders = this.getSslProviders();
        for (Proxy proxy : this.proxies) {
            if (proxy instanceof NotPortOpeningProxy) continue;
            this.router.getTransport().openPort(proxy.getKey().getIp(), proxy.getKey().getPort(), sslProviders.get(RuleManager.getIpPort(proxy)), this.router.getTimerManager());
        }
    }

    @NotNull
    private static IpPort getIpPort(Proxy proxy) throws UnknownHostException {
        return new IpPort(proxy.getKey().getIp(), proxy.getKey().getPort());
    }

    @NotNull
    private HashMap<IpPort, SSLProvider> getSslProviders() throws UnknownHostException {
        HashMap<IpPort, SSLProvider> p = new HashMap<IpPort, SSLProvider>();
        for (Map.Entry<IpPort, SSLContextCollection.Builder> e : this.getSSLContexts().entrySet()) {
            p.put(e.getKey(), e.getValue().build());
        }
        return p;
    }

    @NotNull
    private HashMap<IpPort, SSLContextCollection.Builder> getSSLContexts() throws UnknownHostException {
        HashMap<IpPort, SSLContextCollection.Builder> sslContexts = new HashMap<IpPort, SSLContextCollection.Builder>();
        for (Proxy proxy : this.proxies) {
            SSLableProxy sp;
            SSLContext sslContext;
            if (!(proxy instanceof SSLableProxy) || (sslContext = (sp = (SSLableProxy)proxy).getSslInboundContext()) == null) continue;
            IpPort ipPort = RuleManager.getIpPort(sp);
            SSLContextCollection.Builder builder = sslContexts.get(ipPort);
            if (builder == null) {
                builder = new SSLContextCollection.Builder();
                sslContexts.put(ipPort, builder);
            }
            builder.add(sslContext);
        }
        return sslContexts;
    }

    public boolean exists(RuleKey key) {
        return this.getRule(key) != null;
    }

    private Proxy getRule(RuleKey key) {
        for (Proxy r : this.proxies) {
            if (!r.getKey().equals(key)) continue;
            return r;
        }
        return null;
    }

    public List<Proxy> getRules() {
        return this.proxies;
    }

    public void ruleChanged(Proxy proxy) {
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleUpdated(proxy);
        }
        this.getExchangeStore().refreshExchangeStoreListeners();
    }

    public Proxy getMatchingRule(Exchange exc) {
        Request request = exc.getRequest();
        String hostHeader = request.getHeader().getHost();
        String method = request.getMethod();
        String uri = URIUtil.normalizeSingleDot(request.getUri());
        String version = request.getVersion();
        AbstractHttpHandler handler = exc.getHandler();
        int port = RuleManager.getPort(handler);
        String localIP = RuleManager.getLocalIP(handler);
        for (Proxy proxy : this.proxies) {
            RuleKey key = proxy.getKey();
            log.debug("Host from rule: {} Host from parameter rule key: {}", (Object)key.getHost(), (Object)hostHeader);
            if (!proxy.isActive() || !key.matchesVersion(version) || key.getIp() != null && !key.getIp().equals(localIP) || !key.matchesHostHeader(hostHeader)) continue;
            if (proxy instanceof NotPortOpeningProxy) {
                if (exc.getDestinations().isEmpty()) continue;
                String serviceName = URLUtil.getHost(exc.getDestinations().getFirst());
                if (!proxy.getName().equals(serviceName)) continue;
            }
            if (!(proxy instanceof InternalProxy) && key.getPort() != -1 && port != -1 && key.getPort() != port || !key.getMethod().equals(method) && !key.isMethodWildcard() || key.isUsePathPattern() && !key.matchesPath(uri) || !key.complexMatch(exc)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Matching Rule {} found for RuleKey {} {} {} {} {}", new Object[]{proxy, hostHeader, method, uri, port, localIP});
            }
            return proxy;
        }
        return this.findProxyRule(exc);
    }

    private static String getTestExpression(Proxy proxy) {
        if (proxy instanceof APIProxy) {
            APIProxy ap = (APIProxy)proxy;
            return ap.getTest();
        }
        return "\u00b4unknown\u00b4";
    }

    private static String getLocalIP(AbstractHttpHandler handler) {
        if (handler == null) {
            return null;
        }
        return handler.getLocalAddress().getHostAddress();
    }

    private static int getPort(AbstractHttpHandler handler) {
        if (handler == null) {
            return -1;
        }
        return handler.isMatchLocalPort() ? handler.getLocalPort() : -1;
    }

    private Proxy findProxyRule(Exchange exc) {
        for (Proxy proxy : this.getRules()) {
            if (!(proxy instanceof ProxyRule) || proxy.getKey().getIp() != null && !proxy.getKey().getIp().equals(exc.getHandler().getLocalAddress().toString()) || exc.getHandler() == null || proxy.getKey().getPort() != -1 && exc.getHandler().getLocalPort() != -1 && proxy.getKey().getPort() != exc.getHandler().getLocalPort()) continue;
            if (log.isDebugEnabled()) {
                log.debug("proxy rule found: {}", (Object)proxy);
            }
            return proxy;
        }
        log.debug("No rule found for incoming request");
        return new NullProxy();
    }

    public void addRuleChangeListener(IRuleChangeListener viewer) {
        this.listeners.add(viewer);
        viewer.batchUpdate(this.proxies.size());
    }

    public void removeRuleChangeListener(IRuleChangeListener viewer) {
        this.listeners.remove(viewer);
    }

    public void addExchangesStoreListener(IExchangesStoreListener viewer) {
        this.getExchangeStore().addExchangesStoreListener(viewer);
    }

    public void removeExchangesStoreListener(IExchangesStoreListener viewer) {
        this.getExchangeStore().removeExchangesStoreListener(viewer);
    }

    public synchronized void removeRule(Proxy proxy) {
        this.getExchangeStore().removeAllExchanges(proxy);
        int i = this.proxies.indexOf(proxy);
        this.proxies.remove(i);
        this.ruleSources.remove(i);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleRemoved(proxy, this.proxies.size());
        }
    }

    public synchronized void replaceRule(Proxy proxy, Proxy newProxy) {
        this.getExchangeStore().removeAllExchanges(proxy);
        int i = this.proxies.indexOf(proxy);
        this.proxies.set(i, newProxy);
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleRemoved(proxy, this.proxies.size());
        }
        for (IRuleChangeListener listener : this.listeners) {
            listener.ruleAdded(newProxy);
        }
    }

    public synchronized void removeAllRules() {
        while (!this.proxies.isEmpty()) {
            this.removeRule(this.proxies.getFirst());
        }
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    private ExchangeStore getExchangeStore() {
        return this.router.getExchangeStore();
    }

    public <T extends Proxy> T getRuleByName(String name, Class<T> type) {
        for (Proxy r : this.proxies) {
            if (!name.equals(r.getName())) continue;
            return (T)((Proxy)type.cast(r));
        }
        return null;
    }

    public synchronized List<Proxy> getRulesBySource(final RuleDefinitionSource source) {
        return new ArrayList<Proxy>(){
            private static final long serialVersionUID = 1L;
            {
                for (int i = 0; i < RuleManager.this.proxies.size(); ++i) {
                    if (RuleManager.this.ruleSources.get(i) != source) continue;
                    this.add(RuleManager.this.proxies.get(i));
                }
            }

            @Override
            public Proxy set(int index, Proxy element) {
                throw new IllegalStateException("set(int, Rule) is not allowed");
            }

            @Override
            public boolean add(Proxy e) {
                RuleManager.this.addProxy(e, source);
                return super.add(e);
            }

            @Override
            public void add(int index, Proxy e) {
                RuleManager.this.addProxy(e, source);
                super.add(index, e);
            }
        };
    }

    public static enum RuleDefinitionSource {
        SPRING,
        MANUAL;

    }
}

