/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.azure.api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.azure.AzureIdentity;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationApi {
    private final HttpClient http;
    private final AzureIdentity config;
    private final Map<String, String> tokenPayload;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationApi.class);

    public AuthenticationApi(HttpClient http, @Nullable AzureIdentity config) {
        this.http = http;
        this.config = config;
        if (config == null) {
            this.tokenPayload = Map.of();
            return;
        }
        this.tokenPayload = Map.of("grant_type", config.getGrantType(), "client_id", config.getClientId(), "client_secret", config.getClientSecret(), "resource", config.getResource());
    }

    public String accessToken() throws Exception {
        Exchange exc = this.tokenExchange();
        String responseBody = this.http.call(exc).getResponse().getBodyAsStringDecoded();
        try {
            return new ObjectMapper().readTree(responseBody).get("access_token").asText();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            log.debug(exc.getRequest().toString());
            log.debug(exc.getResponse().getHeader().toString());
            log.debug(responseBody);
            return "";
        }
    }

    private Exchange tokenExchange() throws URISyntaxException {
        String tenantId = this.config.getTenantId();
        return new Request.Builder().post("https://login.microsoftonline.com/" + tenantId + "/oauth2/token").body(this.tokenPayload.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"))).buildExchange();
    }
}

