/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.azure.api.dns;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.azure.api.dns.DnsRecordApi;
import com.predic8.membrane.core.azure.api.dns.DnsRecordType;
import com.predic8.membrane.core.azure.api.dns.SupportedDnsRecordType;
import com.predic8.membrane.core.azure.api.dns.TxtRecordBuilder;
import com.predic8.membrane.core.http.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DnsRecordCommandExecutor {
    private final DnsRecordApi api;
    private final String basePath;
    private int ttl = 3600;
    private final List<SupportedDnsRecordType> records = new ArrayList<SupportedDnsRecordType>();

    public DnsRecordCommandExecutor(DnsRecordApi api, String recordSetName, DnsRecordType type) {
        this.api = api;
        String resourceBasePath = String.format("%s/subscriptions/%s/resourceGroups/%s/providers", api.config().getResource(), api.config().getSubscriptionId(), api.config().getResourceGroup());
        this.basePath = String.format("%s/Microsoft.Network/dnsZones/%s/%s/%s?api-version=2018-05-01", resourceBasePath, api.config().getDnsZoneName(), type.toString(), recordSetName);
    }

    public DnsRecordCommandExecutor ttl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public JsonNode create() throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>(Map.of("TTL", this.ttl));
        this.records.forEach(record -> properties.putAll(record.payload()));
        Map<String, HashMap<String, Integer>> payload = Map.of("properties", properties);
        Response response = this.api.http().call(this.api.requestBuilder().put(this.basePath).contentType("application/json").body(new ObjectMapper().writeValueAsString(payload)).buildExchange()).getResponse();
        return new ObjectMapper().readTree(response.getBodyAsStringDecoded());
    }

    public TxtRecordBuilder addRecord() {
        TxtRecordBuilder builder = new TxtRecordBuilder(this);
        this.records.add(builder);
        return builder;
    }

    public void delete() throws Exception {
        this.api.http().call(this.api.requestBuilder().delete(this.basePath).header("Accept", "application/json").buildExchange());
    }
}

