/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.azure.api.tablestorage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.azure.api.tablestorage.TableStorageApi;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class TableEntityCommandExecutor {
    private final TableStorageApi api;
    private final String path;
    private final String queryPath;

    public TableEntityCommandExecutor(TableStorageApi api, String rowKey) {
        this.api = api;
        this.path = TableEntityCommandExecutor.createPath(api, rowKey);
        this.queryPath = TableEntityCommandExecutor.createQueryPath(api);
    }

    @NotNull
    private static String createQueryPath(TableStorageApi api) {
        return api.config().getCustomHost() == null ? TableEntityCommandExecutor.createTableAddressWithStorageAccount(api) : TableEntityCommandExecutor.createAddressWithHost(api);
    }

    @NotNull
    private static String createAddressWithHost(TableStorageApi api) {
        return String.format("%s/%s", api.config().getCustomHost(), api.config().getTableName());
    }

    @NotNull
    private static String createTableAddressWithStorageAccount(TableStorageApi api) {
        return String.format("https://%s.table.core.windows.net/%s", api.config().getStorageAccountName(), api.config().getTableName());
    }

    @NotNull
    private static String createPath(TableStorageApi api, String rowKey) {
        return api.config().getCustomHost() == null ? TableEntityCommandExecutor.createTableStorageUri(api, rowKey) : TableEntityCommandExecutor.createTableStorageUri2(api, rowKey);
    }

    @NotNull
    private static String createTableStorageUri2(TableStorageApi api, String rowKey) {
        return String.format("%s/%s%s", api.config().getCustomHost(), api.config().getTableName(), TableEntityCommandExecutor.buildUriBracketParams(api, rowKey));
    }

    @NotNull
    private static String createTableStorageUri(TableStorageApi api, String rowKey) {
        return String.format("https://%s.table.core.windows.net/%s%s", api.config().getStorageAccountName(), api.config().getTableName(), TableEntityCommandExecutor.buildUriBracketParams(api, rowKey));
    }

    private static String buildUriBracketParams(TableStorageApi api, String rowKey) {
        return URLEncoder.encode("(PartitionKey='%s'%s)".formatted(api.config().getPartitionKey(), TableEntityCommandExecutor.rowKey(rowKey)), StandardCharsets.UTF_8);
    }

    private static String rowKey(String rowKey) {
        return rowKey != null ? ",RowKey='%s'".formatted(rowKey) : "";
    }

    public JsonNode get() throws Exception {
        try (HttpClient hc = this.api.http();){
            Response res = hc.call(this.api.requestBuilder(this.path).get(this.path).buildExchange()).getResponse();
            JsonNode response = new ObjectMapper().readTree(res.getBodyAsStringDecoded());
            if (response.has("odata.error")) {
                throw new NoSuchElementException(res.getBodyAsStringDecoded());
            }
            JsonNode jsonNode = response;
            return jsonNode;
        }
    }

    public void insertOrReplace(String data) throws Exception {
        try (HttpClient hc = this.api.http();){
            Exchange exc = hc.call(this.api.requestBuilder(this.path).put(this.path).body(new ObjectMapper().writeValueAsString(Map.of("data", data))).buildExchange());
            if (exc.getResponse().getStatusCode() != 204) {
                throw new RuntimeException(exc.getResponse().toString());
            }
        }
    }

    public void delete() throws Exception {
        try (HttpClient hc = this.api.http();){
            Exchange exc = hc.call(this.api.requestBuilder(this.path).delete(this.path).header("If-Match", "*").buildExchange());
            if (exc.getResponse().getStatusCode() != 204) {
                throw new RuntimeException(exc.getResponse().toString());
            }
        }
    }

    public Iterator<JsonNode> query() {
        return new TableEntityIterator();
    }

    class TableEntityIterator
    implements Iterator<JsonNode> {
        private Iterator<JsonNode> internalPageIterator;
        private Exchange exc;

        TableEntityIterator() {
            try {
                this.exc = TableEntityCommandExecutor.this.api.requestBuilder(TableEntityCommandExecutor.this.queryPath + URLEncoder.encode("()", StandardCharsets.UTF_8)).get(TableEntityCommandExecutor.this.queryPath + URLEncoder.encode("()", StandardCharsets.UTF_8)).buildExchange();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.preparePageForIteration();
        }

        private void preparePageForIteration() {
            JsonNode r;
            Response res;
            try (HttpClient hc = TableEntityCommandExecutor.this.api.http();){
                res = hc.call(this.exc).getResponse();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (res.getStatusCode() != 200) {
                throw new RuntimeException("API returned status code != 200:" + String.valueOf(res));
            }
            try {
                r = new ObjectMapper().readTree(res.getBodyAsStreamDecoded());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (r.has("odata.error")) {
                throw new RuntimeException("API returned error: " + String.valueOf(r));
            }
            if (!r.has("value")) {
                this.internalPageIterator = null;
                return;
            }
            this.internalPageIterator = r.get("value").iterator();
        }

        private boolean flipPage() {
            String npk = this.getXmsContinuationNextPartitionKey();
            String nrk = this.getXmsContinuationNextRowKey();
            if (npk == null || nrk == null) {
                return false;
            }
            try {
                this.exc = TableEntityCommandExecutor.this.api.requestBuilder(TableEntityCommandExecutor.this.queryPath).get(this.getPath(npk, nrk)).buildExchange();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.preparePageForIteration();
            return true;
        }

        @NotNull
        private String getPath(String npk, String nrk) {
            return TableEntityCommandExecutor.this.queryPath + "?NextPartitionKey=" + npk + "&NextRowKey=" + nrk;
        }

        private String getXmsContinuationNextRowKey() {
            return this.exc.getResponse().getHeader().getFirstValue("x-ms-continuation-NextRowKey");
        }

        private String getXmsContinuationNextPartitionKey() {
            return this.exc.getResponse().getHeader().getFirstValue("x-ms-continuation-NextPartitionKey");
        }

        @Override
        public boolean hasNext() {
            if (this.internalPageIterator == null) {
                return false;
            }
            if (this.internalPageIterator.hasNext()) {
                return true;
            }
            if (!this.flipPage()) {
                return false;
            }
            return this.hasNext();
        }

        @Override
        public JsonNode next() {
            JsonNode result = this.internalPageIterator.next();
            if (result != null) {
                return result;
            }
            if (!this.flipPage()) {
                return null;
            }
            return this.internalPageIterator.next();
        }
    }
}

