/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.azure.api.tablestorage;

import com.predic8.membrane.core.azure.AzureTableStorage;
import com.predic8.membrane.core.azure.api.AzureApiClient;
import com.predic8.membrane.core.azure.api.HttpClientConfigurable;
import com.predic8.membrane.core.azure.api.tablestorage.TableEntityCommandExecutor;
import com.predic8.membrane.core.azure.api.tablestorage.TableStorageCommandExecutor;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.Nullable;

public class TableStorageApi
implements HttpClientConfigurable<AzureTableStorage> {
    public static final String ALGO = "HmacSHA256";
    private final AzureApiClient apiClient;
    private final AzureTableStorage config;

    public TableStorageApi(AzureApiClient apiClient, AzureTableStorage config) {
        this.apiClient = apiClient;
        this.config = config;
    }

    public TableStorageCommandExecutor table() {
        return new TableStorageCommandExecutor(this);
    }

    public TableEntityCommandExecutor entity(String rowKey) {
        return new TableEntityCommandExecutor(this, rowKey);
    }

    @Override
    public HttpClient http() {
        return this.apiClient.httpClient();
    }

    @Override
    public AzureTableStorage config() {
        return this.config;
    }

    protected Request.Builder requestBuilder(@javax.annotation.Nullable String announceUrl) {
        String date = this.now();
        return new Request.Builder().contentType("application/json").header("Date", date).header("x-ms-version", "2020-12-06").header("Accept", "application/json").header("DataServiceVersion", "3.0;NetFx").header("MaxDataServiceVersion", "3.0;NetFx").header("Authorization", String.format("SharedKeyLite %s:%s", this.config.getStorageAccountName(), this.getSign(announceUrl, date)));
    }

    private String getSign(@Nullable String announceUrl, String date) {
        return this.sign(this.config.getStorageAccountKey(), this.buildStringToSign(date, announceUrl));
    }

    private String now() {
        return DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT")).format(Instant.now());
    }

    private String buildStringToSign(String date, @javax.annotation.Nullable String url) {
        String base = String.format("%s\n/%s", date, this.config.getStorageAccountName());
        if (url == null) {
            return base + "/Tables";
        }
        return base + url.substring(url.lastIndexOf("/" + this.config.getTableName()));
    }

    private String sign(String base64Key, String stringToSign) {
        try {
            Mac hmacSHA256 = Mac.getInstance(ALGO);
            hmacSHA256.init(new SecretKeySpec(Base64.getDecoder().decode(base64Key), ALGO));
            return Base64.getEncoder().encodeToString(hmacSHA256.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

