/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.azure.api.tablestorage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.azure.api.tablestorage.TableStorageApi;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import java.util.Map;

public class TableStorageCommandExecutor {
    private final TableStorageApi api;
    private final String path;

    public TableStorageCommandExecutor(TableStorageApi api) {
        this.api = api;
        this.path = api.config().getCustomHost() == null ? String.format("https://%s.table.core.windows.net/Tables", api.config().getStorageAccountName()) : api.config().getCustomHost() + "/Tables";
    }

    public void create() throws Exception {
        boolean isExisting;
        Map<String, String> payload = Map.of("TableName", this.api.config().getTableName());
        Exchange exc = this.api.http().call(this.api.requestBuilder(null).post(this.path).body(new ObjectMapper().writeValueAsString(payload)).buildExchange());
        Response response = exc.getResponse();
        boolean isCreated = response.getStatusCode() == 201;
        boolean bl = isExisting = response.getStatusCode() == 409;
        if (!isCreated && !isExisting) {
            throw new RuntimeException(exc.getResponse().toString());
        }
    }
}

