/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cli;

import com.predic8.membrane.core.cli.MissingRequiredOptionException;
import com.predic8.membrane.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class CliCommand {
    private final String name;
    private final String description;
    private final List<Pair<String, String>> examples;
    private final Map<String, CliCommand> subcommands;
    private Options options;
    private CliCommand parent;
    private CommandLine commandLine;

    public CliCommand(String name, String description) {
        this.name = name;
        this.description = description;
        this.subcommands = new LinkedHashMap<String, CliCommand>();
        this.options = new Options();
        this.examples = new ArrayList<Pair<String, String>>();
    }

    public CliCommand addSubcommand(CliCommand command) {
        this.subcommands.put(command.getName(), command);
        command.parent = this;
        return this;
    }

    public CliCommand addOption(Option option) {
        this.options.addOption(option);
        return this;
    }

    public CliCommand addExample(String exampleDescription, String exampleCommand) {
        this.examples.add(new Pair<String, String>(exampleDescription, exampleCommand));
        return this;
    }

    public CliCommand parse(String[] args) throws ParseException {
        if (CliCommand.isCommand(args)) {
            String cmd = args[0];
            if (this.hasSubcommand(cmd)) {
                return this.subcommands.get(cmd).parse(Arrays.copyOfRange(args, 1, args.length));
            }
            throw new ParseException("Unknown command: " + cmd);
        }
        try {
            this.commandLine = new DefaultParser().parse(this.options, args, true);
        }
        catch (MissingOptionException e) {
            throw new MissingRequiredOptionException(e.getMessage(), this);
        }
        return this;
    }

    private static boolean isCommand(String[] args) {
        return args.length > 0 && !args[0].startsWith("-");
    }

    private boolean hasSubcommand(String cmd) {
        return this.subcommands.containsKey(cmd);
    }

    String getCommandPath() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getCommandPath() + " " + this.name;
    }

    public void printHelp() {
        new HelpFormatter().printHelp(this.getUsageHelp(), this.getCommandHelp(), this.options, this.getExamplesHelp());
    }

    @NotNull
    private String getUsageHelp() {
        StringBuilder usage = new StringBuilder(this.getCommandPath());
        if (!this.subcommands.isEmpty()) {
            usage.append(" <command>");
        }
        if (!this.options.getOptions().isEmpty()) {
            usage.append(" [options]\n\n");
        }
        return usage.toString();
    }

    @NotNull
    private String getExamplesHelp() {
        StringBuilder examples = new StringBuilder();
        if (!this.examples.isEmpty()) {
            examples.append("\nExamples:\n");
            this.examples.forEach(example -> examples.append(" ").append((String)example.first()).append("\n    ").append((String)example.second()).append("\n"));
        }
        return examples.toString();
    }

    @NotNull
    private String getCommandHelp() {
        StringBuilder commands = new StringBuilder();
        if (!this.subcommands.isEmpty()) {
            commands.append("Commands:\n");
            this.subcommands.forEach((cmd, ns) -> commands.append(" ").append((String)cmd).append(" - ").append(ns.getDescription()).append("\n"));
            commands.append("\n");
        }
        if (!this.options.getOptions().isEmpty()) {
            commands.append("Options:\n");
        }
        return commands.toString();
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean isOptionSet(String opt) {
        return this.commandLine != null && this.commandLine.hasOption(opt);
    }

    public String getOptionValue(String opt) {
        return this.commandLine != null ? this.commandLine.getOptionValue(opt) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

