/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cli;

import com.predic8.membrane.core.cli.CliCommand;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class MembraneCommandLine {
    private final CliCommand rootNamespace = MembraneCommandLine.getRootNamespace(MembraneCommandLine.getRootOptions());
    private CliCommand currentNamespace;

    private static Options getRootOptions() {
        return new Options().addOption(Option.builder((String)"h").longOpt("help").desc("Display this text").build()).addOption(Option.builder((String)"c").longOpt("config").argName("proxies.xml location").hasArg().desc("Location of the proxies configuration file").build()).addOption(Option.builder((String)"t").longOpt("test").argName("proxies.xml location").hasArg().desc("Verifies configuration file and terminates").build());
    }

    @NotNull
    private static CliCommand getRootNamespace(final Options rootOptions) {
        return new CliCommand("membrane.sh", "Membrane Service Proxy"){
            {
                super(name, description);
                this.setOptions(rootOptions);
                this.addExample("Start gateway configured from OpenAPI file", "membrane.sh oas -l conf/fruitshop-api.yml").addExample("Start gateway configured from OpenAPI URL and validate requests", "membrane.sh oas -v -l https://api.predic8.de/shop/v2/api-docs");
                this.addSubcommand(new CliCommand("start", " (Default) Same function as command omitted. Start gateway with configuration from proxies.xml"){
                    {
                        super(name, description);
                        this.setOptions(rootOptions);
                    }
                });
                this.addSubcommand(new CliCommand(this, "oas", "Use a single OpenAPI document to configure and start gateway"){
                    {
                        this.addOption(Option.builder((String)"h").longOpt("help").desc("Display this text").build()).addOption(Option.builder((String)"l").longOpt("location").argName("OpenAPI location").hasArg().required().desc("(Required) Set URL or path to an OpenAPI document").build()).addOption(Option.builder((String)"p").longOpt("port").argName("API port").hasArg().desc("Listen port").build()).addOption(Option.builder((String)"v").longOpt("validate-requests").desc("Validate requests against OpenAPI").build()).addOption(Option.builder((String)"V").longOpt("validate-responses").desc("Validate responses against OpenAPI").build());
                    }
                });
            }
        };
    }

    public void parse(String[] args) throws ParseException {
        this.currentNamespace = this.rootNamespace.parse(args);
    }

    public CliCommand getRootNamespace() {
        return this.rootNamespace;
    }

    public CliCommand getCommand() {
        return this.currentNamespace;
    }

    public boolean noCommand() {
        return this.currentNamespace == this.rootNamespace;
    }
}

