/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cli;

import com.predic8.membrane.core.HttpRouter;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.cli.MembraneCommandLine;
import com.predic8.membrane.core.cli.MissingRequiredOptionException;
import com.predic8.membrane.core.config.spring.CheckableBeanFactory;
import com.predic8.membrane.core.config.spring.TrackingFileSystemXmlApplicationContext;
import com.predic8.membrane.core.exceptions.SpringConfigurationErrorHandler;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPISpec;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.ExceptionUtil;
import com.predic8.membrane.core.util.OSUtil;
import com.predic8.membrane.core.util.URIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;

public class RouterCLI {
    private static final Logger log = LoggerFactory.getLogger(RouterCLI.class);

    public static void main(String[] args) {
        MembraneCommandLine commandLine = RouterCLI.getMembraneCommandLine(args);
        if (commandLine.getCommand().isOptionSet("h")) {
            commandLine.getCommand().printHelp();
            System.exit(0);
        }
        if (commandLine.noCommand() && commandLine.getCommand().isOptionSet("t")) {
            System.exit(0);
        }
        try {
            RouterCLI.getRouter(commandLine).waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    private static Router getRouter(MembraneCommandLine commandLine) {
        try {
            if (commandLine.getCommand().getName().equals("oas")) {
                return RouterCLI.initRouterByOpenApiSpec(commandLine);
            }
            return RouterCLI.initRouterByConfig(commandLine);
        }
        catch (CheckableBeanFactory.InvalidConfigurationException e) {
            log.error("Fatal error: {}", (Object)ExceptionUtil.concatMessageAndCauseMessages(e));
        }
        catch (Exception ex) {
            SpringConfigurationErrorHandler.handleRootCause(ex, log);
        }
        System.exit(1);
        return null;
    }

    private static Router initRouterByOpenApiSpec(MembraneCommandLine commandLine) throws Exception {
        HttpRouter router = new HttpRouter();
        router.getRuleManager().addProxyAndOpenPortIfNew(RouterCLI.getApiProxy(commandLine));
        router.init();
        return router;
    }

    @NotNull
    private static APIProxy getApiProxy(MembraneCommandLine commandLine) {
        APIProxy api = new APIProxy();
        api.setPort(commandLine.getCommand().isOptionSet("p") ? Integer.parseInt(commandLine.getCommand().getOptionValue("p")) : 2000);
        api.setSpecs(List.of(RouterCLI.getOpenAPISpec(commandLine)));
        return api;
    }

    @NotNull
    private static OpenAPISpec getOpenAPISpec(MembraneCommandLine commandLine) {
        OpenAPISpec spec = new OpenAPISpec();
        spec.location = commandLine.getCommand().getOptionValue("l");
        if (commandLine.getCommand().isOptionSet("v")) {
            spec.setValidateRequests(OpenAPISpec.YesNoOpenAPIOption.YES);
        }
        if (commandLine.getCommand().isOptionSet("V")) {
            spec.setValidateResponses(OpenAPISpec.YesNoOpenAPIOption.YES);
        }
        return spec;
    }

    private static Router initRouterByConfig(MembraneCommandLine commandLine) throws Exception {
        try {
            return Router.init(RouterCLI.getRulesFile(commandLine));
        }
        catch (XmlBeanDefinitionStoreException e) {
            TrackingFileSystemXmlApplicationContext.handleXmlBeanDefinitionStoreException(e);
            throw new RuntimeException("Router could not be initialized");
        }
    }

    private static MembraneCommandLine getMembraneCommandLine(String[] args) {
        MembraneCommandLine cl = new MembraneCommandLine();
        try {
            cl.parse(args);
        }
        catch (MissingRequiredOptionException e) {
            e.getCommand().printHelp();
            System.exit(1);
        }
        catch (ParseException e) {
            System.err.println("Error parsing commandline " + e.getMessage());
            cl.getRootNamespace().printHelp();
            System.exit(1);
        }
        return cl;
    }

    private static String getRulesFile(MembraneCommandLine cl) throws IOException {
        ResolverMap rm = new ResolverMap();
        if (RouterCLI.hasConfiguration(cl)) {
            String filename = OSUtil.fixBackslashes(RouterCLI.getConfiguration(cl));
            if (RouterCLI.shouldResolveFile(filename)) {
                String string;
                block10: {
                    InputStream ignored = rm.resolve(filename);
                    try {
                        string = filename;
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ResourceRetrievalException e) {
                            System.err.println("Could not open Membrane's configuration file: " + filename + " not found.");
                            System.exit(1);
                        }
                    }
                    ignored.close();
                }
                return string;
            }
            return RouterCLI.getRulesFileFromRelativeSpec(rm, filename, "");
        }
        return RouterCLI.getRulesFileFromRelativeSpec(rm, "conf/proxies.xml", RouterCLI.getErrorNotice());
    }

    private static String getConfiguration(MembraneCommandLine cl) {
        return cl.getCommand().isOptionSet("c") ? cl.getCommand().getOptionValue("c") : cl.getCommand().getOptionValue("t");
    }

    private static boolean hasConfiguration(MembraneCommandLine cl) {
        return cl.getCommand().isOptionSet("c") || cl.getCommand().isOptionSet("t");
    }

    private static String getErrorNotice() {
        String errorNotice = "Please specify the location of Membrane's proxies.xml configuration file using the -c command line option.";
        if (System.getenv("MEMBRANE_HOME") != null) {
            return errorNotice + " Or create the file in MEMBRANE_HOME/conf (" + System.getenv("MEMBRANE_HOME") + "/conf/proxies.xml).";
        }
        return errorNotice + "You can also point the MEMBRANE_HOME environment variable to Membrane's distribution root directory\nand ensure that MEMBRANE_HOME/conf/proxies.xml exists.\n";
    }

    private static boolean shouldResolveFile(String s) {
        return s.startsWith("file:") || s.startsWith("/") || s.length() > 3 && s.startsWith(":/", 1);
    }

    private static String getRulesFileFromRelativeSpec(ResolverMap rm, String relativeFile, String errorNotice) {
        String string;
        block17: {
            String try1 = URIUtil.pathFromFileURI(ResolverMap.combine(RouterCLI.prefix(RouterCLI.getUserDir()), relativeFile));
            InputStream ignored = rm.resolve(try1);
            try {
                string = try1;
                if (ignored == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Could not resolve path to configuration (attempt 1).", (Throwable)e);
                    String try2 = null;
                    if (System.getenv("MEMBRANE_HOME") != null) {
                        String string2;
                        block18: {
                            try2 = URIUtil.pathFromFileURI(ResolverMap.combine(RouterCLI.prefix(System.getenv("MEMBRANE_HOME")), relativeFile));
                            InputStream ignored2 = rm.resolve(try2);
                            try {
                                string2 = try2;
                                if (ignored2 == null) break block18;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    if (ignored2 != null) {
                                        try {
                                            ignored2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                    }
                                    throw throwable3;
                                }
                                catch (Exception e2) {
                                    log.error("Could not resolve path to configuration (attempt 2).", (Throwable)e2);
                                }
                            }
                            ignored2.close();
                        }
                        return string2;
                    }
                    System.err.println("Could not find Membrane's configuration file at " + try1 + (String)(try2 == null ? "" : " and not at " + try2) + " . " + errorNotice);
                    System.exit(1);
                    throw new RuntimeException();
                }
            }
            ignored.close();
        }
        return string;
    }

    public static String getUserDir() {
        String userDir = OSUtil.fixBackslashes(System.getProperty("user.dir"));
        if (!userDir.endsWith("/")) {
            return userDir + "/";
        }
        return userDir;
    }

    private static String prefix(String dir) {
        File file = new File(dir);
        if (file.isAbsolute()) {
            return file.toURI().toString();
        }
        return dir;
    }
}

