/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.security;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.IOException;
import java.util.Objects;

public abstract class Blob {
    String content;
    String location;

    public boolean equals(Object obj) {
        if (!(obj instanceof Blob)) {
            return false;
        }
        Blob other = (Blob)obj;
        return com.google.common.base.Objects.equal((Object)this.content, (Object)other.content) && com.google.common.base.Objects.equal((Object)this.location, (Object)other.location);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.location);
    }

    public String getContent() {
        return this.content;
    }

    @MCTextContent
    public void setContent(String content) {
        this.content = content;
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    public String get(ResolverMap resolverMap, String baseLocation) throws IOException {
        if (this.getLocation() != null) {
            if (this.getContent() != null && !this.getContent().isEmpty()) {
                throw new IllegalStateException("On <" + this.getName() + ">, ./text() and ./@location cannot be set at the same time.");
            }
            return new String(ByteUtil.getByteArrayData(resolverMap.resolve(ResolverMap.combine(baseLocation, this.getLocation()))));
        }
        if (this.getContent() == null) {
            throw new IllegalStateException("On <" + this.getName() + ">, either ./text() or ./@location must be set.");
        }
        return this.getContent();
    }

    private String getName() {
        return this.getClass().getAnnotation(MCElement.class).name();
    }
}

