/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.security;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.security.Key;
import com.predic8.membrane.core.config.security.KeyGenerator;
import com.predic8.membrane.core.config.security.KeyStore;
import com.predic8.membrane.core.config.security.Trust;
import com.predic8.membrane.core.config.security.TrustStore;
import com.predic8.membrane.core.config.security.acme.Acme;
import java.util.Objects;

@MCElement(name="ssl")
public class SSLParser {
    private Acme acme;
    private KeyStore keyStore;
    private Key key;
    private KeyGenerator keyGenerator;
    private TrustStore trustStore;
    private Trust trust;
    private String algorithm;
    private String protocol;
    private String protocols;
    private String ciphers;
    private String clientAuth;
    private boolean ignoreTimestampCheckFailure;
    private String endpointIdentificationAlgorithm = "HTTPS";
    private String serverName;
    private boolean showSSLExceptions = true;
    private boolean useAsDefault = true;
    private boolean useExperimentalHttp2;

    public boolean equals(Object obj) {
        if (!(obj instanceof SSLParser)) {
            return false;
        }
        SSLParser other = (SSLParser)obj;
        return com.google.common.base.Objects.equal((Object)this.acme, (Object)other.acme) && com.google.common.base.Objects.equal((Object)this.keyStore, (Object)other.keyStore) && com.google.common.base.Objects.equal((Object)this.key, (Object)other.key) && com.google.common.base.Objects.equal((Object)this.keyGenerator, (Object)other.keyGenerator) && com.google.common.base.Objects.equal((Object)this.trustStore, (Object)other.trustStore) && com.google.common.base.Objects.equal((Object)this.trust, (Object)other.trust) && com.google.common.base.Objects.equal((Object)this.algorithm, (Object)other.algorithm) && com.google.common.base.Objects.equal((Object)this.protocol, (Object)other.protocol) && com.google.common.base.Objects.equal((Object)this.protocols, (Object)other.protocols) && com.google.common.base.Objects.equal((Object)this.ciphers, (Object)other.ciphers) && com.google.common.base.Objects.equal((Object)this.clientAuth, (Object)other.clientAuth) && com.google.common.base.Objects.equal((Object)this.ignoreTimestampCheckFailure, (Object)other.ignoreTimestampCheckFailure) && com.google.common.base.Objects.equal((Object)this.endpointIdentificationAlgorithm, (Object)other.endpointIdentificationAlgorithm) && com.google.common.base.Objects.equal((Object)this.serverName, (Object)other.serverName) && com.google.common.base.Objects.equal((Object)this.showSSLExceptions, (Object)other.showSSLExceptions) && com.google.common.base.Objects.equal((Object)this.useAsDefault, (Object)other.useAsDefault) && com.google.common.base.Objects.equal((Object)this.useExperimentalHttp2, (Object)other.useExperimentalHttp2);
    }

    public int hashCode() {
        return Objects.hash(this.acme, this.keyStore, this.key, this.keyGenerator, this.trustStore, this.trust, this.algorithm, this.protocol, this.protocols, this.ciphers, this.clientAuth, this.ignoreTimestampCheckFailure, this.endpointIdentificationAlgorithm, this.serverName, this.showSSLExceptions, this.useAsDefault, this.useExperimentalHttp2);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @MCChildElement(order=1)
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public Key getKey() {
        return this.key;
    }

    @MCChildElement(order=2)
    public void setKey(Key key) {
        this.key = key;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @MCChildElement(order=3)
    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    @MCChildElement(order=4)
    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @MCAttribute
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @MCAttribute
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocols() {
        return this.protocols;
    }

    @MCAttribute
    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    @MCAttribute
    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    @MCAttribute
    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isIgnoreTimestampCheckFailure() {
        return this.ignoreTimestampCheckFailure;
    }

    @MCAttribute
    public void setIgnoreTimestampCheckFailure(boolean ignoreTimestampCheckFailure) {
        this.ignoreTimestampCheckFailure = ignoreTimestampCheckFailure;
    }

    public Trust getTrust() {
        return this.trust;
    }

    @MCChildElement(order=5)
    public void setTrust(Trust trust) {
        this.trust = trust;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    @MCAttribute
    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public String getServerName() {
        return this.serverName;
    }

    @MCAttribute
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isShowSSLExceptions() {
        return this.showSSLExceptions;
    }

    @MCAttribute
    public void setShowSSLExceptions(boolean showSSLExceptions) {
        this.showSSLExceptions = showSSLExceptions;
    }

    public boolean isUseAsDefault() {
        return this.useAsDefault;
    }

    @MCAttribute
    public void setUseAsDefault(boolean useAsDefault) {
        this.useAsDefault = useAsDefault;
    }

    public boolean isUseExperimentalHttp2() {
        return this.useExperimentalHttp2;
    }

    @MCAttribute
    public void setUseExperimentalHttp2(boolean useHttp2) {
        this.useExperimentalHttp2 = useHttp2;
    }

    public Acme getAcme() {
        return this.acme;
    }

    @MCChildElement(order=6)
    public void setAcme(Acme acme) {
        this.acme = acme;
    }
}

