/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring;

import com.predic8.membrane.core.config.spring.AbstractParser;
import com.predic8.membrane.core.interceptor.jwt.Jwks;
import java.util.ArrayList;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class JwksParser
extends AbstractParser {
    protected Class<?> getBeanClass(Element element) {
        return Jwks.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setIdIfNeeded(element, parserContext, "jwks");
        this.setPropertyIfSet("jwksUris", "jwksUris", element, builder);
        if (element.hasAttribute("authorizationService")) {
            builder.addPropertyReference("authorizationService", element.getAttribute("authorizationService"));
        }
        builder.addPropertyValue("jwks", new ArrayList());
        this.parseChildren(element, parserContext, builder);
    }

    @Override
    protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
        if (!Jwks.Jwk.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Unknown child class \"" + String.valueOf(clazz) + "\".");
        }
        this.setProperty(builder, "jwks[" + this.incrementCounter(builder, "jwks") + "]", child);
    }
}

