/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring;

import com.predic8.membrane.core.config.spring.BaseLocationApplicationContext;
import com.predic8.membrane.core.config.spring.CheckableBeanFactory;
import com.predic8.membrane.core.config.spring.TrackingApplicationContext;
import com.predic8.membrane.core.util.ExceptionUtil;
import com.predic8.membrane.core.util.URIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.xml.sax.SAXParseException;

public class TrackingFileSystemXmlApplicationContext
extends FileSystemXmlApplicationContext
implements TrackingApplicationContext,
BaseLocationApplicationContext,
CheckableBeanFactory {
    private static final Logger log = LoggerFactory.getLogger((String)TrackingFileSystemXmlApplicationContext.class.getName());
    private final List<File> files = new ArrayList<File>();

    public TrackingFileSystemXmlApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        super(TrackingFileSystemXmlApplicationContext.convertFileURIsToPaths(configLocations), refresh);
    }

    public TrackingFileSystemXmlApplicationContext(String[] configLocations, boolean refresh, ApplicationContext parent) throws BeansException {
        super(TrackingFileSystemXmlApplicationContext.convertFileURIsToPaths(configLocations), refresh, parent);
    }

    private static String[] convertFileURIsToPaths(String[] uris) {
        return (String[])Arrays.stream(uris).map(URIUtil::pathFromFileURI).toArray(String[]::new);
    }

    public Resource getResource(String location) {
        final Resource r = this.string2Resource(location);
        try {
            this.files.add(r.getFile());
        }
        catch (IOException e) {
            log.error("Cloud not init from {}.", (Throwable)e);
            throw new RuntimeException("Cloud not init from %s".formatted(location), e);
        }
        return new Resource(){
            final Resource r2;
            {
                this.r2 = r;
            }

            public boolean exists() {
                return this.r2.exists();
            }

            public InputStream getInputStream() throws IOException {
                return this.r2.getInputStream();
            }

            public boolean isReadable() {
                return this.r2.isReadable();
            }

            public boolean isOpen() {
                return this.r2.isOpen();
            }

            public URL getURL() throws IOException {
                return this.r2.getURL();
            }

            public URI getURI() throws IOException {
                return this.r2.getURI();
            }

            public File getFile() throws IOException {
                return this.r2.getFile();
            }

            public long lastModified() throws IOException {
                return this.r2.lastModified();
            }

            public Resource createRelative(String relativePath) throws IOException {
                Resource r2 = this.r2.createRelative(relativePath);
                TrackingFileSystemXmlApplicationContext.this.files.add(r2.getFile());
                return r2;
            }

            public String getFilename() {
                return this.r2.getFilename();
            }

            public String getDescription() {
                return this.r2.getDescription();
            }

            public long contentLength() throws IOException {
                return this.r2.contentLength();
            }

            public String toString() {
                return this.r2.toString();
            }
        };
    }

    @NotNull
    private Resource string2Resource(String location) {
        if (location.startsWith("/")) {
            return new FileSystemResource(location);
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()));
        }
        if (location.startsWith("file:")) {
            try {
                return new FileUrlResource(location);
            }
            catch (MalformedURLException e) {
                log.error("Failed to resolve file {}. Trying something else.", (Object)location, (Object)e);
            }
        }
        if (location.startsWith("file:") || location.startsWith("http:") || location.startsWith("https:")) {
            try {
                return new UrlResource(location);
            }
            catch (MalformedURLException e) {
                log.error("Failed to resolve file {}. Trying something else.", (Object)location, (Object)e);
            }
        }
        return super.getResource(location);
    }

    @Override
    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public String getBaseLocation() {
        return this.getConfigLocations()[0];
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws BeansException, IOException {
        this.files.clear();
        super.loadBeanDefinitions(beanFactory);
    }

    @Override
    public void checkForInvalidBeanDefinitions() throws CheckableBeanFactory.InvalidConfigurationException {
        try {
            DefaultListableBeanFactory beanFactory = this.createBeanFactory();
            beanFactory.setSerializationId(null);
            this.customizeBeanFactory(beanFactory);
            this.loadBeanDefinitions(beanFactory);
        }
        catch (XmlBeanDefinitionStoreException e) {
            TrackingFileSystemXmlApplicationContext.handleXmlBeanDefinitionStoreException(e);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing bean definition source for " + this.getDisplayName(), (Throwable)ex);
        }
    }

    public static void handleXmlBeanDefinitionStoreException(XmlBeanDefinitionStoreException e) throws CheckableBeanFactory.InvalidConfigurationException {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof SAXParseException) {
            SAXParseException saxpe = (SAXParseException)cause;
            int line = saxpe.getLineNumber();
            throw new CheckableBeanFactory.InvalidConfigurationException(e.getResourceDescription() + " line " + line + ": " + ExceptionUtil.concatMessageAndCauseMessages(cause));
        }
        throw e;
    }

    public String toString() {
        return "Membrane Service Proxy's Spring Context";
    }
}

